/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state.pkg;

import java.io.IOException;
import org.aesh.command.CommandDefinition;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.cmd.CliErrors;
import org.jboss.galleon.cli.cmd.CommandDomain;
import org.jboss.galleon.cli.cmd.state.StateActivators;
import org.jboss.galleon.cli.cmd.state.pkg.AbstractPackageCommand;
import org.jboss.galleon.cli.model.state.State;
import org.jboss.galleon.config.FeaturePackConfig;

@CommandDefinition(name="exclude-package", description="Exclude a package", activator=StateActivators.FPDependentCommandActivator.class)
public class StateExcludePackageCommand
extends AbstractPackageCommand {
    @Override
    protected void runCommand(PmCommandInvocation invoc, State session, FeaturePackConfig config) throws IOException, ProvisioningException, CommandExecutionException {
        try {
            int i = this.getPackage().indexOf("/");
            String name = this.getPackage().substring(i + 1);
            if (config == null) {
                session.excludePackageFromNewTransitive(invoc.getPmSession(), this.getProducer(invoc.getPmSession()), name);
            } else {
                session.excludePackage(invoc.getPmSession(), name, config);
            }
        }
        catch (Exception ex) {
            throw new CommandExecutionException(invoc.getPmSession(), CliErrors.excludeFailed(), ex);
        }
    }

    @Override
    public CommandDomain getDomain() {
        return CommandDomain.EDITING;
    }
}

