/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RandomUtils {
    public static int randomInt(Logger logger, String logMe, Random random, int range) {
        int ret = random.nextInt(range);
        if (logger != null) {
            logger.finest(logMe + " random(" + range + ") = " + ret);
        }
        return ret;
    }

    public static void logArray(Logger logger, String logMe, int[] arr) {
        if (logger != null && logger.isLoggable(Level.FINEST)) {
            StringBuilder sb = new StringBuilder(64);
            sb.append(logMe).append(" random").append(" = [");
            for (int i = 0; i < arr.length; ++i) {
                sb.append(' ').append(arr[i]);
            }
            sb.append(" ]");
            logger.finest(sb.toString());
        }
    }

    public static int[] randomInts(Logger logger, String logMe, Random random, int range, int n) {
        int[] ret = random.ints(n, 0, range).toArray();
        RandomUtils.logArray(logger, logMe, ret);
        return ret;
    }

    public static float randomFloat(Logger logger, String logMe, Random random) {
        float ret = random.nextFloat();
        if (logger != null && logger.isLoggable(Level.FINEST)) {
            logger.finest(logMe + " random(1.0f) = " + ret);
        }
        return ret;
    }

    public static double randomDouble(Logger logger, String logMe, Random random) {
        double ret = random.nextDouble();
        if (logger != null && logger.isLoggable(Level.FINEST)) {
            logger.finest(logMe + " random(1.0) = " + ret);
        }
        return ret;
    }

    public static <T> T getRandomMember(Logger logger, String logMe, List<T> list, Random random) {
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        return list.get(RandomUtils.randomInt(logger, logMe, random, list.size()));
    }

    public static <T> T getRandomMember(Logger logger, String logMe, Stream<T> stream, Random random) {
        return stream == null ? null : (T)RandomUtils.getRandomMember(logger, logMe, stream.collect(Collectors.toList()), random);
    }

    public static void randomShuffle(Logger logger, String logMe, List<?> list, Random random) {
        if (list.size() <= 1 || random == null) {
            return;
        }
        if (logger != null && logger.isLoggable(Level.FINEST)) {
            logger.finest(logMe + " shuffle.");
        }
        Collections.shuffle(list, random);
    }

    public static class RandomIntCache {
        private final Logger logger;
        private final String logMe;
        private final Random random;
        private final int range;
        private final int size;
        private int generation;
        private int[] cache;
        private int index;

        public RandomIntCache(Logger logger, String logMe, Random random, int range, int size) {
            this.logger = logger;
            this.logMe = logMe;
            this.random = random;
            this.range = range;
            this.size = size;
            this.generation = 0;
            this.refill();
        }

        private void refill() {
            this.cache = this.random.ints(this.size, 0, this.range).toArray();
            this.index = 0;
            RandomUtils.logArray(this.logger, this.logMe + "/" + String.valueOf(this.generation), this.cache);
            ++this.generation;
        }

        public int nextInt() {
            if (this.index >= this.size) {
                this.refill();
            }
            return this.cache[this.index++];
        }

        public int nextInt(int tighterRange) {
            return this.nextInt() % tighterRange;
        }
    }
}

