/*
 * Decompiled with CFR 0.152.
 */
package edu.umass.cs.benchlab.har;

import edu.umass.cs.benchlab.har.HarCustomFields;
import edu.umass.cs.benchlab.har.HarDatabaseConfig;
import edu.umass.cs.benchlab.har.HarWarning;
import edu.umass.cs.benchlab.har.ISO8601DateFormatter;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public class HarCookie {
    public static String TABLE_NAME = "cookies";
    private String name;
    private String value;
    private String path;
    private String domain;
    private Date expires;
    private Boolean httpOnly;
    private Boolean secure;
    private String comment;
    private String version;
    private String maxAge;
    private HarCustomFields customFields = new HarCustomFields();

    public HarCookie(String name, String value, String path, String domain, Date expires, boolean httpOnly, boolean secure, String comment) {
        this.name = name;
        this.value = value;
        this.path = path;
        this.domain = domain;
        this.expires = expires;
        this.httpOnly = httpOnly;
        this.secure = secure;
        this.comment = comment;
    }

    public HarCookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public HarCookie(JsonParser jp, List<HarWarning> warnings) throws JsonParseException, IOException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw new JsonParseException("{ missing after \"cookies\" element", jp.getCurrentLocation());
        }
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String name = jp.getCurrentName();
            if ("name".equals(name)) {
                this.setName(jp.getText());
                continue;
            }
            if ("value".equals(name)) {
                this.setValue(jp.getText());
                continue;
            }
            if ("path".equals(name)) {
                this.setPath(jp.getText());
                continue;
            }
            if ("domain".equals(name)) {
                this.setDomain(jp.getText());
                continue;
            }
            if ("expires".equals(name)) {
                try {
                    if (jp.getCurrentName().equals(jp.getText())) {
                        jp.nextToken();
                    }
                    if (jp.getText().contains("NaN")) {
                        this.setExpires(new Date(0L));
                        continue;
                    }
                    this.setExpires(ISO8601DateFormatter.parseDate(jp.getText()));
                    continue;
                }
                catch (ParseException e) {
                    if (warnings != null) {
                        warnings.add(new HarWarning("Invalid date format '" + jp.getText() + "'", jp.getCurrentLocation()));
                        continue;
                    }
                    throw new JsonParseException("Invalid date format '" + jp.getText() + "'", jp.getCurrentLocation());
                }
            }
            if ("httpOnly".equals(name)) {
                this.setHttpOnly(jp.getValueAsBoolean());
                continue;
            }
            if ("secure".equals(name)) {
                this.setSecure(jp.getValueAsBoolean());
                continue;
            }
            if ("comment".equals(name)) {
                this.setComment(jp.getText());
                continue;
            }
            if ("version".equals(name)) {
                this.setVersion(jp.getText());
                continue;
            }
            if ("max-age".equals(name)) {
                this.setMaxAge(jp.getText());
                continue;
            }
            if (name != null && name.startsWith("_")) {
                this.customFields.addHarCustomFields(name, jp);
                continue;
            }
            throw new JsonParseException("Unrecognized field '" + name + "' in page element", jp.getCurrentLocation());
        }
        if (this.name == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing name field in cookie element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing name field in cookie element", jp.getCurrentLocation());
            }
        }
        if (this.value == null) {
            if (warnings != null) {
                warnings.add(new HarWarning("Missing value field in cookie element", jp.getCurrentLocation()));
            } else {
                throw new JsonParseException("Missing value field in cookie element", jp.getCurrentLocation());
            }
        }
    }

    public void writeHar(JsonGenerator g) throws JsonGenerationException, IOException {
        g.writeStartObject();
        g.writeStringField("name", this.name);
        g.writeStringField("value", this.value);
        if (this.path != null) {
            g.writeStringField("path", this.path);
        }
        if (this.domain != null) {
            g.writeStringField("domain", this.domain);
        }
        if (this.expires != null) {
            g.writeStringField("expires", ISO8601DateFormatter.format(this.expires));
        }
        if (this.httpOnly != null) {
            g.writeBooleanField("httpOnly", this.httpOnly.booleanValue());
        }
        if (this.secure != null) {
            g.writeBooleanField("secure", this.secure.booleanValue());
        }
        if (this.comment != null) {
            g.writeStringField("comment", this.comment);
        }
        if (this.version != null) {
            g.writeStringField("version", this.version);
        }
        if (this.maxAge != null) {
            g.writeStringField("maxAge", this.maxAge);
        }
        this.customFields.writeHar(g);
        g.writeEndObject();
    }

    public void writeJDBC(HarDatabaseConfig config, long logId, long requestId, PreparedStatement cookiePs, boolean isRequest) throws SQLException {
        cookiePs.setString(1, this.name);
        cookiePs.setString(2, this.value);
        if (this.path == null) {
            cookiePs.setNull(3, -1);
        } else {
            cookiePs.setString(3, this.path);
        }
        if (this.domain == null) {
            cookiePs.setNull(4, -1);
        } else {
            cookiePs.setString(4, this.domain);
        }
        if (this.expires == null) {
            cookiePs.setNull(5, 93);
        } else {
            cookiePs.setTimestamp(5, new Timestamp(this.expires.getTime()));
        }
        if (this.httpOnly == null) {
            cookiePs.setNull(6, 5);
        } else {
            cookiePs.setInt(6, this.httpOnly != false ? 1 : 0);
        }
        if (this.secure == null) {
            cookiePs.setNull(7, 5);
        } else {
            cookiePs.setInt(7, this.secure != false ? 1 : 0);
        }
        if (this.comment == null) {
            cookiePs.setNull(8, -1);
        } else {
            cookiePs.setString(8, this.comment);
        }
        cookiePs.setInt(9, isRequest ? 1 : 0);
        if (this.version == null) {
            cookiePs.setNull(10, -1);
        } else {
            cookiePs.setString(10, this.version);
        }
        if (this.maxAge == null) {
            cookiePs.setNull(11, -1);
        } else {
            cookiePs.setString(11, this.maxAge);
        }
        cookiePs.setLong(12, requestId);
        cookiePs.executeUpdate();
        ResultSet rs = cookiePs.getGeneratedKeys();
        if (!rs.next()) {
            throw new SQLException("The database did not generate a key for an HarPage entry");
        }
        long cookieId = rs.getLong(1);
        this.customFields.writeCustomFieldsJDBC(config, HarCustomFields.Type.HARCOOKIE, cookieId, logId);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public Date getExpires() {
        return this.expires;
    }

    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(String maxAge) {
        this.maxAge = maxAge;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public HarCustomFields getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(HarCustomFields customFields) {
        this.customFields = customFields;
    }

    public String toString() {
        return "{ \"name\": \"" + this.name + "\", \"value\": \"" + this.value + "\", \"path\": \"" + this.path + "\", \"domain\": \"" + this.domain + "\", \"expires\": \"" + ISO8601DateFormatter.format(this.expires) + "\", \"httpOnly\": " + this.httpOnly + ", \"secure\": " + this.secure + ", \"comment\": \"" + this.comment + "\", " + this.customFields + "}\n";
    }
}

