/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class IntKeyLongValueHashMap
extends BaseHashMap
implements Map<Integer, Long> {
    private Set<Integer> keySet;
    private Collection<Long> values;
    private Set<Map.Entry<Integer, Long>> entries;

    public IntKeyLongValueHashMap() {
        this(8);
    }

    public IntKeyLongValueHashMap(int n) throws IllegalArgumentException {
        super(n, 1, 2, false);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return super.containsKey(n);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(int n) {
        return super.containsKey(n);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object instanceof Long) {
            long l = (Long)object;
            return super.containsValue(l);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(int n) {
        return super.containsValue(n);
    }

    @Override
    public Long get(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            try {
                long l = this.get(n);
                return l;
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public long get(int n) throws NoSuchElementException {
        int n2 = this.getLookup(n);
        if (n2 != -1) {
            return this.longValueTable[n2];
        }
        throw new NoSuchElementException();
    }

    public long get(int n, long l) {
        int n2 = this.getLookup(n);
        if (n2 != -1) {
            return this.longValueTable[n2];
        }
        return l;
    }

    public boolean get(int n, long[] lArray) {
        int n2 = this.getLookup(n);
        if (n2 != -1) {
            lArray[0] = this.longValueTable[n2];
            return true;
        }
        return false;
    }

    @Override
    public Long put(Integer n, Long l) {
        if (n == null || l == null) {
            throw new NullPointerException();
        }
        int n2 = this.size();
        super.addOrUpdate(n.intValue(), l, null, null);
        if (n2 == this.size()) {
            return null;
        }
        return l;
    }

    @Override
    public boolean put(int n, long l) {
        int n2 = this.size();
        super.addOrUpdate(n, l, null, null);
        return n2 != this.size();
    }

    @Override
    public Long remove(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return (Long)super.remove(n, 0L, null, null, false, false);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public boolean remove(int n) {
        Long l = (Long)super.remove(n, 0L, null, null, false, false);
        return l != null;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Long> map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n = (Integer)iterator.next();
            int n2 = n;
            Long l = map.get(n);
            long l2 = l;
            this.put(n2, l2);
        }
    }

    public void putAll(IntKeyIntValueHashMap intKeyIntValueHashMap) {
        PrimitiveIterator primitiveIterator = (PrimitiveIterator)intKeyIntValueHashMap.keySet().iterator();
        while (primitiveIterator.hasNext()) {
            int n = primitiveIterator.nextInt();
            int n2 = intKeyIntValueHashMap.get(n);
            this.put(n, n2);
        }
    }

    public int[] keysToArray(int[] nArray) {
        return this.toIntArray(nArray, true);
    }

    public long[] valuesToArray(long[] lArray) {
        return this.toLongArray(lArray, false);
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<Long> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, Long>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values
    extends AbstractReadOnlyCollection<Long> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            IntKeyLongValueHashMap intKeyLongValueHashMap = IntKeyLongValueHashMap.this;
            intKeyLongValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyLongValueHashMap, false);
        }

        @Override
        public int size() {
            return IntKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet
    extends AbstractReadOnlyCollection<Integer>
    implements Set<Integer> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyLongValueHashMap intKeyLongValueHashMap = IntKeyLongValueHashMap.this;
            intKeyLongValueHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(intKeyLongValueHashMap, true);
        }

        @Override
        public int size() {
            return IntKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(IntKeyLongValueHashMap.this, true);
        }

        @Override
        public Map.Entry<Integer, Long> next() {
            Integer n = super.nextInt();
            Long l = IntKeyLongValueHashMap.this.longValueTable[this.lookup];
            return new MapEntry<Integer, Long>(n, l);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Integer, Long>>
    implements Set<Map.Entry<Integer, Long>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, Long>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntKeyLongValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

