/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.api.ExtendedObjectResource;
import org.traccar.model.Event;
import org.traccar.model.Notification;
import org.traccar.model.Typed;
import org.traccar.model.User;
import org.traccar.notification.MessageException;
import org.traccar.notification.NotificatorManager;
import org.traccar.storage.StorageException;

@Path(value="notifications")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NotificationResource
extends ExtendedObjectResource<Notification> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NotificationResource.class);
    @Inject
    private NotificatorManager notificatorManager;

    public NotificationResource() {
        super(Notification.class);
    }

    @GET
    @Path(value="types")
    public Collection<Typed> get() {
        Field[] fields;
        LinkedList<Typed> types = new LinkedList<Typed>();
        for (Field field : fields = Event.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("TYPE_")) continue;
            try {
                types.add(new Typed(field.get(null).toString()));
            }
            catch (IllegalAccessException | IllegalArgumentException error) {
                LOGGER.warn("Get event types error", (Throwable)error);
            }
        }
        return types;
    }

    @GET
    @Path(value="notificators")
    public Collection<Typed> getNotificators() {
        return this.notificatorManager.getAllNotificatorTypes();
    }

    @POST
    @Path(value="test")
    public Response testMessage() throws MessageException, StorageException {
        User user = this.permissionsService.getUser(this.getUserId());
        for (Typed method : this.notificatorManager.getAllNotificatorTypes()) {
            this.notificatorManager.getNotificator(method.getType()).send(null, user, new Event("test", 0L), null);
        }
        return Response.noContent().build();
    }

    @POST
    @Path(value="test/{notificator}")
    public Response testMessage(@PathParam(value="notificator") String notificator) throws MessageException, StorageException {
        User user = this.permissionsService.getUser(this.getUserId());
        this.notificatorManager.getNotificator(notificator).send(null, user, new Event("test", 0L), null);
        return Response.noContent().build();
    }
}

