/*
 * Decompiled with CFR 0.152.
 */
package org.traccar;

import io.netty.channel.ChannelHandler;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseDataHandler;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.forward.PositionData;
import org.traccar.forward.PositionForwarder;
import org.traccar.forward.ResultHandler;
import org.traccar.model.Device;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

@Singleton
@ChannelHandler.Sharable
public class PositionForwardingHandler
extends BaseDataHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PositionForwardingHandler.class);
    private final CacheManager cacheManager;
    private final Timer timer;
    private final PositionForwarder positionForwarder;
    private final boolean retryEnabled;
    private final int retryDelay;
    private final int retryCount;
    private final int retryLimit;
    private final AtomicInteger deliveryPending;

    @Inject
    public PositionForwardingHandler(Config config, CacheManager cacheManager, Timer timer, @Nullable PositionForwarder positionForwarder) {
        this.cacheManager = cacheManager;
        this.timer = timer;
        this.positionForwarder = positionForwarder;
        this.retryEnabled = config.getBoolean(Keys.FORWARD_RETRY_ENABLE);
        this.retryDelay = config.getInteger(Keys.FORWARD_RETRY_DELAY);
        this.retryCount = config.getInteger(Keys.FORWARD_RETRY_COUNT);
        this.retryLimit = config.getInteger(Keys.FORWARD_RETRY_LIMIT);
        this.deliveryPending = new AtomicInteger();
    }

    @Override
    protected Position handlePosition(Position position) {
        if (this.positionForwarder != null) {
            PositionData positionData = new PositionData();
            positionData.setPosition(position);
            positionData.setDevice(this.cacheManager.getObject(Device.class, position.getDeviceId()));
            new AsyncRequestAndCallback(positionData).send();
        }
        return position;
    }

    class AsyncRequestAndCallback
    implements ResultHandler,
    TimerTask {
        private final PositionData positionData;
        private int retries = 0;

        AsyncRequestAndCallback(PositionData positionData) {
            this.positionData = positionData;
            PositionForwardingHandler.this.deliveryPending.incrementAndGet();
        }

        private void send() {
            PositionForwardingHandler.this.positionForwarder.forward(this.positionData, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void retry(Throwable throwable) {
            int pending;
            boolean scheduled = false;
            try {
                if (PositionForwardingHandler.this.retryEnabled && PositionForwardingHandler.this.deliveryPending.get() <= PositionForwardingHandler.this.retryLimit && this.retries < PositionForwardingHandler.this.retryCount) {
                    this.schedule();
                    scheduled = true;
                }
                pending = scheduled ? PositionForwardingHandler.this.deliveryPending.get() : PositionForwardingHandler.this.deliveryPending.decrementAndGet();
            }
            catch (Throwable throwable2) {
                int pending2 = scheduled ? PositionForwardingHandler.this.deliveryPending.get() : PositionForwardingHandler.this.deliveryPending.decrementAndGet();
                LOGGER.warn("Position forwarding failed: " + pending2 + " pending", throwable);
                throw throwable2;
            }
            LOGGER.warn("Position forwarding failed: " + pending + " pending", throwable);
        }

        private void schedule() {
            PositionForwardingHandler.this.timer.newTimeout((TimerTask)this, (long)PositionForwardingHandler.this.retryDelay * (long)Math.pow(2.0, this.retries++), TimeUnit.MILLISECONDS);
        }

        @Override
        public void onResult(boolean success, Throwable throwable) {
            if (success) {
                PositionForwardingHandler.this.deliveryPending.decrementAndGet();
            } else {
                this.retry(throwable);
            }
        }

        public void run(Timeout timeout) {
            boolean sent = false;
            try {
                if (!timeout.isCancelled()) {
                    this.send();
                    sent = true;
                }
            }
            finally {
                if (!sent) {
                    PositionForwardingHandler.this.deliveryPending.decrementAndGet();
                }
            }
        }
    }
}

