/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.mariadb.jdbc.BasePreparedStatement;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.Connection;
import org.mariadb.jdbc.ParameterMetaData;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Completion;
import org.mariadb.jdbc.client.result.CompleteResult;
import org.mariadb.jdbc.client.result.Result;
import org.mariadb.jdbc.client.result.ResultSetMetaData;
import org.mariadb.jdbc.client.util.Parameters;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.export.Prepare;
import org.mariadb.jdbc.message.ClientMessage;
import org.mariadb.jdbc.message.client.BulkExecutePacket;
import org.mariadb.jdbc.message.client.ExecutePacket;
import org.mariadb.jdbc.message.client.PrepareExecutePacket;
import org.mariadb.jdbc.message.client.PreparePacket;
import org.mariadb.jdbc.message.server.OkPacket;
import org.mariadb.jdbc.message.server.PrepareResultPacket;
import org.mariadb.jdbc.util.ParameterList;

public class ServerPreparedStatement
extends BasePreparedStatement {
    private static final Pattern PREPARABLE_STATEMENT_PATTERN = Pattern.compile("^(SELECT|UPDATE|INSERT|DELETE|REPLACE|DO|CALL)", 2);
    private final boolean canCachePrepStmts;

    public ServerPreparedStatement(String sql, Connection con, ReentrantLock lock, boolean canUseServerTimeout, boolean canUseServerMaxRows, boolean canCachePrepStmts, int autoGeneratedKeys, int resultSetType, int resultSetConcurrency, int defaultFetchSize) throws SQLException {
        super(sql, con, lock, canUseServerTimeout, canUseServerMaxRows, autoGeneratedKeys, resultSetType, resultSetConcurrency, defaultFetchSize);
        this.canCachePrepStmts = canCachePrepStmts;
        Prepare prepare = this.prepareResult = canCachePrepStmts ? con.getContext().getPrepareCache().get(sql, this) : null;
        if (this.prepareResult == null && !PREPARABLE_STATEMENT_PATTERN.matcher(sql).find()) {
            con.getClient().execute(new PreparePacket(sql), this, true);
        }
        this.parameters = new ParameterList();
    }

    protected void executeInternal() throws SQLException {
        this.checkNotClosed();
        this.validParameters();
        this.lock.lock();
        String cmd = this.escapeTimeout(this.sql);
        if (this.prepareResult == null && this.canCachePrepStmts) {
            this.prepareResult = this.con.getContext().getPrepareCache().get(cmd, this);
        }
        try {
            if (this.prepareResult == null && this.con.getContext().permitPipeline()) {
                this.executePipeline(cmd);
            } else {
                this.executeStandard(cmd);
            }
        }
        catch (SQLException e) {
            this.results = null;
            this.currResult = null;
            throw e;
        }
        finally {
            this.localInfileInputStream = null;
            this.lock.unlock();
        }
    }

    private void executePipeline(String cmd) throws SQLException {
        try {
            List<Completion> res = this.con.getClient().execute(new PrepareExecutePacket(cmd, this.parameters, this, this.localInfileInputStream), this, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion, false);
            this.results = res.subList(1, res.size());
        }
        catch (SQLException ex) {
            this.results = null;
            throw ex;
        }
    }

    private void executeStandard(String cmd) throws SQLException {
        if (this.prepareResult == null) {
            if (this.canCachePrepStmts) {
                this.prepareResult = this.con.getContext().getPrepareCache().get(cmd, this);
            }
            if (this.prepareResult == null) {
                this.con.getClient().execute(new PreparePacket(cmd), this, true);
            }
        }
        this.validParameters();
        ExecutePacket execute = new ExecutePacket(this.prepareResult, this.parameters, cmd, this, this.localInfileInputStream);
        this.results = this.con.getClient().execute(execute, this, this.fetchSize, this.maxRows, this.resultSetConcurrency, this.resultSetType, this.closeOnCompletion, false);
    }

    private boolean executeInternalPreparedBatch() throws SQLException {
        this.checkNotClosed();
        String cmd = this.escapeTimeout(this.sql);
        if (this.batchParameters.size() > 1 && this.con.getContext().hasServerCapability(0x400000000L)) {
            boolean possibleLoadLocal = this.con.getContext().hasClientCapability(128L);
            if (possibleLoadLocal) {
                String sqlUpper = this.sql.toUpperCase(Locale.ROOT);
                boolean bl = possibleLoadLocal = sqlUpper.contains(" LOCAL ") && sqlUpper.contains("LOAD") && sqlUpper.contains(" INFILE");
            }
            if (!possibleLoadLocal) {
                Configuration conf = this.con.getContext().getConf();
                this.checkIfInsertCommand();
                if ((this.isCommandInsert.booleanValue() && (conf.useBulkStmts() || conf.useBulkStmtsForInserts()) || !this.isCommandInsert.booleanValue() && conf.useBulkStmts()) && this.autoGeneratedKeys != 1) {
                    this.executeBatchBulk(cmd);
                    return this.isCommandInsert;
                }
                this.executeBatchPipeline(cmd);
                return false;
            }
        }
        this.executeBatchStandard(cmd);
        return false;
    }

    private void executeBatchBulk(String cmd) throws SQLException {
        if (this.prepareResult == null && this.canCachePrepStmts) {
            this.prepareResult = this.con.getContext().getPrepareCache().get(cmd, this);
        }
        try {
            if (this.prepareResult == null) {
                ClientMessage[] packets = new ClientMessage[]{new PreparePacket(cmd), new BulkExecutePacket(null, this.batchParameters, cmd, this)};
                List<Completion> res = this.con.getClient().executePipeline(packets, this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
                this.results = res.get(0) instanceof PrepareResultPacket ? res.subList(1, res.size()) : res;
            } else {
                this.results = this.con.getClient().execute(new BulkExecutePacket(this.prepareResult, this.batchParameters, cmd, this), this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
            }
        }
        catch (SQLException bue) {
            this.results = null;
            throw this.exceptionFactory().createBatchUpdate(Collections.emptyList(), this.batchParameters.size(), bue);
        }
    }

    private void executeBatchPipeline(String cmd) throws SQLException {
        if (this.prepareResult == null && this.canCachePrepStmts) {
            this.prepareResult = this.con.getContext().getPrepareCache().get(cmd, this);
        }
        int maxCmd = 250;
        ArrayList<Completion> res = new ArrayList<Completion>();
        try {
            int index = 0;
            if (this.prepareResult == null) {
                res.addAll(this.executeBunchPrepare(cmd, index, maxCmd));
                index += maxCmd;
            }
            while (index < this.batchParameters.size()) {
                res.addAll(this.executeBunch(cmd, index, maxCmd));
                index += maxCmd;
            }
            this.results = res;
        }
        catch (SQLException bue) {
            this.results = null;
            throw this.exceptionFactory().createBatchUpdate(res, this.batchParameters.size(), bue);
        }
    }

    private List<Completion> executeBunch(String cmd, int index, int maxCmd) throws SQLException {
        int maxCmdToSend = Math.min(this.batchParameters.size() - index, maxCmd);
        ClientMessage[] packets = new ClientMessage[maxCmdToSend];
        for (int i = index; i < index + maxCmdToSend; ++i) {
            packets[i - index] = new ExecutePacket(this.prepareResult, (Parameters)this.batchParameters.get(i), cmd, this, this.localInfileInputStream);
        }
        return this.con.getClient().executePipeline(packets, this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
    }

    private List<Completion> executeBunchPrepare(String cmd, int index, int maxCmd) throws SQLException {
        int maxCmdToSend = Math.min(this.batchParameters.size() - index, maxCmd);
        ClientMessage[] packets = new ClientMessage[maxCmdToSend + 1];
        packets[0] = new PreparePacket(cmd);
        for (int i = index; i < index + maxCmdToSend; ++i) {
            packets[i + 1 - index] = new ExecutePacket(null, (Parameters)this.batchParameters.get(i), cmd, this, this.localInfileInputStream);
        }
        List<Completion> res = this.con.getClient().executePipeline(packets, this, 0, this.maxRows, 1007, 1003, this.closeOnCompletion, false);
        if (res.get(0) instanceof PrepareResultPacket) {
            return res.subList(1, res.size());
        }
        return res;
    }

    private void executeBatchStandard(String cmd) throws SQLException {
        ArrayList<Completion> tmpResults = new ArrayList<Completion>();
        SQLException error = null;
        for (Parameters batchParameter : this.batchParameters) {
            if (this.prepareResult == null) {
                if (this.canCachePrepStmts) {
                    this.prepareResult = this.con.getContext().getPrepareCache().get(cmd, this);
                }
                if (this.prepareResult == null) {
                    this.con.getClient().execute(new PreparePacket(cmd), this, false);
                }
            }
            try {
                ExecutePacket execute = new ExecutePacket(this.prepareResult, batchParameter, cmd, this, this.localInfileInputStream);
                tmpResults.addAll(this.con.getClient().execute(execute, this, false));
            }
            catch (SQLException e) {
                if (error != null) continue;
                error = e;
            }
        }
        if (error != null) {
            throw this.exceptionFactory().createBatchUpdate(tmpResults, this.batchParameters.size(), error);
        }
        this.results = tmpResults;
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeInternal();
        this.handleParameterOutput();
        if (this.results.size() > 0) {
            this.currResult = (Completion)this.results.remove(0);
            return this.currResult instanceof Result;
        }
        return false;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        super.setMaxRows(max);
        if (this.canUseServerMaxRows && this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        super.setLargeMaxRows(max);
        if (this.canUseServerMaxRows && this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        super.setQueryTimeout(seconds);
        if (this.canUseServerTimeout && this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.executeInternal();
        this.handleParameterOutput();
        if (this.results.size() > 0) {
            this.currResult = (Completion)this.results.remove(0);
            if (this.currResult instanceof Result) {
                return (Result)this.currResult;
            }
        }
        return new CompleteResult(new ColumnDecoder[0], new byte[0][], this.con.getContext(), this.resultSetType);
    }

    @Override
    public int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        this.executeInternal();
        this.handleParameterOutput();
        this.currResult = (Completion)this.results.remove(0);
        if (this.currResult instanceof Result) {
            throw this.exceptionFactory().create("the given SQL statement produces an unexpected ResultSet object", "HY000");
        }
        return ((OkPacket)this.currResult).getAffectedRows();
    }

    protected void handleParameterOutput() throws SQLException {
    }

    @Override
    public void addBatch() throws SQLException {
        this.validParameters();
        if (this.batchParameters == null) {
            this.batchParameters = new ArrayList();
        }
        this.batchParameters.add(this.parameters);
        this.parameters = this.parameters.clone();
    }

    protected void validParameters() throws SQLException {
        if (this.prepareResult != null) {
            for (int i = 0; i < this.prepareResult.getParameters().length; ++i) {
                if (this.parameters.containsKey(i)) continue;
                throw this.exceptionFactory().create("Parameter at position " + (i + 1) + " is not set", "07004");
            }
        } else {
            if (this.batchParameters != null && !this.batchParameters.isEmpty() && this.parameters.size() < ((Parameters)this.batchParameters.get(0)).size()) {
                throw this.exceptionFactory().create("batch set of parameters differ from previous set. All parameters must be set", "07004");
            }
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (this.parameters.containsKey(i)) continue;
                throw this.exceptionFactory().create("Parameter at position " + (i + 1) + " is not set", "07004");
            }
        }
    }

    @Override
    public java.sql.ResultSetMetaData getMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this, true);
        }
        return new ResultSetMetaData(this.exceptionFactory(), this.prepareResult.getColumns(), this.con.getContext().getConf(), false);
    }

    @Override
    public java.sql.ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.prepareResult == null) {
            this.con.getClient().execute(new PreparePacket(this.escapeTimeout(this.sql)), this, true);
        }
        return new ParameterMetaData(this.exceptionFactory(), this.prepareResult.getParameters());
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null || this.batchParameters.isEmpty()) {
            return new int[0];
        }
        this.lock.lock();
        try {
            int i;
            boolean wasBulkInsert = this.executeInternalPreparedBatch();
            int[] updates = new int[this.batchParameters.size()];
            if (wasBulkInsert) {
                int numberOfResult = 0;
                for (int i2 = 0; i2 < this.results.size(); ++i2) {
                    numberOfResult += (int)((OkPacket)this.results.get(i2)).getAffectedRows();
                }
                if (numberOfResult == updates.length) {
                    Arrays.fill(updates, 1);
                    this.currResult = (Completion)this.results.remove(0);
                    int[] nArray = updates;
                    return nArray;
                }
            }
            if (this.results.size() != updates.length) {
                for (i = 0; i < updates.length; ++i) {
                    updates[i] = -2;
                }
            } else {
                for (i = 0; i < updates.length; ++i) {
                    updates[i] = this.results.get(i) instanceof OkPacket ? (int)((OkPacket)this.results.get(i)).getAffectedRows() : -2;
                }
            }
            this.currResult = (Completion)this.results.remove(0);
            int[] nArray = updates;
            return nArray;
        }
        catch (SQLException e) {
            this.results = null;
            this.currResult = null;
            throw e;
        }
        finally {
            this.localInfileInputStream = null;
            this.batchParameters.clear();
            this.lock.unlock();
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        this.checkNotClosed();
        if (this.batchParameters == null || this.batchParameters.isEmpty()) {
            return new long[0];
        }
        this.lock.lock();
        try {
            int i;
            boolean wasBulkInsert = this.executeInternalPreparedBatch();
            long[] updates = new long[this.batchParameters.size()];
            if (wasBulkInsert) {
                int numberOfResult = 0;
                for (int i2 = 0; i2 < this.results.size(); ++i2) {
                    numberOfResult += (int)((OkPacket)this.results.get(i2)).getAffectedRows();
                }
                if (numberOfResult == updates.length) {
                    Arrays.fill(updates, 1L);
                    this.currResult = (Completion)this.results.remove(0);
                    long[] lArray = updates;
                    return lArray;
                }
            }
            if (this.results.size() != updates.length) {
                for (i = 0; i < updates.length; ++i) {
                    updates[i] = -2L;
                }
            } else {
                for (i = 0; i < updates.length; ++i) {
                    updates[i] = this.results.get(i) instanceof OkPacket ? ((OkPacket)this.results.get(i)).getAffectedRows() : -2L;
                }
            }
            this.currResult = (Completion)this.results.remove(0);
            long[] lArray = updates;
            return lArray;
        }
        catch (SQLException e) {
            this.results = null;
            this.currResult = null;
            throw e;
        }
        finally {
            this.batchParameters.clear();
            this.lock.unlock();
        }
    }

    private ExceptionFactory exceptionFactory() {
        return this.con.getExceptionFactory().of(this);
    }

    @Override
    public void close() throws SQLException {
        if (this.prepareResult != null) {
            this.prepareResult.decrementUse(this.con.getClient(), this);
            this.prepareResult = null;
        }
        this.con.fireStatementClosed(this);
        super.close();
    }

    public void reset() {
        this.lock.lock();
        try {
            this.prepareResult = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String toString() {
        return "ServerPreparedStatement{" + super.toString() + '}';
    }
}

