/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.Blob;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.FirestoreException;
import com.google.cloud.firestore.FirestoreRpcContext;
import com.google.cloud.firestore.GeoPoint;
import com.google.cloud.firestore.ResourcePath;
import com.google.common.base.Preconditions;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.MapValue;
import com.google.firestore.v1.Value;
import com.google.protobuf.NullValue;
import com.google.protobuf.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class UserDataConverter {
    static final EncodingOptions NO_DELETES = new EncodingOptions(){

        @Override
        public boolean allowDelete(FieldPath fieldPath) {
            return false;
        }

        @Override
        public boolean allowTransform() {
            return true;
        }
    };
    static final EncodingOptions ALLOW_ALL_DELETES = new EncodingOptions(){

        @Override
        public boolean allowDelete(FieldPath fieldPath) {
            return true;
        }

        @Override
        public boolean allowTransform() {
            return true;
        }
    };
    static final EncodingOptions ARGUMENT = new EncodingOptions(){

        @Override
        public boolean allowDelete(FieldPath fieldPath) {
            return false;
        }

        @Override
        public boolean allowTransform() {
            return false;
        }
    };

    private UserDataConverter() {
    }

    @Nullable
    static Value encodeValue(FieldPath path, @Nullable Object sanitizedObject, EncodingOptions options) {
        if (sanitizedObject == FieldValue.DELETE_SENTINEL) {
            Preconditions.checkArgument((boolean)options.allowDelete(path), (String)"FieldValue.delete() is not supported at field '%s'.", (Object)path);
            return null;
        }
        if (sanitizedObject instanceof FieldValue) {
            Preconditions.checkArgument((boolean)options.allowTransform(), (String)("Cannot use " + ((FieldValue)sanitizedObject).getMethodName() + " as an argument at field '%s'."), (Object)path);
            return null;
        }
        if (sanitizedObject == null) {
            return Value.newBuilder().setNullValue(NullValue.NULL_VALUE).build();
        }
        if (sanitizedObject instanceof String) {
            return Value.newBuilder().setStringValue((String)sanitizedObject).build();
        }
        if (sanitizedObject instanceof Integer) {
            return Value.newBuilder().setIntegerValue((long)((Integer)sanitizedObject).intValue()).build();
        }
        if (sanitizedObject instanceof Long) {
            return Value.newBuilder().setIntegerValue(((Long)sanitizedObject).longValue()).build();
        }
        if (sanitizedObject instanceof Double) {
            return Value.newBuilder().setDoubleValue(((Double)sanitizedObject).doubleValue()).build();
        }
        if (sanitizedObject instanceof Float) {
            return Value.newBuilder().setDoubleValue((double)((Float)sanitizedObject).floatValue()).build();
        }
        if (sanitizedObject instanceof Boolean) {
            return Value.newBuilder().setBooleanValue(((Boolean)sanitizedObject).booleanValue()).build();
        }
        if (sanitizedObject instanceof Date) {
            Date date = (Date)sanitizedObject;
            long epochSeconds = TimeUnit.MILLISECONDS.toSeconds(date.getTime());
            long msOffset = date.getTime() - TimeUnit.SECONDS.toMillis(epochSeconds);
            Timestamp.Builder timestampBuilder = com.google.protobuf.Timestamp.newBuilder();
            timestampBuilder.setSeconds(epochSeconds);
            timestampBuilder.setNanos((int)TimeUnit.MILLISECONDS.toNanos(msOffset));
            return Value.newBuilder().setTimestampValue(timestampBuilder.build()).build();
        }
        if (sanitizedObject instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)sanitizedObject;
            return Value.newBuilder().setTimestampValue(timestamp.toProto()).build();
        }
        if (sanitizedObject instanceof List) {
            ArrayValue.Builder res = ArrayValue.newBuilder();
            int i = 0;
            for (Object child : (List)sanitizedObject) {
                Value encodedValue;
                if ((encodedValue = UserDataConverter.encodeValue((FieldPath)path.append(Integer.toString(i++)), child, options)) == null) continue;
                res.addValues(encodedValue);
            }
            return Value.newBuilder().setArrayValue(res.build()).build();
        }
        if (sanitizedObject instanceof GeoPoint) {
            GeoPoint geopoint = (GeoPoint)sanitizedObject;
            return Value.newBuilder().setGeoPointValue(geopoint.toProto()).build();
        }
        if (sanitizedObject instanceof Blob) {
            Blob blob = (Blob)sanitizedObject;
            return Value.newBuilder().setBytesValue(blob.toByteString()).build();
        }
        if (sanitizedObject instanceof Value) {
            return (Value)sanitizedObject;
        }
        if (sanitizedObject instanceof DocumentReference) {
            DocumentReference docRef = (DocumentReference)sanitizedObject;
            return Value.newBuilder().setReferenceValue(docRef.getName()).build();
        }
        if (sanitizedObject instanceof Map) {
            MapValue.Builder res = MapValue.newBuilder();
            Map map = (Map)sanitizedObject;
            for (Map.Entry entry : map.entrySet()) {
                Value encodedValue = UserDataConverter.encodeValue((FieldPath)path.append((String)entry.getKey(), false), entry.getValue(), options);
                if (encodedValue == null) continue;
                res.putFields((String)entry.getKey(), encodedValue);
            }
            if (map.isEmpty() || res.getFieldsCount() != 0) {
                return Value.newBuilder().setMapValue(res.build()).build();
            }
            return null;
        }
        throw FirestoreException.forInvalidArgument("Cannot convert %s to Firestore Value", sanitizedObject);
    }

    static Object decodeValue(FirestoreRpcContext<?> rpcContext, Value v) {
        Value.ValueTypeCase typeCase = v.getValueTypeCase();
        switch (typeCase) {
            case NULL_VALUE: {
                return null;
            }
            case BOOLEAN_VALUE: {
                return v.getBooleanValue();
            }
            case INTEGER_VALUE: {
                return v.getIntegerValue();
            }
            case DOUBLE_VALUE: {
                return v.getDoubleValue();
            }
            case TIMESTAMP_VALUE: {
                return Timestamp.fromProto((com.google.protobuf.Timestamp)v.getTimestampValue());
            }
            case STRING_VALUE: {
                return v.getStringValue();
            }
            case BYTES_VALUE: {
                return Blob.fromByteString(v.getBytesValue());
            }
            case REFERENCE_VALUE: {
                String pathName = v.getReferenceValue();
                return new DocumentReference(rpcContext, ResourcePath.create(pathName));
            }
            case GEO_POINT_VALUE: {
                return new GeoPoint(v.getGeoPointValue().getLatitude(), v.getGeoPointValue().getLongitude());
            }
            case ARRAY_VALUE: {
                ArrayList<Object> list = new ArrayList<Object>();
                List lv = v.getArrayValue().getValuesList();
                for (Value iv : lv) {
                    list.add(UserDataConverter.decodeValue(rpcContext, iv));
                }
                return list;
            }
            case MAP_VALUE: {
                HashMap outputMap = new HashMap();
                Map inputMap = v.getMapValue().getFieldsMap();
                for (Map.Entry entry : inputMap.entrySet()) {
                    outputMap.put(entry.getKey(), UserDataConverter.decodeValue(rpcContext, (Value)entry.getValue()));
                }
                return outputMap;
            }
        }
        throw FirestoreException.forInvalidArgument(String.format("Unknown Value Type: %s", typeCase), new Object[0]);
    }

    static interface EncodingOptions {
        public boolean allowDelete(FieldPath var1);

        public boolean allowTransform();
    }
}

