/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.core.InternalApi;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonDirectCallable;
import com.google.api.gax.httpjson.HttpJsonDirectServerStreamingCallable;
import com.google.api.gax.httpjson.HttpJsonExceptionCallable;
import com.google.api.gax.httpjson.HttpJsonExceptionServerStreamingCallable;
import com.google.api.gax.httpjson.HttpJsonServerStreamingRequestParamCallable;
import com.google.api.gax.httpjson.HttpJsonUnaryRequestParamCallable;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.LongRunningClient;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedUnaryCallable;
import com.google.common.base.Preconditions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class HttpJsonCallableFactory {
    private static final Pattern FULL_METHOD_NAME_REGEX = Pattern.compile("^(.+)\\.(.+)$");

    private HttpJsonCallableFactory() {
    }

    private static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createDirectUnaryCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings) {
        UnaryCallable callable = new HttpJsonDirectCallable<RequestT, ResponseT>(httpJsonCallSettings.getMethodDescriptor(), httpJsonCallSettings.getTypeRegistry());
        if (httpJsonCallSettings.getParamsExtractor() != null) {
            callable = new HttpJsonUnaryRequestParamCallable<RequestT, ResponseT>(callable, httpJsonCallSettings.getParamsExtractor());
        }
        return callable;
    }

    static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUnaryCallable(UnaryCallable<RequestT, ResponseT> innerCallable, UnaryCallSettings<?, ?> callSettings, ClientContext clientContext) {
        UnaryCallable callable = new HttpJsonExceptionCallable(innerCallable, callSettings.getRetryableCodes());
        callable = Callables.retrying(callable, callSettings, (ClientContext)clientContext);
        return callable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createBaseUnaryCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, UnaryCallSettings<?, ?> callSettings, ClientContext clientContext) {
        UnaryCallable callable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        callable = new HttpJsonExceptionCallable<RequestT, ResponseT>(callable, callSettings.getRetryableCodes());
        callable = Callables.retrying(callable, callSettings, (ClientContext)clientContext);
        return callable;
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUnaryCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, UnaryCallSettings<RequestT, ResponseT> callSettings, ClientContext clientContext) {
        TracedUnaryCallable innerCallable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        innerCallable = new TracedUnaryCallable(innerCallable, clientContext.getTracerFactory(), HttpJsonCallableFactory.getSpanName(httpJsonCallSettings.getMethodDescriptor()));
        return HttpJsonCallableFactory.createUnaryCallable(innerCallable, callSettings, clientContext);
    }

    public static <RequestT, ResponseT, PagedListResponseT> UnaryCallable<RequestT, PagedListResponseT> createPagedCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, PagedCallSettings<RequestT, ResponseT, PagedListResponseT> pagedCallSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> callable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        callable = HttpJsonCallableFactory.createUnaryCallable(callable, pagedCallSettings, clientContext);
        UnaryCallable pagedCallable = Callables.paged(callable, pagedCallSettings);
        return pagedCallable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createBatchingCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, BatchingCallSettings<RequestT, ResponseT> batchingCallSettings, ClientContext clientContext) {
        UnaryCallable callable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        callable = HttpJsonCallableFactory.createUnaryCallable(callable, batchingCallSettings, clientContext);
        callable = Callables.batching(callable, batchingCallSettings, (ClientContext)clientContext);
        return callable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT, MetadataT> OperationCallable<RequestT, ResponseT, MetadataT> createOperationCallable(OperationCallSettings<RequestT, ResponseT, MetadataT> operationCallSettings, ClientContext clientContext, LongRunningClient longRunningClient, UnaryCallable<RequestT, OperationSnapshot> operationSnapshotCallable) {
        OperationCallable operationCallable = Callables.longRunningOperation(operationSnapshotCallable, operationCallSettings, (ClientContext)clientContext, (LongRunningClient)longRunningClient);
        return operationCallable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT> ServerStreamingCallable<RequestT, ResponseT> createServerStreamingCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsoncallSettings, ServerStreamingCallSettings<RequestT, ResponseT> streamingCallSettings, ClientContext clientContext) {
        ServerStreamingCallable callable = new HttpJsonDirectServerStreamingCallable<RequestT, ResponseT>(httpJsoncallSettings.getMethodDescriptor());
        if (httpJsoncallSettings.getParamsExtractor() != null) {
            callable = new HttpJsonServerStreamingRequestParamCallable<RequestT, ResponseT>(callable, httpJsoncallSettings.getParamsExtractor());
        }
        callable = new HttpJsonExceptionServerStreamingCallable(callable, streamingCallSettings.getRetryableCodes());
        if (clientContext.getStreamWatchdog() != null) {
            callable = Callables.watched(callable, streamingCallSettings, (ClientContext)clientContext);
        }
        callable = Callables.retrying(callable, streamingCallSettings, (ClientContext)clientContext);
        return callable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    @InternalApi(value="Visible for testing")
    static SpanName getSpanName(@Nonnull ApiMethodDescriptor<?, ?> methodDescriptor) {
        Matcher matcher = FULL_METHOD_NAME_REGEX.matcher(methodDescriptor.getFullMethodName());
        Preconditions.checkArgument((boolean)matcher.matches(), (Object)"Invalid fullMethodName");
        return SpanName.of((String)matcher.group(1), (String)matcher.group(2));
    }
}

