/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.action;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import org.netbeans.api.visual.action.ResizeControlPointResolver;
import org.netbeans.api.visual.action.ResizeProvider;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

public class ResizeCornersControlPointResolver
implements ResizeControlPointResolver {
    public ResizeProvider.ControlPoint resolveControlPoint(Widget widget, Point point) {
        Rectangle rectangle = widget.getBounds();
        Insets insets = widget.getBorder().getInsets();
        Point point2 = GeomUtil.center(rectangle);
        Dimension dimension = new Dimension(Math.max(insets.left, insets.right), Math.max(insets.top, insets.bottom));
        if (point.y >= rectangle.y + rectangle.height - insets.bottom && point.y < rectangle.y + rectangle.height) {
            if (point.x >= rectangle.x + rectangle.width - insets.right && point.x < rectangle.x + rectangle.width) {
                return ResizeProvider.ControlPoint.BOTTOM_RIGHT;
            }
            if (point.x >= rectangle.x && point.x < rectangle.x + insets.left) {
                return ResizeProvider.ControlPoint.BOTTOM_LEFT;
            }
            if (point.x >= point2.x - dimension.height / 2 && point.x < point2.x + dimension.height - dimension.height / 2) {
                return ResizeProvider.ControlPoint.BOTTOM_CENTER;
            }
        } else if (point.y >= rectangle.y && point.y < rectangle.y + insets.top) {
            if (point.x >= rectangle.x + rectangle.width - insets.right && point.x < rectangle.x + rectangle.width) {
                return ResizeProvider.ControlPoint.TOP_RIGHT;
            }
            if (point.x >= rectangle.x && point.x < rectangle.x + insets.left) {
                return ResizeProvider.ControlPoint.TOP_LEFT;
            }
            if (point.x >= point2.x - dimension.height / 2 && point.x < point2.x + dimension.height - dimension.height / 2) {
                return ResizeProvider.ControlPoint.TOP_CENTER;
            }
        } else if (point.y >= point2.y - dimension.width / 2 && point.y < point2.y + dimension.width - dimension.width / 2) {
            if (point.x >= rectangle.x + rectangle.width - insets.right && point.x < rectangle.x + rectangle.width) {
                return ResizeProvider.ControlPoint.CENTER_RIGHT;
            }
            if (point.x >= rectangle.x && point.x < rectangle.x + insets.left) {
                return ResizeProvider.ControlPoint.CENTER_LEFT;
            }
        }
        return null;
    }
}

