/*
 * Decompiled with CFR 0.152.
 */
package tr.runtime;

import java.net.URLEncoder;
import java.util.logging.Logger;
import tr.runtime.Runtime;

public class Email {
    private static final Logger LOG = Logger.getLogger("tr.runtime.email");

    private Email() {
    }

    public static final void email(String to, String subject, String body, String encoding) {
        if (Runtime.macosx) {
            to = Email.urlEncode(to, encoding);
            subject = Email.urlEncode(subject, encoding);
            body = Email.urlEncode(body, encoding);
            Runtime.exec(new String[]{"open", "mailto:" + to + "?subject=" + subject + "&body=" + body});
        } else if (Runtime.linux || Runtime.unix) {
            to = Email.urlEncode(to, encoding);
            subject = Email.urlEncode(subject, encoding);
            body = Email.urlEncode(body, encoding);
            String[] args = new String[]{"xdg-email", "--subject", subject, "--body", body, to};
            Runtime.exec(args);
        } else if (Runtime.win95 || Runtime.win98) {
            to = Email.urlEncode(to, encoding);
            subject = Email.urlEncode(subject, encoding);
            body = Email.urlEncode(body, encoding);
            Runtime.exec(new String[]{"command.com", "/C", "start", "mailto:" + to + "?subject=" + subject + "\"&\"body=" + body});
        } else if (Runtime.windows) {
            to = Email.urlEncode(to, encoding);
            subject = Email.urlEncode(subject, encoding);
            body = Email.urlEncode(body, encoding);
            Runtime.exec(new String[]{"cmd.exe", "/C", "start", "mailto:" + to + "?subject=" + subject + "\"&\"body=" + body});
        } else {
            to = Email.urlEncode(to, encoding);
            subject = Email.urlEncode(subject, encoding);
            body = Email.urlEncode(body, encoding);
            Runtime.exec(new String[]{"email", "mailto:" + to + "?subject=" + subject + "&body=" + body});
        }
    }

    private static String urlEncode(String str, String encoding) {
        try {
            String out = URLEncoder.encode(str, encoding);
            return out.replaceAll("\\+", "%20").replaceAll("\\%0A", "%0D%0A");
        }
        catch (Exception x) {
            return str.replaceAll("\\+", "%20").replaceAll("\\%0A", "%0D%0A");
        }
    }
}

