/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swt.GlazedListsSWT;
import ca.odell.glazedlists.swt.Selectable;
import ca.odell.glazedlists.swt.SelectionManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListViewer<E>
implements ListEventListener<E> {
    private List list = null;
    private TransformedList<E, E> swtThreadSource = null;
    private ILabelProvider labelProvider = null;
    private SelectionManager<E> selection = null;

    public EventListViewer(EventList<E> source, List list) {
        this(source, list, (ILabelProvider)new LabelProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventListViewer(EventList<E> source, List list, ILabelProvider labelProvider) {
        source.getReadWriteLock().readLock().lock();
        try {
            this.swtThreadSource = GlazedListsSWT.swtThreadProxyList(source, list.getDisplay());
            this.list = list;
            this.labelProvider = labelProvider;
            this.selection = new SelectionManager(this.swtThreadSource, new SelectableList());
            int n = this.swtThreadSource.size();
            for (int i = 0; i < n; ++i) {
                this.addRow(i, this.swtThreadSource.get(i));
            }
            this.swtThreadSource.addListEventListener(this);
        }
        finally {
            source.getReadWriteLock().readLock().unlock();
        }
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public List getList() {
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getDeselected() {
        this.swtThreadSource.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.selection.getSelectionList().getDeselected();
            return eventList;
        }
        finally {
            this.swtThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getTogglingDeselected() {
        this.swtThreadSource.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.selection.getSelectionList().getTogglingDeselected();
            return eventList;
        }
        finally {
            this.swtThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getSelected() {
        this.swtThreadSource.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.selection.getSelectionList().getSelected();
            return eventList;
        }
        finally {
            this.swtThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getTogglingSelected() {
        this.swtThreadSource.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.selection.getSelectionList().getTogglingSelected();
            return eventList;
        }
        finally {
            this.swtThreadSource.getReadWriteLock().readLock().unlock();
        }
    }

    private void addRow(int row, Object value) {
        this.list.add(this.labelProvider.getText(value), row);
    }

    private void updateRow(int row, Object value) {
        this.list.setItem(row, this.labelProvider.getText(value));
    }

    private void deleteRow(int row) {
        this.list.remove(row);
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        int firstModified = this.swtThreadSource.size();
        while (listChanges.next()) {
            int changeIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                this.addRow(changeIndex, this.swtThreadSource.get(changeIndex));
                firstModified = Math.min(changeIndex, firstModified);
                continue;
            }
            if (changeType == 1) {
                this.updateRow(changeIndex, this.swtThreadSource.get(changeIndex));
                continue;
            }
            if (changeType != 0) continue;
            this.deleteRow(changeIndex);
            firstModified = Math.min(changeIndex, firstModified);
        }
        this.selection.fireSelectionChanged(firstModified, this.swtThreadSource.size() - 1);
    }

    public void invertSelection() {
        this.selection.getSelectionList().invertSelection();
    }

    public void dispose() {
        this.selection.dispose();
        this.swtThreadSource.removeListEventListener(this);
        this.swtThreadSource.dispose();
    }

    private final class SelectableList
    implements Selectable {
        private SelectableList() {
        }

        public void addSelectionListener(SelectionListener listener) {
            EventListViewer.this.list.addSelectionListener(listener);
        }

        public void removeSelectionListener(SelectionListener listener) {
            EventListViewer.this.list.removeSelectionListener(listener);
        }

        public int getSelectionIndex() {
            return EventListViewer.this.list.getSelectionIndex();
        }

        public int[] getSelectionIndices() {
            return EventListViewer.this.list.getSelectionIndices();
        }

        public int getStyle() {
            return EventListViewer.this.list.getStyle();
        }

        public void select(int index) {
            EventListViewer.this.list.select(index);
        }

        public void deselect(int index) {
            EventListViewer.this.list.deselect(index);
        }
    }
}

