local vstruct = require "vstruct"
local test = require "vstruct.test.common"
local inf = math.huge

-- work around a bug in the Lua constant table optimizer
local z = 0
local nz = -z

local function T(n, buf)
  return test.autotest(tostring(n), "> f8", buf, n)
end

test.group("big-endian ieee doubles")

T(0, "\000\000\000\000\000\000\000\000")
T(4.9406564584124654418e-324, "\000\000\000\000\000\000\000\001")
T(7.4169128616906696301e-309, "\000\005\085\085\085\085\085\085")
T(1.483382572338133926e-308, "\000\010\170\170\170\170\170\170")
T(2.225073858507200889e-308, "\000\015\255\255\255\255\255\255")
T(2.2250738585072013831e-308, "\000\016\000\000\000\000\000\000")
T(2.2250738585072018772e-308, "\000\016\000\000\000\000\000\001")
T(2.9667651446762683461e-308, "\000\021\085\085\085\085\085\085")
T(3.7084564308453353091e-308, "\000\026\170\170\170\170\170\170")
T(4.4501477170144022721e-308, "\000\031\255\255\255\255\255\255")
T(8.9884656743115795386e+307, "\127\224\000\000\000\000\000\000")
T(8.9884656743115815345e+307, "\127\224\000\000\000\000\000\001")
T(1.1984620899082105386e+308, "\127\229\085\085\085\085\085\085")
T(1.4980776123852631234e+308, "\127\234\170\170\170\170\170\170")
T(1.7976931348623157081e+308, "\127\239\255\255\255\255\255\255")
T(4.9406564584124654418e-324, "\000\000\000\000\000\000\000\001")
T(2.225073858507200889e-308, "\000\015\255\255\255\255\255\255")
T(2.2250738585072013831e-308, "\000\016\000\000\000\000\000\000")
T(1.7976931348623157081e+308, "\127\239\255\255\255\255\255\255")
T(inf, "\127\240\000\000\000\000\000\000")
T(0, "\000\000\000\000\000\000\000\000")
T(nz, "\128\000\000\000\000\000\000\000")
T(-4.9406564584124654418e-324, "\128\000\000\000\000\000\000\001")
T(-7.4169128616906696301e-309, "\128\005\085\085\085\085\085\085")
T(-1.483382572338133926e-308, "\128\010\170\170\170\170\170\170")
T(-2.225073858507200889e-308, "\128\015\255\255\255\255\255\255")
T(-2.2250738585072013831e-308, "\128\016\000\000\000\000\000\000")
T(-2.2250738585072018772e-308, "\128\016\000\000\000\000\000\001")
T(-2.9667651446762683461e-308, "\128\021\085\085\085\085\085\085")
T(-3.7084564308453353091e-308, "\128\026\170\170\170\170\170\170")
T(-4.4501477170144022721e-308, "\128\031\255\255\255\255\255\255")
T(-8.9884656743115795386e+307, "\255\224\000\000\000\000\000\000")
T(-8.9884656743115815345e+307, "\255\224\000\000\000\000\000\001")
T(-1.1984620899082105386e+308, "\255\229\085\085\085\085\085\085")
T(-1.4980776123852631234e+308, "\255\234\170\170\170\170\170\170")
T(-1.7976931348623157081e+308, "\255\239\255\255\255\255\255\255")
T(-4.9406564584124654418e-324, "\128\000\000\000\000\000\000\001")
T(-2.225073858507200889e-308, "\128\015\255\255\255\255\255\255")
T(-2.2250738585072013831e-308, "\128\016\000\000\000\000\000\000")
T(-1.7976931348623157081e+308, "\255\239\255\255\255\255\255\255")
T(-inf, "\255\240\000\000\000\000\000\000")
T(nz, "\128\000\000\000\000\000\000\000")
