/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * abs(ivec4(-5, -2, -1, 0)) => ivec4(5, 2, 1, 0)
 * abs(ivec4(1, 2, 5, -5)) => ivec4(1, 2, 5, 5)
 */
#version 130

void main()
{
  float[all(equal(abs(ivec4(-5, -2, -1, 0)), ivec4(5, 2, 1, 0))) ? 1 : -1] array0;
  float[all(equal(abs(ivec4(1, 2, 5, -5)), ivec4(1, 2, 5, 5))) ? 1 : -1] array1;
  gl_FragColor = vec4(array0.length() + array1.length());
}
