"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createConfig$ = createConfig$;

var _operators = require("rxjs/operators");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/*
 * Set up dynamic config defaults
 */
function createConfig$(core, config$, logger) {
  return config$.pipe((0, _operators.map)(config => {
    const {
      osd_server: reportingServer
    } = config;
    const serverInfo = core.http.getServerInfo(); // osd_server.hostname, default to server.host

    const osdServerHostname = reportingServer.hostname ? reportingServer.hostname : serverInfo.hostname; // osd_server.port, default to server.port

    const osdServerPort = reportingServer.port ? reportingServer.port : serverInfo.port; // osd_server.protocol, default to server.protocol

    const osdServerProtocol = reportingServer.protocol ? reportingServer.protocol : serverInfo.protocol;
    return { ...config,
      osd_server: {
        hostname: osdServerHostname,
        port: osdServerPort,
        protocol: osdServerProtocol
      }
    };
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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