"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolutionOptions = exports.VISUALIZATION = exports.SAVED_VISUALIZATION = exports.REDUX_SLICE_METRICS = exports.PPL_DATASOURCES_REQUEST = exports.OBSERVABILITY_CUSTOM_METRIC = exports.DEFAULT_METRIC_WIDTH = exports.DEFAULT_METRIC_HEIGHT = exports.AGGREGATION_OPTIONS = void 0;

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
// requests constants
const VISUALIZATION = 'viz';
exports.VISUALIZATION = VISUALIZATION;
const SAVED_VISUALIZATION = 'savedVisualization';
exports.SAVED_VISUALIZATION = SAVED_VISUALIZATION;
const PPL_DATASOURCES_REQUEST = 'show datasources | where CONNECTOR_TYPE="PROMETHEUS" | fields DATASOURCE_NAME'; // redux

exports.PPL_DATASOURCES_REQUEST = PPL_DATASOURCES_REQUEST;
const OBSERVABILITY_CUSTOM_METRIC = 'CUSTOM_METRICS';
exports.OBSERVABILITY_CUSTOM_METRIC = OBSERVABILITY_CUSTOM_METRIC;
const REDUX_SLICE_METRICS = 'metrics';
exports.REDUX_SLICE_METRICS = REDUX_SLICE_METRICS;
const resolutionOptions = [{
  value: 's',
  text: 'seconds'
}, {
  value: 'm',
  text: 'minutes'
}, {
  value: 'h',
  text: 'hours'
}, {
  value: 'd',
  text: 'days'
}, // { value: 'M', text: 'Months' }, // commenting it here as prometheus doesn't have support
// { value: 'q', text: 'quarters' },
{
  value: 'y',
  text: 'years'
}];
exports.resolutionOptions = resolutionOptions;
const DEFAULT_METRIC_HEIGHT = 2;
exports.DEFAULT_METRIC_HEIGHT = DEFAULT_METRIC_HEIGHT;
const DEFAULT_METRIC_WIDTH = 12;
exports.DEFAULT_METRIC_WIDTH = DEFAULT_METRIC_WIDTH;
const AGGREGATION_OPTIONS = [{
  label: 'avg'
}, {
  label: 'sum'
}, {
  label: 'count'
}, {
  label: 'min'
}, {
  label: 'max'
}];
exports.AGGREGATION_OPTIONS = AGGREGATION_OPTIONS;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm1ldHJpY3MudHMiXSwibmFtZXMiOlsiVklTVUFMSVpBVElPTiIsIlNBVkVEX1ZJU1VBTElaQVRJT04iLCJQUExfREFUQVNPVVJDRVNfUkVRVUVTVCIsIk9CU0VSVkFCSUxJVFlfQ1VTVE9NX01FVFJJQyIsIlJFRFVYX1NMSUNFX01FVFJJQ1MiLCJyZXNvbHV0aW9uT3B0aW9ucyIsInZhbHVlIiwidGV4dCIsIkRFRkFVTFRfTUVUUklDX0hFSUdIVCIsIkRFRkFVTFRfTUVUUklDX1dJRFRIIiwiQUdHUkVHQVRJT05fT1BUSU9OUyIsImxhYmVsIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFFQTtBQUNPLE1BQU1BLGFBQWEsR0FBRyxLQUF0Qjs7QUFDQSxNQUFNQyxtQkFBbUIsR0FBRyxvQkFBNUI7O0FBQ0EsTUFBTUMsdUJBQXVCLEdBQ2xDLCtFQURLLEMsQ0FHUDs7O0FBRU8sTUFBTUMsMkJBQTJCLEdBQUcsZ0JBQXBDOztBQUNBLE1BQU1DLG1CQUFtQixHQUFHLFNBQTVCOztBQUVBLE1BQU1DLGlCQUFpQixHQUFHLENBQy9CO0FBQUVDLEVBQUFBLEtBQUssRUFBRSxHQUFUO0FBQWNDLEVBQUFBLElBQUksRUFBRTtBQUFwQixDQUQrQixFQUUvQjtBQUFFRCxFQUFBQSxLQUFLLEVBQUUsR0FBVDtBQUFjQyxFQUFBQSxJQUFJLEVBQUU7QUFBcEIsQ0FGK0IsRUFHL0I7QUFBRUQsRUFBQUEsS0FBSyxFQUFFLEdBQVQ7QUFBY0MsRUFBQUEsSUFBSSxFQUFFO0FBQXBCLENBSCtCLEVBSS9CO0FBQUVELEVBQUFBLEtBQUssRUFBRSxHQUFUO0FBQWNDLEVBQUFBLElBQUksRUFBRTtBQUFwQixDQUorQixFQUsvQjtBQUNBO0FBQ0E7QUFBRUQsRUFBQUEsS0FBSyxFQUFFLEdBQVQ7QUFBY0MsRUFBQUEsSUFBSSxFQUFFO0FBQXBCLENBUCtCLENBQTFCOztBQVVBLE1BQU1DLHFCQUFxQixHQUFHLENBQTlCOztBQUNBLE1BQU1DLG9CQUFvQixHQUFHLEVBQTdCOztBQUVBLE1BQU1DLG1CQUFtQixHQUFHLENBQ2pDO0FBQUVDLEVBQUFBLEtBQUssRUFBRTtBQUFULENBRGlDLEVBRWpDO0FBQUVBLEVBQUFBLEtBQUssRUFBRTtBQUFULENBRmlDLEVBR2pDO0FBQUVBLEVBQUFBLEtBQUssRUFBRTtBQUFULENBSGlDLEVBSWpDO0FBQUVBLEVBQUFBLEtBQUssRUFBRTtBQUFULENBSmlDLEVBS2pDO0FBQUVBLEVBQUFBLEtBQUssRUFBRTtBQUFULENBTGlDLENBQTVCIiwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG4vLyByZXF1ZXN0cyBjb25zdGFudHNcbmV4cG9ydCBjb25zdCBWSVNVQUxJWkFUSU9OID0gJ3Zpeic7XG5leHBvcnQgY29uc3QgU0FWRURfVklTVUFMSVpBVElPTiA9ICdzYXZlZFZpc3VhbGl6YXRpb24nO1xuZXhwb3J0IGNvbnN0IFBQTF9EQVRBU09VUkNFU19SRVFVRVNUID1cbiAgJ3Nob3cgZGF0YXNvdXJjZXMgfCB3aGVyZSBDT05ORUNUT1JfVFlQRT1cIlBST01FVEhFVVNcIiB8IGZpZWxkcyBEQVRBU09VUkNFX05BTUUnO1xuXG4vLyByZWR1eFxuXG5leHBvcnQgY29uc3QgT0JTRVJWQUJJTElUWV9DVVNUT01fTUVUUklDID0gJ0NVU1RPTV9NRVRSSUNTJztcbmV4cG9ydCBjb25zdCBSRURVWF9TTElDRV9NRVRSSUNTID0gJ21ldHJpY3MnO1xuXG5leHBvcnQgY29uc3QgcmVzb2x1dGlvbk9wdGlvbnMgPSBbXG4gIHsgdmFsdWU6ICdzJywgdGV4dDogJ3NlY29uZHMnIH0sXG4gIHsgdmFsdWU6ICdtJywgdGV4dDogJ21pbnV0ZXMnIH0sXG4gIHsgdmFsdWU6ICdoJywgdGV4dDogJ2hvdXJzJyB9LFxuICB7IHZhbHVlOiAnZCcsIHRleHQ6ICdkYXlzJyB9LFxuICAvLyB7IHZhbHVlOiAnTScsIHRleHQ6ICdNb250aHMnIH0sIC8vIGNvbW1lbnRpbmcgaXQgaGVyZSBhcyBwcm9tZXRoZXVzIGRvZXNuJ3QgaGF2ZSBzdXBwb3J0XG4gIC8vIHsgdmFsdWU6ICdxJywgdGV4dDogJ3F1YXJ0ZXJzJyB9LFxuICB7IHZhbHVlOiAneScsIHRleHQ6ICd5ZWFycycgfSxcbl07XG5cbmV4cG9ydCBjb25zdCBERUZBVUxUX01FVFJJQ19IRUlHSFQgPSAyO1xuZXhwb3J0IGNvbnN0IERFRkFVTFRfTUVUUklDX1dJRFRIID0gMTI7XG5cbmV4cG9ydCBjb25zdCBBR0dSRUdBVElPTl9PUFRJT05TID0gW1xuICB7IGxhYmVsOiAnYXZnJyB9LFxuICB7IGxhYmVsOiAnc3VtJyB9LFxuICB7IGxhYmVsOiAnY291bnQnIH0sXG4gIHsgbGFiZWw6ICdtaW4nIH0sXG4gIHsgbGFiZWw6ICdtYXgnIH0sXG5dO1xuIl19