"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiHeaderSection", {
  enumerable: true,
  get: function get() {
    return _header_section.EuiHeaderSection;
  }
});
exports.OuiHeaderSection = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _header_section = require("../../../eui_components/header/header_section/header_section");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var sideToClassNameMap = {
  left: 'ouiHeaderSection--left',
  right: 'ouiHeaderSection--right'
};

var OuiHeaderSection = function OuiHeaderSection(_ref) {
  var _ref$side = _ref.side,
      side = _ref$side === void 0 ? 'left' : _ref$side,
      children = _ref.children,
      className = _ref.className,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? false : _ref$grow,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["side", "children", "className", "grow"]);
  var classes = (0, _classnames.default)('ouiHeaderSection', {
    'ouiHeaderSection--grow': grow,
    'ouiHeaderSection--dontGrow': !grow
  }, sideToClassNameMap[side], className);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), children);
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiHeaderSection = OuiHeaderSection;
OuiHeaderSection.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  side: _propTypes.default.oneOf(["left", "right"]),
  grow: _propTypes.default.bool
};