/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.builtins.RegExpPrototypeBuiltins;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultIndicesArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.builtins.JSRegExpGroupsObject;
import com.oracle.truffle.js.runtime.builtins.JSRegExpObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyProxy;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;
import com.oracle.truffle.js.runtime.util.TRegexUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class JSRegExp
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final JSRegExp INSTANCE = new JSRegExp();
    public static final String CLASS_NAME = "RegExp";
    public static final String PROTOTYPE_NAME = "RegExp.prototype";
    public static final String MULTILINE = "multiline";
    public static final String GLOBAL = "global";
    public static final String IGNORE_CASE = "ignoreCase";
    public static final String STICKY = "sticky";
    public static final String UNICODE = "unicode";
    public static final String DOT_ALL = "dotAll";
    public static final String SOURCE = "source";
    public static final String FLAGS = "flags";
    public static final String LAST_INDEX = "lastIndex";
    public static final String INPUT = "input";
    public static final String GROUPS = "groups";
    public static final String INDEX = "index";
    public static final String INDICES = "indices";
    public static final PropertyProxy LAZY_INDEX_PROXY = new LazyRegexResultIndexProxyProperty();
    public static final HiddenKey GROUPS_RESULT_ID = new HiddenKey("regexResult");
    private static final Comparator<Pair<Integer, String>> NAMED_GROUPS_COMPARATOR = new Comparator<Pair<Integer, String>>(){

        @Override
        public int compare(Pair<Integer, String> group1, Pair<Integer, String> group2) {
            return group1.getFirst() - group2.getFirst();
        }
    };

    private JSRegExp() {
    }

    public static Object getCompiledRegex(DynamicObject thisObj) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return ((JSRegExpObject)thisObj).getCompiledRegex();
    }

    public static JSObjectFactory getGroupsFactory(DynamicObject thisObj) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return ((JSRegExpObject)thisObj).getGroupsFactory();
    }

    public static Object getRealm(DynamicObject thisObj) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return ((JSRegExpObject)thisObj).getRealm();
    }

    public static boolean getLegacyFeaturesEnabled(DynamicObject thisObj) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return ((JSRegExpObject)thisObj).getLegacyFeaturesEnabled();
    }

    public static DynamicObject create(JSContext ctx, Object compiledRegex) {
        JSObjectFactory groupsFactory = JSRegExp.computeGroupsFactory(ctx, compiledRegex);
        DynamicObject obj = JSRegExp.create(ctx, compiledRegex, groupsFactory);
        JSObjectUtil.putDataProperty(ctx, obj, LAST_INDEX, 0, JSAttributes.notConfigurableNotEnumerableWritable());
        assert (JSRegExp.isJSRegExp(obj));
        return obj;
    }

    public static DynamicObject create(JSContext context, Object compiledRegex, JSObjectFactory groupsFactory) {
        return JSRegExp.create(context, compiledRegex, groupsFactory, true);
    }

    public static DynamicObject create(JSContext context, Object compiledRegex, JSObjectFactory groupsFactory, boolean legacyFeaturesEnabled) {
        JSRealm realm = context.getRealm();
        DynamicObject regExp = JSRegExpObject.create(realm, context.getRegExpFactory(), compiledRegex, groupsFactory, legacyFeaturesEnabled);
        assert (JSRegExp.isJSRegExp(regExp));
        return context.trackAllocation(regExp);
    }

    private static void initialize(JSContext ctx, DynamicObject regExp, Object regex) {
        ((JSRegExpObject)regExp).setCompiledRegex(regex);
        ((JSRegExpObject)regExp).setGroupsFactory(JSRegExp.computeGroupsFactory(ctx, regex));
    }

    public static void updateCompilation(JSContext ctx, DynamicObject thisObj, Object regex) {
        assert (JSRegExp.isJSRegExp(thisObj) && regex != null);
        JSRegExp.initialize(ctx, thisObj, regex);
    }

    public static DynamicObject createGroupsObject(JSContext context, JSObjectFactory groupsFactory, Object regexResult, String input, boolean isIndices) {
        JSRealm realm = context.getRealm();
        DynamicObject obj = JSRegExpGroupsObject.create(realm, groupsFactory, regexResult, input, isIndices);
        return context.trackAllocation(obj);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSObjectFactory computeGroupsFactory(JSContext ctx, Object compiledRegex) {
        Object namedCaptureGroups = TRegexUtil.InteropReadMemberNode.getUncached().execute(compiledRegex, GROUPS);
        if (TRegexUtil.InteropIsNullNode.getUncached().execute(namedCaptureGroups)) {
            return null;
        }
        return JSRegExp.buildGroupsFactory(ctx, namedCaptureGroups);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObjectFactory buildGroupsFactory(JSContext ctx, Object namedCaptureGroups) {
        int groupIndex;
        Shape groupsShape = ctx.getRegExpGroupsEmptyShape();
        List<Object> keys = JSInteropUtil.keys(namedCaptureGroups);
        ArrayList<Pair<Integer, String>> pairs = new ArrayList<Pair<Integer, String>>(keys.size());
        for (Object key : keys) {
            String string = (String)key;
            groupIndex = TRegexUtil.InteropReadIntMemberNode.getUncached().execute(namedCaptureGroups, string);
            pairs.add(new Pair<Integer, String>(groupIndex, string));
        }
        Collections.sort(pairs, NAMED_GROUPS_COMPARATOR);
        Shape.DerivedBuilder builder = Shape.newBuilder((Shape)groupsShape);
        for (Pair pair : pairs) {
            groupIndex = (Integer)pair.getFirst();
            String groupName = (String)pair.getSecond();
            builder.addConstantProperty((Object)groupName, (Object)new LazyNamedCaptureGroupProperty(groupName, groupIndex), JSAttributes.getDefault() | 0x10);
        }
        groupsShape = builder.build();
        return JSObjectFactory.createBound(ctx, Null.instance, groupsShape);
    }

    @CompilerDirectives.TruffleBoundary
    public static String prototypeToString(DynamicObject thisObj) {
        Object regex = JSRegExp.getCompiledRegex(thisObj);
        TRegexUtil.InteropReadStringMemberNode readString = TRegexUtil.InteropReadStringMemberNode.getUncached();
        String pattern = readString.execute(regex, "pattern");
        if (pattern.length() == 0) {
            pattern = "(?:)";
        }
        String flags = readString.execute(TRegexUtil.InteropReadMemberNode.getUncached().execute(regex, FLAGS), SOURCE);
        return "/" + pattern + '/' + flags;
    }

    public static boolean isJSRegExp(Object obj) {
        return obj instanceof JSRegExpObject;
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        DynamicObject prototype;
        JSContext ctx = realm.getContext();
        if (ctx.getEcmaScriptVersion() < 6) {
            Shape shape = JSShape.createPrototypeShape(realm.getContext(), INSTANCE, realm.getObjectPrototype());
            prototype = JSRegExpObject.create(shape, JSRegExp.compileEarly(realm, "", ""), realm);
            JSObjectUtil.setOrVerifyPrototype(ctx, prototype, realm.getObjectPrototype());
            JSObjectUtil.putDataProperty(ctx, prototype, LAST_INDEX, 0, JSAttributes.notConfigurableNotEnumerableWritable());
        } else {
            prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        }
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, SOURCE);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, FLAGS);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, MULTILINE);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, GLOBAL);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, IGNORE_CASE);
        if (ctx.getEcmaScriptVersion() >= 6) {
            JSRegExp.putRegExpPropertyAccessor(realm, prototype, STICKY);
            JSRegExp.putRegExpPropertyAccessor(realm, prototype, UNICODE);
        }
        if (ctx.getEcmaScriptVersion() >= 9) {
            JSRegExp.putRegExpPropertyAccessor(realm, prototype, DOT_ALL);
        }
        JSObjectUtil.putConstructorProperty(ctx, prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, RegExpPrototypeBuiltins.BUILTINS);
        return prototype;
    }

    private static void putRegExpPropertyAccessor(JSRealm realm, DynamicObject prototype, String name) {
        DynamicObject getter = realm.lookupFunction(RegExpPrototypeBuiltins.RegExpPrototypeGetterBuiltins.BUILTINS, name);
        JSObjectUtil.putBuiltinAccessorProperty(prototype, (Object)name, getter, Undefined.instance);
    }

    private static Object compileEarly(JSRealm realm, String pattern, String flags) {
        return TRegexUtil.CompileRegexNode.getUncached().execute(JSContext.createTRegexEngine(realm.getEnv(), realm.getContext().getContextOptions()), pattern, flags);
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, DynamicObject thisObj) {
        return JSObjectUtil.getProtoChildShape(thisObj, INSTANCE, ctx);
    }

    public static Shape makeInitialGroupsObjectShape(JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        return JSShape.createRootWithNullProto(context, JSOrdinary.BARE_INSTANCE);
    }

    @Override
    public void fillConstructor(JSRealm realm, DynamicObject constructor) {
        JSRegExp.putConstructorSpeciesGetter(realm, constructor);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    public String getBuiltinToStringTag(DynamicObject object) {
        return this.getClassName(object);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String toDisplayStringImpl(DynamicObject obj, int depth, boolean allowSideEffects, JSContext context) {
        if (context.isOptionNashornCompatibilityMode()) {
            return "[RegExp " + JSRegExp.prototypeToString(obj) + "]";
        }
        return JSRegExp.prototypeToString(obj);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getRegExpPrototype();
    }

    @CompilerDirectives.TruffleBoundary
    public static CharSequence escapeRegExpPattern(CharSequence pattern) {
        if (pattern.length() == 0) {
            return "(?:)";
        }
        int extraChars = JSRegExp.escapeRegExpExtraCharCount(pattern);
        if (extraChars == 0) {
            return pattern;
        }
        return JSRegExp.escapeRegExpPattern(pattern, extraChars);
    }

    private static int escapeRegExpExtraCharCount(CharSequence pattern) {
        int extraChars = 0;
        boolean insideCharClass = false;
        block12: for (int i = 0; i < pattern.length(); ++i) {
            switch (pattern.charAt(i)) {
                case '\\': {
                    assert (i + 1 < pattern.length());
                    switch (pattern.charAt(++i)) {
                        case '\n': 
                        case '\r': {
                            extraChars = Math.max(extraChars, 1);
                            break;
                        }
                        case '\u2028': 
                        case '\u2029': {
                            extraChars += 4;
                        }
                    }
                    continue block12;
                }
                case '\n': 
                case '\r': {
                    ++extraChars;
                    continue block12;
                }
                case '\u2028': 
                case '\u2029': {
                    extraChars += 5;
                    continue block12;
                }
                case '/': {
                    if (insideCharClass) continue block12;
                    ++extraChars;
                    continue block12;
                }
                case '[': {
                    insideCharClass = true;
                    continue block12;
                }
                case ']': {
                    insideCharClass = false;
                }
            }
        }
        return extraChars;
    }

    @CompilerDirectives.TruffleBoundary
    private static String escapeRegExpPattern(CharSequence pattern, int extraChars) {
        StringBuilder sb = new StringBuilder(pattern.length() + extraChars);
        boolean insideCharClass = false;
        block16: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '\\': {
                    assert (i + 1 < pattern.length());
                    sb.append(c);
                    c = pattern.charAt(++i);
                    switch (c) {
                        case '\n': {
                            sb.append('n');
                            continue block16;
                        }
                        case '\r': {
                            sb.append('r');
                            continue block16;
                        }
                        case '\u2028': {
                            sb.append("u2028");
                            continue block16;
                        }
                        case '\u2029': {
                            sb.append("u2029");
                            continue block16;
                        }
                    }
                    sb.append(c);
                    continue block16;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block16;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block16;
                }
                case '\u2028': {
                    sb.append("\\u2028");
                    continue block16;
                }
                case '\u2029': {
                    sb.append("\\u2029");
                    continue block16;
                }
                case '/': {
                    if (!insideCharClass) {
                        sb.append("\\/");
                        continue block16;
                    }
                    sb.append('/');
                    continue block16;
                }
                case '[': {
                    insideCharClass = true;
                    sb.append(c);
                    continue block16;
                }
                case ']': {
                    insideCharClass = false;
                    sb.append(c);
                    continue block16;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static class LazyNamedCaptureGroupProperty
    implements PropertyProxy {
        private final String groupName;
        private final int groupIndex;
        private final ConditionProfile isIndicesObject = ConditionProfile.createBinaryProfile();
        private final TRegexUtil.TRegexMaterializeResultNode materializeNode = TRegexUtil.TRegexMaterializeResultNode.getUncached();

        public LazyNamedCaptureGroupProperty(String groupName, int groupIndex) {
            this.groupName = groupName;
            this.groupIndex = groupIndex;
        }

        public int getGroupIndex() {
            return this.groupIndex;
        }

        @Override
        public Object get(DynamicObject object) {
            JSRegExpGroupsObject groups = (JSRegExpGroupsObject)object;
            Object regexResult = groups.getRegexResult();
            if (this.isIndicesObject.profile(groups.isIndices())) {
                return LazyRegexResultIndicesArray.getIntIndicesArray(JavaScriptLanguage.getCurrentJSRealm().getContext(), TRegexUtil.TRegexResultAccessor.getUncached(), regexResult, this.groupIndex);
            }
            String input = groups.getInputString();
            return this.materializeNode.materializeGroup(regexResult, this.groupIndex, input);
        }

        @Override
        public boolean set(DynamicObject object, Object value) {
            JSObjectUtil.defineDataProperty(object, this.groupName, value, JSAttributes.getDefault());
            return true;
        }
    }

    public static class LazyRegexResultIndexProxyProperty
    implements PropertyProxy {
        @Override
        public Object get(DynamicObject object) {
            return TRegexUtil.InvokeGetGroupBoundariesMethodNode.getUncached().execute(JSAbstractArray.arrayGetRegexResult(object, DynamicObjectLibrary.getUncached()), "getStart", 0);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean set(DynamicObject object, Object value) {
            JSObjectUtil.defineDataProperty(object, JSRegExp.INDEX, value, JSAttributes.getDefault());
            return true;
        }
    }
}

