/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.parser.json;

public class JSONParserUtil {
    public static String quote(String value) {
        StringBuilder product = new StringBuilder();
        product.append("\"");
        for (char ch : value.toCharArray()) {
            if (ch < ' ') {
                if (ch == '\b') {
                    product.append("\\b");
                    continue;
                }
                if (ch == '\f') {
                    product.append("\\f");
                    continue;
                }
                if (ch == '\n') {
                    product.append("\\n");
                    continue;
                }
                if (ch == '\r') {
                    product.append("\\r");
                    continue;
                }
                if (ch == '\t') {
                    product.append("\\t");
                    continue;
                }
                product.append(JSONParserUtil.unicodeEscape(ch));
                continue;
            }
            if (ch == '\\') {
                product.append("\\\\");
                continue;
            }
            if (ch == '\"') {
                product.append("\\\"");
                continue;
            }
            product.append(ch);
        }
        product.append("\"");
        return product.toString();
    }

    private static String unicodeEscape(char ch) {
        StringBuilder sb = new StringBuilder();
        sb.append("\\u");
        String hex = Integer.toHexString(ch);
        for (int i = hex.length(); i < 4; ++i) {
            sb.append('0');
        }
        sb.append(hex);
        return sb.toString();
    }
}

