/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javahelp;

import com.sun.java.help.impl.ViewAwareComponent;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.netbeans.modules.javahelp.CopyLinkLocationAction;
import org.netbeans.modules.javahelp.HyperlinkEventProcessor;
import org.netbeans.modules.javahelp.Utils;
import org.openide.awt.HtmlBrowser;
import org.openide.util.NbBundle;

public class BrowserDisplayer
extends JButton
implements ActionListener,
ViewAwareComponent,
CopyLinkLocationAction.LinkOwner {
    private View myView;
    private SimpleAttributeSet textAttribs;
    private HTMLDocument doc;
    private URL base;
    private static final Cursor handCursor = Cursor.getPredefinedCursor(12);
    private Cursor origCursor;
    private JPopupMenu popupMenu;
    private String content = "";

    public BrowserDisplayer() {
        this.setMargin(new Insets(0, 0, 0, 0));
        this.createLinkLabel();
        this.addActionListener(this);
        this.origCursor = this.getCursor();
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(BrowserDisplayer.class, (String)"ACSD_Label"));
        this.popupMenu = HyperlinkEventProcessor.getPopupMenu(new CopyLinkLocationAction(this));
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                BrowserDisplayer.this.setToolTipText(null);
                if (Utils.isMouseRightClick(e)) {
                    Utils.showPopupMenu(e, BrowserDisplayer.this.popupMenu, BrowserDisplayer.this);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                BrowserDisplayer.this.setCursor(handCursor);
                BrowserDisplayer.this.setToolTipText(BrowserDisplayer.this.getContent());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                BrowserDisplayer.this.setCursor(BrowserDisplayer.this.origCursor);
                BrowserDisplayer.this.setToolTipText(null);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    public void setViewData(View v) {
        this.myView = v;
        this.doc = (HTMLDocument)this.myView.getDocument();
        this.base = this.doc.getBase();
        Font font = this.getFont();
        this.textAttribs = new SimpleAttributeSet();
        this.textAttribs.removeAttribute(StyleConstants.FontSize);
        this.textAttribs.removeAttribute(StyleConstants.Bold);
        this.textAttribs.removeAttribute(StyleConstants.Italic);
        this.textAttribs.addAttribute(StyleConstants.FontFamily, font.getName());
        this.textAttribs.addAttribute(StyleConstants.FontSize, new Integer(font.getSize()));
        this.textAttribs.addAttribute(StyleConstants.Bold, font.isBold());
        this.textAttribs.addAttribute(StyleConstants.Italic, font.isItalic());
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContent() {
        return this.content;
    }

    private void createLinkLabel() {
        this.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setAlignmentY(this.getPreferredAlignmentY());
        this.setContentAreaFilled(false);
        this.setHorizontalAlignment(2);
        this.setBackground(UIManager.getColor("EditorPane.background"));
        if (this.textAttribs != null && this.textAttribs.isDefined(StyleConstants.Foreground)) {
            this.setForeground((Color)this.textAttribs.getAttribute(StyleConstants.Foreground));
        } else {
            this.setForeground(Color.blue);
        }
        this.invalidate();
    }

    private float getPreferredAlignmentY() {
        Font font = this.getFont();
        FontMetrics fm = this.getToolkit().getFontMetrics(font);
        float h = fm.getHeight();
        float d = fm.getDescent();
        return (h - d) / h;
    }

    public void setTextFontFamily(String family) {
        this.textAttribs.removeAttribute(StyleConstants.FontFamily);
        this.textAttribs.addAttribute(StyleConstants.FontFamily, family);
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        Font font = this.getFont();
    }

    public String getTextFontFamily() {
        return StyleConstants.getFontFamily(this.textAttribs);
    }

    public void setTextFontSize(String size) {
        int newsize;
        StyleSheet css = this.doc.getStyleSheet();
        try {
            if (size.equals("xx-small")) {
                newsize = (int)css.getPointSize(0);
            } else if (size.equals("x-small")) {
                newsize = (int)css.getPointSize(1);
            } else if (size.equals("small")) {
                newsize = (int)css.getPointSize(2);
            } else if (size.equals("medium")) {
                newsize = (int)css.getPointSize(3);
            } else if (size.equals("large")) {
                newsize = (int)css.getPointSize(4);
            } else if (size.equals("x-large")) {
                newsize = (int)css.getPointSize(5);
            } else if (size.equals("xx-large")) {
                newsize = (int)css.getPointSize(6);
            } else if (size.equals("bigger")) {
                newsize = (int)css.getPointSize("+1");
            } else if (size.equals("smaller")) {
                newsize = (int)css.getPointSize("-1");
            } else if (size.endsWith("pt")) {
                String sz = size.substring(0, size.length() - 2);
                newsize = Integer.parseInt(sz);
            } else {
                newsize = (int)css.getPointSize(size);
            }
        }
        catch (NumberFormatException nfe) {
            return;
        }
        if (newsize == 0) {
            return;
        }
        this.textAttribs.removeAttribute(StyleConstants.FontSize);
        this.textAttribs.addAttribute(StyleConstants.FontSize, new Integer(newsize));
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        Font font = this.getFont();
    }

    public String getTextFontSize() {
        return Integer.toString(StyleConstants.getFontSize(this.textAttribs));
    }

    public void setTextFontWeight(String weight) {
        boolean isBold = false;
        isBold = "bold".equals(weight);
        this.textAttribs.removeAttribute(StyleConstants.Bold);
        this.textAttribs.addAttribute(StyleConstants.Bold, isBold);
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        Font font = this.getFont();
    }

    public String getTextFontWeight() {
        if (StyleConstants.isBold(this.textAttribs)) {
            return "bold";
        }
        return "plain";
    }

    public void setTextFontStyle(String style) {
        boolean isItalic = false;
        isItalic = "italic".equals(style);
        this.textAttribs.removeAttribute(StyleConstants.Italic);
        this.textAttribs.addAttribute(StyleConstants.Italic, isItalic);
        this.setFont(this.getAttributeSetFont(this.textAttribs));
        Font font = this.getFont();
    }

    public String getTextFontStyle() {
        if (StyleConstants.isItalic(this.textAttribs)) {
            return "italic";
        }
        return "plain";
    }

    public void setTextColor(String name) {
        Color color = null;
        if ("black".equals(name)) {
            color = Color.black;
        } else if ("blue".equals(name)) {
            color = Color.blue;
        } else if ("cyan".equals(name)) {
            color = Color.cyan;
        } else if ("darkGray".equals(name)) {
            color = Color.darkGray;
        } else if ("gray".equals(name)) {
            color = Color.gray;
        } else if ("green".equals(name)) {
            color = Color.green;
        } else if ("lightGray".equals(name)) {
            color = Color.lightGray;
        } else if ("magenta".equals(name)) {
            color = Color.magenta;
        } else if ("orange".equals(name)) {
            color = Color.orange;
        } else if ("pink".equals(name)) {
            color = Color.pink;
        } else if ("red".equals(name)) {
            color = Color.red;
        } else if ("white".equals(name)) {
            color = Color.white;
        } else if ("yellow".equals(name)) {
            color = Color.yellow;
        }
        if (color == null) {
            return;
        }
        this.textAttribs.removeAttribute(StyleConstants.Foreground);
        this.textAttribs.addAttribute(StyleConstants.Foreground, color);
        this.setForeground(color);
    }

    public String getTextColor() {
        Color color = this.getForeground();
        return color.toString();
    }

    private Font getAttributeSetFont(AttributeSet attr) {
        int style = 0;
        if (StyleConstants.isBold(attr)) {
            style |= 1;
        }
        if (StyleConstants.isItalic(attr)) {
            style |= 2;
        }
        String family = StyleConstants.getFontFamily(attr);
        int size = StyleConstants.getFontSize(attr);
        if (StyleConstants.isSuperscript(attr) || StyleConstants.isSubscript(attr)) {
            size -= 2;
        }
        return this.doc.getStyleSheet().getFont(family, style, size);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        URL link;
        try {
            link = new URL(this.content);
        }
        catch (MalformedURLException exc) {
            return;
        }
        HtmlBrowser.URLDisplayer.getDefault().showURL(link);
    }

    @Override
    public String getURLExternalForm() {
        return this.getContent();
    }

    @Override
    public Clipboard getClipboard() {
        return this.getToolkit().getSystemClipboard();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

