/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListBulkActionResourceTypesRequest
extends BmcRequest<Void> {
    private BulkActionType bulkActionType;
    private String page;
    private Integer limit;

    public BulkActionType getBulkActionType() {
        return this.bulkActionType;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new Builder().bulkActionType(this.bulkActionType).page(this.page).limit(this.limit);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bulkActionType=").append(String.valueOf((Object)this.bulkActionType));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListBulkActionResourceTypesRequest)) {
            return false;
        }
        ListBulkActionResourceTypesRequest other = (ListBulkActionResourceTypesRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.bulkActionType, (Object)other.bulkActionType) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bulkActionType == null ? 43 : this.bulkActionType.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListBulkActionResourceTypesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private BulkActionType bulkActionType = null;
        private String page = null;
        private Integer limit = null;

        public Builder bulkActionType(BulkActionType bulkActionType) {
            this.bulkActionType = bulkActionType;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListBulkActionResourceTypesRequest o) {
            this.bulkActionType(o.getBulkActionType());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListBulkActionResourceTypesRequest build() {
            ListBulkActionResourceTypesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListBulkActionResourceTypesRequest buildWithoutInvocationCallback() {
            ListBulkActionResourceTypesRequest request = new ListBulkActionResourceTypesRequest();
            request.bulkActionType = this.bulkActionType;
            request.page = this.page;
            request.limit = this.limit;
            return request;
        }
    }

    public static enum BulkActionType implements BmcEnum
    {
        BulkMoveResources("BULK_MOVE_RESOURCES"),
        BulkDeleteResources("BULK_DELETE_RESOURCES");

        private final String value;
        private static Map<String, BulkActionType> map;

        private BulkActionType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BulkActionType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid BulkActionType: " + key);
        }

        static {
            map = new HashMap<String, BulkActionType>();
            for (BulkActionType v : BulkActionType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

