/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.memory;

import com.oracle.truffle.api.memory.ByteArraySupport;

final class SimpleByteArraySupport
extends ByteArraySupport {
    SimpleByteArraySupport() {
    }

    @Override
    public byte getByte(byte[] buffer, int index) throws IndexOutOfBoundsException {
        return buffer[index];
    }

    @Override
    public void putByte(byte[] buffer, int index, byte value) throws IndexOutOfBoundsException {
        buffer[index] = value;
    }

    @Override
    public short getShort(byte[] buffer, int index) throws IndexOutOfBoundsException {
        return (short)((buffer[index] & 0xFF) << 8 | buffer[index + 1] & 0xFF);
    }

    @Override
    public void putShort(byte[] buffer, int index, short value) throws IndexOutOfBoundsException {
        buffer[index + 0] = (byte)(value >> 8);
        buffer[index + 1] = (byte)value;
    }

    @Override
    public int getInt(byte[] buffer, int index) throws IndexOutOfBoundsException {
        return (buffer[index + 0] & 0xFF) << 24 | (buffer[index + 1] & 0xFF) << 16 | (buffer[index + 2] & 0xFF) << 8 | buffer[index + 3] & 0xFF;
    }

    @Override
    public void putInt(byte[] buffer, int index, int value) throws IndexOutOfBoundsException {
        buffer[index + 0] = (byte)(value >> 24);
        buffer[index + 1] = (byte)(value >> 16);
        buffer[index + 2] = (byte)(value >> 8);
        buffer[index + 3] = (byte)value;
    }

    @Override
    public long getLong(byte[] buffer, int index) throws IndexOutOfBoundsException {
        return ((long)buffer[index + 0] & 0xFFL) << 56 | ((long)buffer[index + 1] & 0xFFL) << 48 | ((long)buffer[index + 2] & 0xFFL) << 40 | ((long)buffer[index + 3] & 0xFFL) << 32 | ((long)buffer[index + 4] & 0xFFL) << 24 | ((long)buffer[index + 5] & 0xFFL) << 16 | ((long)buffer[index + 6] & 0xFFL) << 8 | (long)buffer[index + 7] & 0xFFL;
    }

    @Override
    public void putLong(byte[] buffer, int index, long value) throws IndexOutOfBoundsException {
        buffer[index + 0] = (byte)(value >> 56);
        buffer[index + 1] = (byte)(value >> 48);
        buffer[index + 2] = (byte)(value >> 40);
        buffer[index + 3] = (byte)(value >> 32);
        buffer[index + 4] = (byte)(value >> 24);
        buffer[index + 5] = (byte)(value >> 16);
        buffer[index + 6] = (byte)(value >> 8);
        buffer[index + 7] = (byte)value;
    }

    @Override
    public float getFloat(byte[] buffer, int index) throws IndexOutOfBoundsException {
        return Float.intBitsToFloat(this.getInt(buffer, index));
    }

    @Override
    public void putFloat(byte[] buffer, int index, float value) throws IndexOutOfBoundsException {
        this.putInt(buffer, index, Float.floatToRawIntBits(value));
    }

    @Override
    public double getDouble(byte[] buffer, int index) throws IndexOutOfBoundsException {
        return Double.longBitsToDouble(this.getLong(buffer, index));
    }

    @Override
    public void putDouble(byte[] buffer, int index, double value) throws IndexOutOfBoundsException {
        this.putLong(buffer, index, Double.doubleToRawLongBits(value));
    }
}

