/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.winsys;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.DesignSupport;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.NewTCIterator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.AsyncGUIJob;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;

final class BasicSettingsPanel
extends BasicWizardIterator.Panel {
    private NewTCIterator.DataModel data;
    private static final String[] DEFAULT_MODES = new String[]{"editor"};
    private boolean loadedComboBox = false;
    private JCheckBox cbClosingNotAllowed;
    private JCheckBox cbDraggingNotAllowed;
    private JCheckBox cbKeepPrefSize;
    private JCheckBox cbMaximizationNotAllowed;
    private JCheckBox cbOpenedOnStart;
    private JCheckBox cbSlidingNotAllowed;
    private JCheckBox cbUndockingNotAllowed;
    private JComboBox comMode;
    private JLabel lblMode;
    private JButton redefine;

    public BasicSettingsPanel(WizardDescriptor setting, NewTCIterator.DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        this.setupCombo();
        this.putClientProperty("NewFileWizard_Title", BasicSettingsPanel.getMessage("LBL_TCWizardTitle"));
    }

    private void checkValidity() {
        if (this.loadedComboBox) {
            this.markValid();
        } else {
            this.markInvalid();
        }
    }

    private void setupCombo() {
        final Cursor currentCursor = this.getCursor();
        this.setCursor(Utilities.createProgressCursor((Component)((Object)this)));
        Utilities.attachInitJob((Component)this.comMode, (AsyncGUIJob)new AsyncGUIJob(){
            Set<String> modes;

            public void construct() {
                try {
                    this.modes = DesignSupport.existingModes(BasicSettingsPanel.this.data);
                }
                catch (IOException exc) {
                    Logger.getLogger(BasicSettingsPanel.class.getName()).log(Level.INFO, null, exc);
                }
            }

            public void finished() {
                BasicSettingsPanel.this.comMode.setModel(new DefaultComboBoxModel<String>(this.modes != null ? this.modes.toArray(new String[this.modes.size()]) : DEFAULT_MODES));
                BasicSettingsPanel.this.setComModeSelectedItem();
                BasicSettingsPanel.this.windowPosChanged(null);
                BasicSettingsPanel.this.setCursor(currentCursor);
                BasicSettingsPanel.this.loadedComboBox = true;
                BasicSettingsPanel.this.checkValidity();
            }
        });
    }

    @Override
    protected void storeToDataModel() {
        this.data.setOpened(this.cbOpenedOnStart.isSelected());
        this.data.setKeepPrefSize(this.cbKeepPrefSize.isSelected());
        this.data.setClosingNotAllowed(this.cbClosingNotAllowed.isSelected());
        this.data.setDraggingNotAllowed(this.cbDraggingNotAllowed.isSelected());
        this.data.setMaximizationNotAllowed(this.cbMaximizationNotAllowed.isSelected());
        this.data.setSlidingNotAllowed(this.cbSlidingNotAllowed.isSelected());
        this.data.setUndockingNotAllowed(this.cbUndockingNotAllowed.isSelected());
        this.data.setMode((String)this.comMode.getSelectedItem());
    }

    @Override
    protected void readFromDataModel() {
        this.cbOpenedOnStart.setSelected(this.data.isOpened());
        this.cbKeepPrefSize.setSelected(this.data.isKeepPrefSize());
        this.cbClosingNotAllowed.setSelected(this.data.isClosingNotAllowed());
        this.cbDraggingNotAllowed.setSelected(this.data.isDraggingNotAllowed());
        this.cbMaximizationNotAllowed.setSelected(this.data.isMaximizationNotAllowed());
        this.cbSlidingNotAllowed.setSelected(this.data.isSlidingNotAllowed());
        this.cbUndockingNotAllowed.setSelected(this.data.isUndockingNotAllowed());
        this.setComModeSelectedItem();
        this.windowPosChanged(null);
        this.checkValidity();
        if (!DesignSupport.isDesignModeSupported(this.data.getModuleInfo())) {
            this.redefine.setEnabled(false);
        }
    }

    private void setComModeSelectedItem() {
        if (this.data.getMode() != null) {
            this.comMode.setSelectedItem(this.data.getMode());
        } else {
            this.comMode.setSelectedItem("output");
        }
    }

    @Override
    protected String getPanelName() {
        return BasicSettingsPanel.getMessage("LBL_BasicSettings_Title");
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(BasicSettingsPanel.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(BasicSettingsPanel.class, (String)key);
    }

    private void initComponents() {
        this.lblMode = new JLabel();
        this.comMode = new JComboBox();
        this.cbOpenedOnStart = new JCheckBox();
        this.cbKeepPrefSize = new JCheckBox();
        this.cbSlidingNotAllowed = new JCheckBox();
        this.cbClosingNotAllowed = new JCheckBox();
        this.cbUndockingNotAllowed = new JCheckBox();
        this.cbDraggingNotAllowed = new JCheckBox();
        this.cbMaximizationNotAllowed = new JCheckBox();
        this.redefine = new JButton();
        this.setLayout(new GridBagLayout());
        this.lblMode.setLabelFor(this.comMode);
        Mnemonics.setLocalizedText((JLabel)this.lblMode, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"LBL_Mode"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add(this.lblMode, gridBagConstraints);
        this.comMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BasicSettingsPanel.this.windowPosChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.add(this.comMode, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbOpenedOnStart, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"LBL_OpenOnStart"));
        this.cbOpenedOnStart.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbOpenedOnStart.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add(this.cbOpenedOnStart, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbKeepPrefSize, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"LBL_KeepPrefSize"));
        this.cbKeepPrefSize.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbKeepPrefSize.setEnabled(false);
        this.cbKeepPrefSize.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add(this.cbKeepPrefSize, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbSlidingNotAllowed, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"CTL_SlidingNotAllowed"));
        this.cbSlidingNotAllowed.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbSlidingNotAllowed.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add(this.cbSlidingNotAllowed, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbClosingNotAllowed, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"CTL_ClosingNotAllowed"));
        this.cbClosingNotAllowed.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add(this.cbClosingNotAllowed, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbUndockingNotAllowed, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"CTL_UndockingNotAllowed"));
        this.cbUndockingNotAllowed.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add(this.cbUndockingNotAllowed, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbDraggingNotAllowed, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"CTL_DraggingNotAllowed"));
        this.cbDraggingNotAllowed.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add(this.cbDraggingNotAllowed, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbMaximizationNotAllowed, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"CTL_MaximizationNotAllowed"));
        this.cbMaximizationNotAllowed.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add(this.cbMaximizationNotAllowed, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.redefine, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"LBL_redefine"));
        this.redefine.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BasicSettingsPanel.this.redefineActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 20;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add(this.redefine, gridBagConstraints);
    }

    private void windowPosChanged(ItemEvent evt) {
        this.cbKeepPrefSize.setEnabled(!"editor".equals(this.comMode.getSelectedItem()));
        if (!this.cbKeepPrefSize.isEnabled()) {
            this.cbKeepPrefSize.setSelected(false);
        }
        this.cbSlidingNotAllowed.setEnabled(!"editor".equals(this.comMode.getSelectedItem()));
        if (!this.cbSlidingNotAllowed.isEnabled()) {
            this.cbSlidingNotAllowed.setSelected(false);
        }
    }

    private void redefineActionPerformed(ActionEvent evt) {
        try {
            final AtomicReference<FileObject> userDir = new AtomicReference<FileObject>();
            Task task = DesignSupport.invokeDesignMode(this.data.getProject(), userDir);
            if (task == null) {
                return;
            }
            this.redefine.setEnabled(false);
            this.redefine.setText(NbBundle.getMessage(BasicSettingsPanel.class, (String)"MSG_LaunchingLayout", (Object[])new Object[0]));
            class PostProcess
            implements TaskListener,
            Runnable {
                Set<String> modeNames;

                PostProcess() {
                }

                public void taskFinished(Task task) {
                    FileObject modes = ((FileObject)userDir.get()).getFileObject("config/Windows2Local/Modes");
                    if (modes != null) {
                        this.modeNames = new TreeSet<String>();
                        for (FileObject m : modes.getChildren()) {
                            if (!m.isData() || !"wsmode".equals(m.getExt())) continue;
                            this.modeNames.add(m.getName());
                            try {
                                BasicSettingsPanel.this.data.defineMode(m.getName(), DesignSupport.readMode(m));
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        EventQueue.invokeLater(this);
                    }
                }

                @Override
                public void run() {
                    BasicSettingsPanel.this.redefine.setEnabled(true);
                    BasicSettingsPanel.this.redefine.setText(NbBundle.getMessage(BasicSettingsPanel.class, (String)"MSG_RedefineLayout", (Object[])new Object[0]));
                    int s = BasicSettingsPanel.this.comMode.getModel().getSize();
                    for (int i = 0; i < s; ++i) {
                        this.modeNames.remove((String)BasicSettingsPanel.this.comMode.getModel().getElementAt(i));
                    }
                    boolean first = true;
                    for (String mn : this.modeNames) {
                        ((DefaultComboBoxModel)BasicSettingsPanel.this.comMode.getModel()).addElement(mn);
                        if (first) {
                            BasicSettingsPanel.this.comMode.getModel().setSelectedItem(mn);
                        }
                        first = false;
                    }
                }
            }
            task.addTaskListener((TaskListener)new PostProcess());
        }
        catch (IOException e) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)e.getMessage(), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            Logger.getLogger(BasicSettingsPanel.class.getName()).log(Level.INFO, "No application found", e);
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(BasicSettingsPanel.getMessage("ACS_BasicSettingsPanel"));
        this.cbOpenedOnStart.getAccessibleContext().setAccessibleDescription(BasicSettingsPanel.getMessage("ACS_CTL_OpenOnStart"));
        this.cbKeepPrefSize.getAccessibleContext().setAccessibleDescription(BasicSettingsPanel.getMessage("ACS_CTL_KeepPrefSize"));
        this.comMode.getAccessibleContext().setAccessibleDescription(BasicSettingsPanel.getMessage("ACS_CTL_Mode"));
    }
}

