/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.typinghooks;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.spi.editor.typinghooks.TypedBreakInterceptor;
import org.openide.util.Exceptions;

public class CssTypedBreakInterceptor
implements TypedBreakInterceptor {
    private static final String TWO_CURLY_BRACES_IMAGE = "{}";
    private Position[] reformat;

    public boolean beforeInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void insert(TypedBreakInterceptor.MutableContext context) throws BadLocationException {
        String text;
        int offset = context.getBreakInsertOffset();
        BaseDocument doc = (BaseDocument)context.getDocument();
        if (offset > 0 && offset < doc.getLength() && TWO_CURLY_BRACES_IMAGE.equals(text = doc.getText(offset - 1, 2))) {
            int from = Utilities.getRowStart((BaseDocument)doc, (int)offset);
            int to = Utilities.getRowEnd((BaseDocument)doc, (int)offset);
            this.reformat = new Position[]{doc.createPosition(from), doc.createPosition(to)};
            context.setText("\n\n", 1, 1, new int[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
        if (this.reformat != null) {
            final Position[] range = this.reformat;
            this.reformat = null;
            BaseDocument doc = (BaseDocument)context.getDocument();
            final Indent indent = Indent.get((Document)doc);
            indent.lock();
            try {
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            indent.reindent(range[0].getOffset(), range[1].getOffset());
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
            finally {
                indent.unlock();
            }
        }
    }

    public void cancelled(TypedBreakInterceptor.Context context) {
    }

    public static final class Factory
    implements TypedBreakInterceptor.Factory {
        public TypedBreakInterceptor createTypedBreakInterceptor(MimePath mimePath) {
            return new CssTypedBreakInterceptor();
        }
    }
}

