/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.Tree;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Rule;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotation;
import org.netbeans.modules.websvc.editor.hints.rules.WebServiceAnnotations;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class InvalidWebMethodAnnotation
extends Rule<ExecutableElement>
implements WebServiceAnnotations {
    @Override
    protected ErrorDescription[] apply(ExecutableElement subject, ProblemContext ctx) {
        AnnotationValue val;
        AnnotationMirror serviceAnn;
        AnnotationMirror methodAnn = Utilities.findAnnotation(subject, "javax.jws.WebMethod");
        Element classEl = subject.getEnclosingElement();
        if (classEl != null && (serviceAnn = Utilities.findAnnotation(classEl, "javax.jws.WebService")) != null && (val = Utilities.getAnnotationAttrValue(serviceAnn, "endpointInterface")) != null) {
            String label = NbBundle.getMessage(InvalidWebMethodAnnotation.class, (String)"MSG_WebMethod_NotAllowed");
            RemoveAnnotation fix = new RemoveAnnotation(ctx.getFileObject(), subject, methodAnn);
            Tree problemTree = ctx.getCompilationInfo().getTrees().getTree(subject, methodAnn);
            ctx.setElementToAnnotate(problemTree);
            ErrorDescription problem = InvalidWebMethodAnnotation.createProblem((Element)subject, ctx, label, fix);
            ctx.setElementToAnnotate(null);
            return new ErrorDescription[]{problem};
        }
        return null;
    }

    @Override
    protected boolean isApplicable(ExecutableElement subject, ProblemContext ctx) {
        return Utilities.hasAnnotation(subject, "javax.jws.WebMethod");
    }
}

