/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.ContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextConfigurationAttributes {
    private static final Log logger = LogFactory.getLog(ContextConfigurationAttributes.class);
    private final Class<?> declaringClass;
    private Class<?>[] classes;
    private String[] locations;
    private final boolean inheritLocations;
    private final Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>[] initializers;
    private final boolean inheritInitializers;
    private final String name;
    private final Class<? extends ContextLoader> contextLoaderClass;

    public ContextConfigurationAttributes(Class<?> declaringClass, ContextConfiguration contextConfiguration) {
        this(declaringClass, ContextConfigurationAttributes.resolveLocations(declaringClass, contextConfiguration), contextConfiguration.classes(), contextConfiguration.inheritLocations(), contextConfiguration.initializers(), contextConfiguration.inheritInitializers(), contextConfiguration.name(), contextConfiguration.loader());
    }

    public ContextConfigurationAttributes(Class<?> declaringClass, AnnotationAttributes annAttrs) {
        this(declaringClass, ContextConfigurationAttributes.resolveLocations(declaringClass, annAttrs.getStringArray("locations"), annAttrs.getStringArray("value")), annAttrs.getClassArray("classes"), annAttrs.getBoolean("inheritLocations"), annAttrs.getClassArray("initializers"), annAttrs.getBoolean("inheritInitializers"), annAttrs.getString("name"), annAttrs.getClass("loader"));
    }

    @Deprecated
    public ContextConfigurationAttributes(Class<?> declaringClass, String[] locations, Class<?>[] classes, boolean inheritLocations, Class<? extends ContextLoader> contextLoaderClass) {
        this(declaringClass, locations, classes, inheritLocations, null, true, null, contextLoaderClass);
    }

    public ContextConfigurationAttributes(Class<?> declaringClass, String[] locations, Class<?>[] classes, boolean inheritLocations, Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>[] initializers, boolean inheritInitializers, Class<? extends ContextLoader> contextLoaderClass) {
        this(declaringClass, locations, classes, inheritLocations, initializers, inheritInitializers, null, contextLoaderClass);
    }

    public ContextConfigurationAttributes(Class<?> declaringClass, String[] locations, Class<?>[] classes, boolean inheritLocations, Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>[] initializers, boolean inheritInitializers, String name, Class<? extends ContextLoader> contextLoaderClass) {
        Assert.notNull(declaringClass, (String)"declaringClass must not be null");
        Assert.notNull(contextLoaderClass, (String)"contextLoaderClass must not be null");
        if (!ObjectUtils.isEmpty((Object[])locations) && !ObjectUtils.isEmpty((Object[])classes) && logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Test class [%s] has been configured with @ContextConfiguration's 'locations' (or 'value') %s and 'classes' %s attributes. Most SmartContextLoader implementations support only one declaration of resources per @ContextConfiguration annotation.", declaringClass.getName(), ObjectUtils.nullSafeToString((Object[])locations), ObjectUtils.nullSafeToString((Object[])classes)));
        }
        this.declaringClass = declaringClass;
        this.locations = locations;
        this.classes = classes;
        this.inheritLocations = inheritLocations;
        this.initializers = initializers;
        this.inheritInitializers = inheritInitializers;
        this.name = StringUtils.hasText((String)name) ? name : null;
        this.contextLoaderClass = contextLoaderClass;
    }

    private static String[] resolveLocations(Class<?> declaringClass, ContextConfiguration contextConfiguration) {
        return ContextConfigurationAttributes.resolveLocations(declaringClass, contextConfiguration.locations(), contextConfiguration.value());
    }

    private static String[] resolveLocations(Class<?> declaringClass, String[] locations, String[] value) {
        Assert.notNull(declaringClass, (String)"declaringClass must not be null");
        if (!ObjectUtils.isEmpty((Object[])value) && !ObjectUtils.isEmpty((Object[])locations)) {
            throw new IllegalStateException(String.format("Test class [%s] has been configured with @ContextConfiguration's 'value' %s and 'locations' %s attributes. Only one declaration of resource locations is permitted per @ContextConfiguration annotation.", declaringClass.getName(), ObjectUtils.nullSafeToString((Object[])value), ObjectUtils.nullSafeToString((Object[])locations)));
        }
        if (!ObjectUtils.isEmpty((Object[])value)) {
            locations = value;
        }
        return locations;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public void setClasses(Class<?> ... classes) {
        this.classes = classes;
    }

    public Class<?>[] getClasses() {
        return this.classes;
    }

    public boolean hasClasses() {
        return !ObjectUtils.isEmpty((Object[])this.getClasses());
    }

    public void setLocations(String ... locations) {
        this.locations = locations;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public boolean hasLocations() {
        return !ObjectUtils.isEmpty((Object[])this.getLocations());
    }

    public boolean hasResources() {
        return this.hasLocations() || this.hasClasses();
    }

    public boolean isInheritLocations() {
        return this.inheritLocations;
    }

    public Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>[] getInitializers() {
        return this.initializers;
    }

    public boolean isInheritInitializers() {
        return this.inheritInitializers;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends ContextLoader> getContextLoaderClass() {
        return this.contextLoaderClass;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContextConfigurationAttributes)) {
            return false;
        }
        ContextConfigurationAttributes otherAttr = (ContextConfigurationAttributes)other;
        return ObjectUtils.nullSafeEquals(this.declaringClass, otherAttr.declaringClass) && Arrays.equals(this.classes, otherAttr.classes) && Arrays.equals(this.locations, otherAttr.locations) && this.inheritLocations == otherAttr.inheritLocations && Arrays.equals(this.initializers, otherAttr.initializers) && this.inheritInitializers == otherAttr.inheritInitializers && ObjectUtils.nullSafeEquals((Object)this.name, (Object)otherAttr.name) && ObjectUtils.nullSafeEquals(this.contextLoaderClass, otherAttr.contextLoaderClass);
    }

    public int hashCode() {
        int result = this.declaringClass.hashCode();
        result = 31 * result + Arrays.hashCode(this.classes);
        result = 31 * result + Arrays.hashCode(this.locations);
        result = 31 * result + Arrays.hashCode(this.initializers);
        return result;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("declaringClass", (Object)this.declaringClass.getName()).append("classes", (Object)ObjectUtils.nullSafeToString((Object[])this.classes)).append("locations", (Object)ObjectUtils.nullSafeToString((Object[])this.locations)).append("inheritLocations", this.inheritLocations).append("initializers", (Object)ObjectUtils.nullSafeToString((Object[])this.initializers)).append("inheritInitializers", this.inheritInitializers).append("name", (Object)this.name).append("contextLoaderClass", (Object)this.contextLoaderClass.getName()).toString();
    }
}

