/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.java.classpath.QueriesAccessor;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;

public final class BinaryForSourceQuery {
    private static final Logger LOG = Logger.getLogger(BinaryForSourceQuery.class.getName());
    static final QueriesAccessorImpl CACHE = new QueriesAccessorImpl();

    private BinaryForSourceQuery() {
    }

    public static Result findBinaryRoots(URL sourceRoot) {
        assert (sourceRoot != null);
        for (BinaryForSourceQueryImplementation impl : Lookup.getDefault().lookupAll(BinaryForSourceQueryImplementation.class)) {
            Result result = impl.findBinaryRoots(sourceRoot);
            if (result == null) continue;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "findBinaryRoots({0}) -> {1} from {2}", new Object[]{sourceRoot, Arrays.asList(result.getRoots()), impl});
            }
            return result;
        }
        LOG.log(Level.FINE, "findBinaryRoots({0}) -> nil", sourceRoot);
        return new DefaultResult(sourceRoot);
    }

    public static Result2 findBinaryRoots2(URL sourceRoot) {
        return QueriesAccessor.wrap(BinaryForSourceQuery.findBinaryRoots(sourceRoot));
    }

    static {
        QueriesAccessor.setInstance(CACHE);
    }

    static final class QueriesAccessorImpl
    extends QueriesAccessor {
        private final Map<Object, Result2Impl<?>> cache = new WeakHashMap();

        QueriesAccessorImpl() {
        }

        @Override
        public synchronized <T> Result2 create(BinaryForSourceQueryImplementation2<T> impl, T value) {
            Result2Impl<Object> result = this.cache.get(value);
            if (result == null) {
                result = new Result2Impl<T>(impl, value);
                this.cache.put(value, result);
            }
            assert (impl == result.impl);
            return result;
        }

        synchronized Object findRegistered(Object prototype) {
            for (Object object : this.cache.keySet()) {
                if (!prototype.equals(object)) continue;
                return object;
            }
            return null;
        }
    }

    private static final class Result2Impl<T>
    extends Result2 {
        final BinaryForSourceQueryImplementation2<T> impl;
        final T value;

        Result2Impl(BinaryForSourceQueryImplementation2<T> impl, T value) {
            this.impl = impl;
            this.value = value;
        }

        @Override
        public boolean preferBinaries() {
            return this.impl.computePreferBinaries(this.value);
        }

        @Override
        public URL[] getRoots() {
            return this.impl.computeRoots(this.value);
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            this.impl.computeChangeListener(this.value, true, l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            this.impl.computeChangeListener(this.value, false, l);
        }
    }

    private static class DefaultResult
    extends Result2 {
        private final URL sourceRoot;

        DefaultResult(URL sourceRoot) {
            this.sourceRoot = sourceRoot;
        }

        @Override
        public URL[] getRoots() {
            FileObject fo = URLMapper.findFileObject((URL)this.sourceRoot);
            if (fo == null) {
                return new URL[0];
            }
            ClassPath exec = ClassPath.getClassPath(fo, "classpath/execute");
            if (exec == null) {
                return new URL[0];
            }
            HashSet<URL> result = new HashSet<URL>();
            for (ClassPath.Entry e : exec.entries()) {
                FileObject[] roots;
                URL eurl = e.getURL();
                for (FileObject root : roots = SourceForBinaryQuery.findSourceRoots(eurl).getRoots()) {
                    if (!this.sourceRoot.equals(root.toURL())) continue;
                    result.add(eurl);
                }
            }
            return result.toArray(new URL[result.size()]);
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }

        @Override
        public boolean preferBinaries() {
            return false;
        }
    }

    public static abstract class Result2
    implements Result {
        Result2() {
        }

        public abstract boolean preferBinaries();
    }

    public static interface Result {
        public URL[] getRoots();

        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);
    }
}

