/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.execution;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

class MultiplexingOutputStream
extends OutputStream {
    private static final int PACKET_SIZE = 127;
    private final byte[] name;
    private final OutputStream delegate;

    MultiplexingOutputStream(String name, OutputStream delegate) {
        try {
            this.name = name.getBytes("UTF-8");
            this.delegate = delegate;
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        OutputStream outputStream = this.delegate;
        synchronized (outputStream) {
            int i = 0;
            while (len > 0) {
                int size = Math.min(127, len);
                byte[] data = new byte[this.name.length + 1 + size + 1];
                data[0] = (byte)this.name.length;
                System.arraycopy(this.name, 0, data, 1, this.name.length);
                data[this.name.length + 1] = (byte)size;
                System.arraycopy(b, off + i, data, this.name.length + 2, size);
                this.delegate.write(data);
                i += size;
                len -= size;
            }
            this.delegate.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.delegate.close();
    }
}

