/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.codegen;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.modules.websvc.manager.WebServiceManager;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.util.ManagerUtil;
import org.netbeans.modules.websvc.saas.util.WsdlUtil;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class Wsdl2Java {
    private static final String wsImportCompileScriptName = "modules/ext/build-ws.xml";
    private static File wsImportCompileScript;
    private static final String WEBSVC_HOME_PROP = "websvc.home";
    private static final String USER_FILE_PROP = "user.properties.file";
    private static final String JAXWS_ENDORSED_DIR = "jaxws.endorsed.dir";
    private static final String WSDL_NAME_PROP = "serviceName";
    private static final String WSDL_DIRNAME_PROP = "serviceDirName";
    private static final String WSDL_FILE_NAME_PROP = "wsdlFileName";
    private static final String PACKAGE_NAME = "packageName";
    private static final String CONFIG_FILE_PROP = "config.file";
    private static final String PROXY_SERVER = "proxy.server";
    private static final String TEST_URI = "http://schemas.xmlsoap.org/soap/http";
    private static final String CATALOG = "catalog.file";
    private static final String JAXB_ENDORSED_REF = "modules/ext/jaxb/api/jaxb-api.jar";
    private static final String JAXWS_ENDORSED_REF = "modules/ext/jaxws22/api/jakarta.xml.ws-api.jar";
    private final String userDir = System.getProperty("netbeans.user");
    private WebServiceData webServiceData;
    private Properties properties;
    private File catalogFile;

    public Wsdl2Java(WebServiceData wsData) {
        this.webServiceData = wsData;
        this.properties = new Properties();
        this.catalogFile = new File(wsData.getCatalog());
    }

    public boolean createProxyJars() {
        try {
            int index;
            boolean jaxRPCAvailable = ManagerUtil.isJAXRPCAvailable();
            String wsdlUrl = this.webServiceData.getOriginalWsdlUrl();
            String serviceDirName = WsdlUtil.getServiceDirName((String)this.webServiceData.getOriginalWsdlUrl());
            String serviceName = this.webServiceData.getName();
            String packageName = this.webServiceData.getPackageName();
            this.properties.put(WEBSVC_HOME_PROP, WebServiceManager.WEBSVC_HOME);
            this.properties.put(USER_FILE_PROP, this.userDir + "/build.properties");
            this.properties.put(WSDL_DIRNAME_PROP, serviceDirName);
            this.properties.put(WSDL_NAME_PROP, serviceName);
            this.properties.put(WSDL_FILE_NAME_PROP, wsdlUrl);
            this.properties.put(PACKAGE_NAME, packageName == null ? "" : packageName);
            File jaxbEndorsedDir = InstalledFileLocator.getDefault().locate(JAXB_ENDORSED_REF, null, true).getParentFile();
            File jaxwsEndorsedDir = InstalledFileLocator.getDefault().locate(JAXWS_ENDORSED_REF, null, true).getParentFile();
            this.properties.put(JAXWS_ENDORSED_DIR, jaxbEndorsedDir.getAbsolutePath() + ":" + jaxwsEndorsedDir.getAbsolutePath());
            this.properties.put(CATALOG, this.catalogFile.getAbsolutePath());
            try {
                InetSocketAddress address;
                ProxySelector selector = ProxySelector.getDefault();
                List<Proxy> proxies = selector.select(new URI(TEST_URI));
                String proxyServer = "";
                if (proxies.size() > 0 && (address = (InetSocketAddress)proxies.get(0).address()) != null) {
                    String host = "http://" + address.getHostName();
                    String port = String.valueOf(address.getPort());
                    proxyServer = host + ":" + port;
                }
                this.properties.put(PROXY_SERVER, proxyServer);
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
            boolean jaxWsCreated = this.createJaxWsProxyJars(this.properties);
            if (!jaxWsCreated) {
                this.webServiceData.setJaxWsEnabled(false);
                String errorMessage = NbBundle.getMessage(Wsdl2Java.class, (String)"CODEGEN_ERROR_JAXWS");
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)errorMessage);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            } else {
                this.webServiceData.setJaxWsEnabled(true);
            }
            boolean jaxRpcCreated = false;
            if (jaxRPCAvailable) {
                jaxRpcCreated = this.createJaxRpcProxyJars(this.properties);
            }
            if (!jaxRpcCreated) {
                this.webServiceData.setJaxRpcEnabled(false);
                if (jaxRPCAvailable) {
                    String errorMessage = NbBundle.getMessage(Wsdl2Java.class, (String)"CODEGEN_ERROR_JAXRPC");
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)errorMessage);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                }
            } else {
                this.webServiceData.setJaxRpcEnabled(true);
            }
            if ((index = serviceName.lastIndexOf(47)) != -1) {
                serviceName = serviceName.substring(index + 1);
            }
            if (this.webServiceData.isJaxRpcEnabled()) {
                this.webServiceData.setJaxRpcDescriptorPath(serviceDirName + "/jaxrpc/" + serviceName + ".xml");
            }
            if (this.webServiceData.isJaxWsEnabled()) {
                this.webServiceData.setJaxWsDescriptorPath(serviceDirName + "/jaxws/" + serviceName + ".xml");
            }
            return jaxWsCreated || jaxRpcCreated;
        }
        catch (IllegalArgumentException exc) {
            ErrorManager.getDefault().notify((Throwable)exc);
            return false;
        }
    }

    private boolean createJaxWsProxyJars(Properties properties) {
        try {
            boolean result;
            ExecutorTask executorTask = ActionUtils.runTarget((FileObject)FileUtil.toFileObject((File)this.getAntScript()), (String[])new String[]{"wsimport-jar"}, (Properties)properties);
            executorTask.waitFinished();
            boolean bl = result = executorTask.result() == 0;
            if (!result) {
                try {
                    String home = properties.getProperty(WEBSVC_HOME_PROP) + "/" + properties.getProperty(WSDL_NAME_PROP) + "/jaxws";
                    this.deleteWsDir(home);
                }
                catch (NullPointerException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
            return result;
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return false;
        }
    }

    private boolean createJaxRpcProxyJars(Properties properties) {
        try {
            boolean result;
            String wsdlUrlName = new File(this.webServiceData.getWsdlFile()).toURI().toURL().toString();
            this.createJaxrpcConfigFile(wsdlUrlName, properties);
            ExecutorTask executorTask = ActionUtils.runTarget((FileObject)FileUtil.toFileObject((File)this.getAntScript()), (String[])new String[]{"wscompile-jar"}, (Properties)properties);
            executorTask.waitFinished();
            boolean bl = result = executorTask.result() == 0;
            if (!result) {
                try {
                    String home = properties.getProperty(WEBSVC_HOME_PROP) + "/" + properties.getProperty(WSDL_NAME_PROP) + "/jaxrpc";
                    this.deleteWsDir(home);
                }
                catch (NullPointerException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
            return result;
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return false;
        }
    }

    private void deleteWsDir(String wsDir) {
        File wsDirFile = new File(wsDir);
        if (!wsDirFile.isDirectory()) {
            return;
        }
        File buildDir = new File(wsDirFile, "build");
        this.rmDir(buildDir);
        File srcDir = new File(wsDirFile, "src");
        this.rmDir(srcDir);
        File[] jarFiles = wsDirFile.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        });
        for (int i = 0; jarFiles != null && i < jarFiles.length; ++i) {
            jarFiles[i].delete();
        }
        wsDirFile.delete();
    }

    private void rmDir(File dir) {
        if (dir.isDirectory()) {
            File[] subFiles = dir.listFiles();
            for (int i = 0; subFiles != null && i < subFiles.length; ++i) {
                if (subFiles[i].isFile()) {
                    subFiles[i].delete();
                    continue;
                }
                this.rmDir(subFiles[i]);
            }
            dir.delete();
        }
    }

    private File getAntScript() {
        if (wsImportCompileScript == null) {
            wsImportCompileScript = InstalledFileLocator.getDefault().locate(wsImportCompileScriptName, "", false);
        }
        return wsImportCompileScript;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createJaxrpcConfigFile(String wsdlFileName, Properties properties) {
        try {
            File cf = File.createTempFile("jaxrpcconfigfile", ".xml");
            cf.deleteOnExit();
            FileOutputStream out = new FileOutputStream(cf);
            String packageName = this.webServiceData.getEffectivePackageName();
            if (packageName == null || packageName.trim().length() == 0) {
                String msg = NbBundle.getMessage(Wsdl2Java.class, (String)"MSG_InvalidPackageName");
                throw new IllegalArgumentException(msg);
            }
            String wsdlConfigEntry = "\t<wsdl location=\"" + wsdlFileName + "\" packageName=\"" + packageName + "\"/>";
            try (PrintWriter configWriter = new PrintWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));){
                configWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                configWriter.println("<configuration xmlns=\"http://java.sun.com/xml/ns/jax-rpc/ri/config\">");
                configWriter.println(wsdlConfigEntry);
                configWriter.println("</configuration>");
            }
            properties.put(CONFIG_FILE_PROP, cf.getAbsolutePath());
        }
        catch (IOException exc) {
            ErrorManager.getDefault().notify((Throwable)exc);
        }
    }
}

