/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.angular;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.angular.AngularDoc;
import org.netbeans.modules.html.angular.Bundle;
import org.netbeans.modules.html.angular.Utils;
import org.netbeans.modules.html.angular.model.Directive;
import org.netbeans.modules.html.angular.model.DirectiveConvention;
import org.netbeans.modules.html.editor.api.gsf.CustomAttribute;
import org.netbeans.modules.html.editor.lib.api.HelpItem;
import org.netbeans.modules.html.editor.lib.api.HelpResolver;
import org.openide.util.Exceptions;

public class AngularCustomAttribute
implements CustomAttribute {
    private static final Logger LOGGER = Logger.getLogger(AngularCustomAttribute.class.getSimpleName());
    private static Map<DirectiveConvention, Collection<CustomAttribute>> dc2attr = null;
    private static Collection<CustomAttribute> attributes = null;
    private Directive directive;
    private DirectiveConvention convention;
    private static final HelpResolver AJS_HELP_RESOLVER = new HelpResolver(){

        public URL resolveLink(URL baseURL, String relativeLink) {
            LOGGER.log(Level.FINE, "relativeLink = ''{0}''", relativeLink);
            LOGGER.log(Level.FINE, "baseURL = ''{0}''", baseURL);
            try {
                URI u = new URI(relativeLink);
                if (u.isAbsolute()) {
                    LOGGER.log(Level.FINE, "resolved to = ''{0}''", u.toURL());
                    return u.toURL();
                }
            }
            catch (MalformedURLException | URISyntaxException ex) {
                LOGGER.log(Level.FINE, null, ex);
            }
            String link = null;
            if (relativeLink.startsWith("#")) {
                assert (baseURL != null) : "Base URL must be provided for local relative links (anchors).";
                String base = baseURL.toExternalForm();
                int hashIdx = base.indexOf(35);
                if (hashIdx != -1) {
                    base = base.substring(0, hashIdx);
                }
                link = base + relativeLink;
            } else if (baseURL != null) {
                URL url = this.getRelativeURL(baseURL, relativeLink);
                LOGGER.log(Level.FINE, "resolved to = ''{0}''", url);
                return url;
            }
            if (link != null) {
                try {
                    URL url = new URI(link).toURL();
                    LOGGER.log(Level.FINE, "resolved to = ''{0}''", url);
                    return url;
                }
                catch (MalformedURLException | URISyntaxException ex) {
                    LOGGER.log(Level.FINE, null, ex);
                }
            }
            LOGGER.fine("cannot be resolved!");
            return null;
        }

        private URL getRelativeURL(URL baseurl, String link) {
            if (link.trim().isEmpty()) {
                return null;
            }
            if (link.startsWith("./")) {
                link = link.substring(2);
            }
            String url = baseurl.toString();
            if (link.trim().charAt(0) == '#') {
                int index = url.indexOf(35);
                if (index > -1) {
                    url = url.substring(0, url.indexOf(35));
                }
                url = url + link;
            } else {
                int index = 0;
                url = url.substring(0, url.lastIndexOf(47));
                while ((index = link.indexOf("../", index)) > -1) {
                    url = url.substring(0, url.lastIndexOf(47));
                    link = link.substring(index + 3);
                }
                url = url + "/" + link;
            }
            try {
                return new URL(url);
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.FINE, null, e);
                return null;
            }
        }

        public String getHelpContent(URL url) {
            try {
                return Utils.getContentAsString(url, null);
            }
            catch (IOException ex) {
                String message = Bundle.doc_cannotGet(url.toString());
                LOGGER.log(Level.INFO, message);
                return message;
            }
        }
    };

    public static synchronized Collection<CustomAttribute> getCustomAttributes(DirectiveConvention convention) {
        if (dc2attr == null) {
            dc2attr = new EnumMap<DirectiveConvention, Collection<CustomAttribute>>(DirectiveConvention.class);
            for (DirectiveConvention dc : DirectiveConvention.values()) {
                ArrayList<AngularCustomAttribute> attrs = new ArrayList<AngularCustomAttribute>();
                for (Directive ad : Directive.values()) {
                    attrs.add(new AngularCustomAttribute(ad, dc));
                }
                dc2attr.put(dc, attrs);
            }
        }
        return dc2attr.get((Object)convention);
    }

    public static synchronized Collection<CustomAttribute> getCustomAttributes() {
        if (attributes == null) {
            attributes = new ArrayList<CustomAttribute>();
            for (DirectiveConvention dc : DirectiveConvention.values()) {
                attributes.addAll(AngularCustomAttribute.getCustomAttributes(dc));
            }
        }
        return attributes;
    }

    public AngularCustomAttribute(Directive directive, DirectiveConvention convetion) {
        this.directive = directive;
        this.convention = convetion;
    }

    public String getName() {
        return this.directive.getAttributeName(this.convention);
    }

    public boolean isRequired() {
        return false;
    }

    public HelpItem getHelp() {
        return new HelpItem(){

            public String getHelpHeader() {
                return "<h2>" + AngularCustomAttribute.this.directive.getAttributeName(AngularCustomAttribute.this.convention) + "</h2>";
            }

            public String getHelpContent() {
                return AngularDoc.getDefault().getDirectiveDocumentation(AngularCustomAttribute.this.directive);
            }

            public URL getHelpURL() {
                try {
                    return new URL(AngularCustomAttribute.this.directive.getExternalDocumentationURL());
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }

            public HelpResolver getHelpResolver() {
                return AJS_HELP_RESOLVER;
            }
        };
    }

    public boolean isValueRequired() {
        return this.directive.isAttributeValueTypicallyUsed();
    }
}

