/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.Namespace;
import java.io.PrintWriter;

public final class ScriptEnvironment {
    private final PrintWriter err;
    private final Namespace namespace = new Namespace();
    final boolean constAsVar;
    final boolean dumpOnError;
    final boolean earlyLvalueError;
    final boolean emptyStatements;
    final int ecmascriptEdition;
    final boolean jsx;
    final FunctionStatementBehavior functionStatement;
    final boolean syntaxExtensions;
    final boolean scripting;
    final boolean shebang;
    final boolean strict;
    final boolean functionDeclarationHoisting;

    private ScriptEnvironment(boolean strict, int ecmascriptEdition, boolean jsx, boolean earlyLvalueError, boolean emptyStatements, boolean syntaxExtensions, boolean scripting, boolean shebang, boolean constAsVar, boolean functionDeclarationHoisting, FunctionStatementBehavior functionStatementBehavior, PrintWriter dumpOnError) {
        this.err = dumpOnError;
        this.constAsVar = constAsVar;
        this.dumpOnError = dumpOnError != null;
        this.earlyLvalueError = earlyLvalueError;
        this.emptyStatements = emptyStatements;
        this.functionStatement = functionStatementBehavior;
        this.syntaxExtensions = syntaxExtensions;
        this.strict = strict;
        this.scripting = scripting;
        this.shebang = shebang;
        this.ecmascriptEdition = ecmascriptEdition;
        this.jsx = jsx;
        this.functionDeclarationHoisting = functionDeclarationHoisting;
    }

    PrintWriter getErr() {
        return this.err;
    }

    Namespace getNamespace() {
        return this.namespace;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean constAsVar;
        private boolean earlyLvalueError = true;
        private boolean emptyStatements;
        private int ecmacriptEdition = 6;
        private boolean jsx = false;
        private boolean syntaxExtensions = true;
        private boolean scripting;
        private boolean shebang;
        private boolean strict;
        private boolean functionDeclarationHoisting;
        private FunctionStatementBehavior functionStatementBehavior = FunctionStatementBehavior.ERROR;
        private PrintWriter dumpOnError;

        private Builder() {
        }

        public Builder constAsVar(boolean constAsVar) {
            this.constAsVar = constAsVar;
            return this;
        }

        public Builder earlyLvalueError(boolean earlyLvalueError) {
            this.earlyLvalueError = earlyLvalueError;
            return this;
        }

        public Builder emptyStatements(boolean emptyStatements) {
            this.emptyStatements = emptyStatements;
            return this;
        }

        public Builder ecmacriptEdition(int ecmacriptEdition) {
            this.ecmacriptEdition = ecmacriptEdition;
            return this;
        }

        public Builder jsx(boolean jsx) {
            this.jsx = jsx;
            return this;
        }

        public Builder syntaxExtensions(boolean syntaxExtensions) {
            this.syntaxExtensions = syntaxExtensions;
            return this;
        }

        public Builder scripting(boolean scripting) {
            this.scripting = scripting;
            return this;
        }

        public Builder shebang(boolean shebang) {
            this.shebang = shebang;
            return this;
        }

        public Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public Builder functionStatementBehavior(FunctionStatementBehavior functionStatementBehavior) {
            this.functionStatementBehavior = functionStatementBehavior;
            return this;
        }

        public Builder dumpOnError(PrintWriter dumpOnError) {
            this.dumpOnError = dumpOnError;
            return this;
        }

        public Builder functionDeclarationHoisting(boolean functionDeclarationHoisting) {
            this.functionDeclarationHoisting = functionDeclarationHoisting;
            return this;
        }

        public ScriptEnvironment build() {
            return new ScriptEnvironment(this.strict, this.ecmacriptEdition, this.jsx, this.earlyLvalueError, this.emptyStatements, this.syntaxExtensions, this.scripting, this.shebang, this.constAsVar, this.functionDeclarationHoisting, this.functionStatementBehavior, this.dumpOnError);
        }
    }

    public static enum FunctionStatementBehavior {
        ACCEPT,
        WARNING,
        ERROR;

    }
}

