/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.tregex.parser.RegexFeatures;
import java.util.Optional;

@FunctionalInterface
public interface RegexFeatureSet {
    public static final RegexFeatureSet DEFAULT = (source, features) -> Optional.empty();

    public Optional<String> testSupport(RegexSource var1, RegexFeatures var2);

    @CompilerDirectives.TruffleBoundary
    default public void checkSupport(RegexSource source, RegexFeatures features) throws UnsupportedRegexException {
        Optional<String> maybeError = this.testSupport(source, features);
        if (maybeError.isPresent()) {
            throw new UnsupportedRegexException(maybeError.get(), source);
        }
    }
}

