/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;

public abstract class HCLTemplate
extends HCLExpression {
    public final List<Part> parts;

    public HCLTemplate(List<Part> parts) {
        this.parts = Collections.unmodifiableList(parts);
    }

    @Override
    public List<? extends HCLExpression> getChildren() {
        return Collections.emptyList();
    }

    public static final class StringTemplate
    extends HCLTemplate {
        public StringTemplate(List<Part> parts) {
            super(parts);
        }

        @Override
        public String asString() {
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            for (Part part : this.parts) {
                sb.append(part);
            }
            sb.append('\"');
            return sb.toString();
        }
    }

    public static final class HereDoc
    extends HCLTemplate {
        public final String marker;
        public final int indent;

        public HereDoc(String marker, int indent, List<Part> parts) {
            super(parts);
            this.marker = marker;
            this.indent = indent;
        }

        public boolean isIndented() {
            return this.indent != -1;
        }

        @Override
        public String asString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.indent > -1 ? "<<-" : "<<").append(this.marker).append('\n');
            for (Part part : this.parts) {
                sb.append(part);
            }
            sb.append(this.marker);
            return sb.toString();
        }
    }

    public static final class TemplatePart
    extends Part {
        public TemplatePart(String value) {
            super(value);
        }

        public String toString() {
            return "%{" + this.value + "}";
        }
    }

    public static final class InterpolationPart
    extends Part {
        public InterpolationPart(String value) {
            super(value);
        }

        public String toString() {
            return "${" + this.value + "}";
        }
    }

    public static final class StringPart
    extends Part {
        public static final StringPart NL = new StringPart("\n");

        public StringPart(String value) {
            super(value);
        }

        public String toString() {
            return this.value;
        }
    }

    public static abstract class Part {
        public final String value;

        public Part(String value) {
            this.value = value;
        }
    }
}

