/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;
import org.netbeans.modules.languages.hcl.ast.HCLIdentifier;

public abstract class HCLResolveOperation
extends HCLExpression {
    public final HCLExpression base;

    public HCLResolveOperation(HCLExpression base) {
        this.base = base;
    }

    @Override
    public List<? extends HCLExpression> getChildren() {
        return Collections.singletonList(this.base);
    }

    public static final class FullSplat
    extends HCLResolveOperation {
        public FullSplat(HCLExpression base) {
            super(base);
        }

        @Override
        public String asString() {
            return this.base.asString() + "[*]";
        }
    }

    public static final class AttrSplat
    extends HCLResolveOperation {
        public AttrSplat(HCLExpression base) {
            super(base);
        }

        @Override
        public String asString() {
            return this.base.asString() + ".*";
        }
    }

    public static final class Index
    extends HCLResolveOperation {
        public final HCLExpression index;
        public final boolean legacy;

        public Index(HCLExpression base, HCLExpression index, boolean legacy) {
            super(base);
            this.index = index;
            this.legacy = legacy;
        }

        @Override
        public String asString() {
            return this.base.asString() + (this.legacy ? "." + this.index : "[" + this.index + "]");
        }

        @Override
        public List<? extends HCLExpression> getChildren() {
            return Arrays.asList(this.base, this.index);
        }
    }

    public static final class Attribute
    extends HCLResolveOperation {
        public final HCLIdentifier attr;

        public Attribute(HCLExpression base, HCLIdentifier attr) {
            super(base);
            this.attr = attr;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + ": ." + this.attr;
        }

        @Override
        public String asString() {
            return this.base.asString() + "." + this.attr;
        }
    }
}

