/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl.ast;

import java.util.Collections;
import java.util.List;
import org.netbeans.modules.languages.hcl.ast.HCLExpression;

public abstract class HCLLiteral
extends HCLExpression {
    public static final Bool TRUE = new Bool(true);
    public static final Bool FALSE = new Bool(false);
    public static final Null NULL = new Null();

    @Override
    public final List<? extends HCLExpression> getChildren() {
        return Collections.emptyList();
    }

    public static final class NumericLit
    extends HCLLiteral {
        final String value;

        public NumericLit(String value) {
            this.value = value;
        }

        @Override
        public String asString() {
            return this.value;
        }
    }

    public static final class Null
    extends HCLLiteral {
        private Null() {
        }

        @Override
        public String asString() {
            return "null";
        }
    }

    public static final class StringLit
    extends HCLLiteral {
        final String value;

        public StringLit(String value) {
            this.value = value;
        }

        @Override
        public String asString() {
            return "\"" + this.value + "\"";
        }
    }

    public static final class Bool
    extends HCLLiteral {
        final boolean value;

        private Bool(boolean value) {
            this.value = value;
        }

        @Override
        public String asString() {
            return this.value ? "true" : "false";
        }
    }
}

