/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ko4j.debugging;

import java.lang.reflect.Method;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.ko4j.debugging.Server;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;

public final class TurnInspectOn
implements LateBoundPrerequisitesChecker {
    private static final Logger LOG = Logger.getLogger(TurnInspectOn.class.getName());

    public boolean checkRunConfig(RunConfig config, ExecutionContext con) {
        if (("debug".equals(config.getActionName()) || "run".equals(config.getActionName())) && TurnInspectOn.isBootFXOn(config)) {
            int port = Server.getInstance().acceptClient();
            config.setProperty("netbeans.inspect.port", "" + port);
        }
        String o = config.getActionName();
        return true;
    }

    private static boolean isBootFXOn(RunConfig config) {
        try {
            Method mpMethod = config.getClass().getMethod("getMavenProject", new Class[0]);
            Object mp = mpMethod.invoke((Object)config, new Object[0]);
            Method artiMethod = mp.getClass().getMethod("getArtifacts", new Class[0]);
            Set s = (Set)artiMethod.invoke(mp, new Object[0]);
            String text = s.toString();
            return text.contains("org.apidesign.html:boot-fx:") || text.contains("org.netbeans.html:net.java.html.boot.fx:") || text.contains("org.apidesign.bck2brwsr:bck2brwsr-maven-plugin");
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Problems obtaining list of artifacts", ex);
            return false;
        }
    }
}

