/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.parser;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.tm4e.core.internal.grammar.parser.PListGrammar;
import org.eclipse.tm4e.core.internal.parser.PListObject;
import org.eclipse.tm4e.core.internal.theme.PListTheme;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PList<T>
extends DefaultHandler {
    private final boolean theme;
    private final List<String> errors;
    private PListObject currObject;
    private T result;
    private StringBuilder text;

    public PList(boolean theme) {
        this.theme = theme;
        this.errors = new ArrayList<String>();
        this.currObject = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("dict".equals(localName)) {
            this.currObject = this.create(this.currObject, false);
        } else if ("array".equals(localName)) {
            this.currObject = this.create(this.currObject, true);
        } else if ("key".equals(localName) && this.currObject != null) {
            this.currObject.setLastKey(null);
        }
        this.text = new StringBuilder("");
        super.startElement(uri, localName, qName, attributes);
    }

    private PListObject create(PListObject parent, boolean valueAsArray) {
        if (this.theme) {
            return new PListTheme(parent, valueAsArray);
        }
        return new PListGrammar(parent, valueAsArray);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.endElement(localName);
        super.endElement(uri, localName, qName);
    }

    private void endElement(String tagName) {
        Object value = null;
        String text = this.text.toString();
        if ("key".equals(tagName)) {
            if (this.currObject == null || this.currObject.isValueAsArray()) {
                this.errors.add("key can only be used inside an open dict element");
                return;
            }
            this.currObject.setLastKey(text);
            return;
        }
        if ("dict".equals(tagName) || "array".equals(tagName)) {
            if (this.currObject == null) {
                this.errors.add(tagName + " closing tag found, without opening tag");
                return;
            }
            value = this.currObject.getValue();
            this.currObject = this.currObject.parent;
        } else if ("string".equals(tagName) || "data".equals(tagName)) {
            value = text;
        } else if (!"date".equals(tagName)) {
            if ("integer".equals(tagName)) {
                try {
                    value = Integer.parseInt(text);
                }
                catch (NumberFormatException e) {
                    this.errors.add(text + " is not a integer");
                    return;
                }
            } else if ("real".equals(tagName)) {
                try {
                    value = Float.valueOf(Float.parseFloat(text));
                }
                catch (NumberFormatException e) {
                    this.errors.add(text + " is not a float");
                    return;
                }
            } else if ("true".equals(tagName)) {
                value = true;
            } else if ("false".equals(tagName)) {
                value = false;
            } else {
                if ("plist".equals(tagName)) {
                    return;
                }
                this.errors.add("Invalid tag name: " + tagName);
                return;
            }
        }
        if (this.currObject == null) {
            this.result = value;
        } else if (this.currObject.isValueAsArray()) {
            this.currObject.addValue(value);
        } else if (this.currObject.getLastKey() != null) {
            this.currObject.addValue(value);
        } else {
            this.errors.add("Dictionary key missing for value " + value);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.text.append(String.valueOf(ch, start, length));
        super.characters(ch, start, length);
    }

    public T getResult() {
        return this.result;
    }
}

