/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.vault;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.vault.VaultsClient;
import com.oracle.bmc.vault.requests.ListSecretsRequest;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.vault.SecretItem;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;
import org.openide.nodes.Children;

public class SecretNode
extends OCINode {
    private static final String SECRET_ICON = "org/netbeans/modules/cloud/oracle/resources/secret.svg";

    public SecretNode(SecretItem vault) {
        super((OCIItem)vault, Children.LEAF);
        this.setName(vault.getName());
        this.setDisplayName(vault.getName());
        this.setIconBaseWithExtension(SECRET_ICON);
        this.setShortDescription(vault.getDescription());
    }

    public static NodeProvider<SecretItem> createNode() {
        return SecretNode::new;
    }

    public static ChildrenProvider<VaultItem, SecretItem> getSecrets() {
        return vault -> {
            VaultsClient client = VaultsClient.builder().build((AbstractAuthenticationDetailsProvider)OCIManager.getDefault().getActiveProfile().getConfigProvider());
            ListSecretsRequest listSecretsRequest = ListSecretsRequest.builder().compartmentId(vault.getCompartmentId()).vaultId(vault.getKey().getValue()).limit(Integer.valueOf(88)).build();
            return client.listSecrets(listSecretsRequest).getItems().stream().map(d -> new SecretItem(OCID.of(d.getId(), "Vault/Secret"), d.getSecretName(), d.getCompartmentId())).collect(Collectors.toList());
        };
    }
}

