/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.navigation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.jakarta.web.beans.api.model.InterceptorsResult;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.jakarta.web.beans.navigation.JavaHierarchyModel;
import org.netbeans.modules.jakarta.web.beans.navigation.TypeTreeNode;
import org.openide.filesystems.FileObject;

public final class InterceptorsModel
extends DefaultTreeModel
implements JavaHierarchyModel {
    private static final long serialVersionUID = 8135037731227112414L;
    private static final Logger LOG = Logger.getLogger(InterceptorsModel.class.getName());
    private MetadataModel<WebBeansModel> myModel;
    private List<ElementHandle<TypeElement>> myHandles;
    private Set<ElementHandle<TypeElement>> myDisabledInterceptors;

    public InterceptorsModel(InterceptorsResult result, CompilationController controller, MetadataModel<WebBeansModel> model) {
        super(null);
        this.myModel = model;
        List<TypeElement> interceptors = result.getAllInterceptors();
        this.myHandles = new ArrayList<ElementHandle<TypeElement>>(interceptors.size());
        this.myDisabledInterceptors = new HashSet<ElementHandle<TypeElement>>();
        HashSet<TypeElement> disabled = new HashSet<TypeElement>();
        for (TypeElement interceptor : interceptors) {
            ElementHandle handle = ElementHandle.create((Element)interceptor);
            this.myHandles.add((ElementHandle<TypeElement>)handle);
            if (!result.isDisabled(interceptor)) continue;
            this.myDisabledInterceptors.add((ElementHandle<TypeElement>)handle);
            disabled.add(interceptor);
        }
        this.update(interceptors, disabled, controller);
    }

    @Override
    public void fireTreeNodesChanged() {
        super.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)this.getRoot()), null, null);
    }

    @Override
    public void update() {
        this.updateHandles(this.myHandles, this.myDisabledInterceptors);
    }

    private void update(List<TypeElement> types, Set<TypeElement> disabled, CompilationController controller) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        for (TypeElement type : types) {
            FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)type), (ClasspathInfo)controller.getClasspathInfo());
            TypeTreeNode node = new TypeTreeNode(fileObject, type, disabled.contains(type), (CompilationInfo)controller);
            root.add(node);
        }
        this.setRoot(root);
    }

    private void updateHandles(final List<ElementHandle<TypeElement>> handles, final Set<ElementHandle<TypeElement>> disabled) {
        try {
            this.getModel().runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, Void>(){

                public Void run(WebBeansModel model) {
                    ArrayList<TypeElement> list = new ArrayList<TypeElement>(handles.size());
                    HashSet<TypeElement> set = new HashSet<TypeElement>();
                    for (ElementHandle handle : handles) {
                        TypeElement type = (TypeElement)handle.resolve((CompilationInfo)model.getCompilationController());
                        if (type != null) {
                            list.add(type);
                        }
                        if (!disabled.contains(handle)) continue;
                        set.add(type);
                    }
                    InterceptorsModel.this.update(list, set, model.getCompilationController());
                    return null;
                }
            });
            return;
        }
        catch (MetadataModelException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private MetadataModel<WebBeansModel> getModel() {
        return this.myModel;
    }
}

