/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.util.Collections;
import javax.swing.Action;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.maven.ActionProviderImpl;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.nodes.Bundle;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;

class SiteDocsNode
extends FilterNode {
    private static final String PSITE_BADGE = "org/netbeans/modules/maven/projectsite-badge.png";
    private NbMavenProjectImpl project;
    private boolean isTopLevelNode = false;

    SiteDocsNode(NbMavenProjectImpl proj, Node orig) {
        this(proj, orig, true);
    }

    private SiteDocsNode(NbMavenProjectImpl proj, Node orig, boolean isTopLevel) {
        super(orig, (Children)(orig.getChildren() == FilterNode.Children.LEAF ? FilterNode.Children.LEAF : new SiteFilterChildren(proj, orig)));
        this.isTopLevelNode = isTopLevel;
        this.project = proj;
    }

    public String getDisplayName() {
        if (this.isTopLevelNode) {
            String s = Bundle.LBL_Site_Pages();
            DataObject dob = (DataObject)this.getOriginal().getLookup().lookup(DataObject.class);
            FileObject file = dob.getPrimaryFile();
            try {
                s = file.getFileSystem().getDecorator().annotateName(s, Collections.singleton(file));
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            return s;
        }
        return this.getOriginal().getDisplayName();
    }

    public String getHtmlDisplayName() {
        if (!this.isTopLevelNode) {
            return this.getOriginal().getHtmlDisplayName();
        }
        try {
            DataObject dob = (DataObject)this.getOriginal().getLookup().lookup(DataObject.class);
            FileObject file = dob.getPrimaryFile();
            String s = Bundle.LBL_Site_Pages();
            String result = file.getFileSystem().getDecorator().annotateNameHtml(s, Collections.singleton(file));
            if (result != null && !s.equals(result)) {
                return result;
            }
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return super.getHtmlDisplayName();
    }

    public Action[] getActions(boolean param) {
        if (this.isTopLevelNode) {
            Action[] toReturn = new Action[4];
            toReturn[0] = CommonProjectActions.newFileAction();
            toReturn[1] = null;
            NetbeansActionMapping mapp = new NetbeansActionMapping();
            mapp.addGoal("site");
            toReturn[2] = ActionProviderImpl.createCustomMavenAction(Bundle.BTN_Generate_Site(), mapp, true, Lookup.EMPTY, this.project);
            mapp = new NetbeansActionMapping();
            mapp.addGoal("site:deploy");
            toReturn[3] = ActionProviderImpl.createCustomMavenAction(Bundle.BTN_Deploy_Site(), mapp, false, Lookup.EMPTY, this.project);
            return toReturn;
        }
        return super.getActions(param);
    }

    public Image getIcon(int param) {
        Image retValue = super.getIcon(param);
        if (this.isTopLevelNode) {
            retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ImageUtilities.loadImage((String)PSITE_BADGE), (int)8, (int)8);
        }
        return retValue;
    }

    public Image getOpenedIcon(int param) {
        Image retValue = super.getOpenedIcon(param);
        if (this.isTopLevelNode) {
            retValue = ImageUtilities.mergeImages((Image)retValue, (Image)ImageUtilities.loadImage((String)PSITE_BADGE), (int)8, (int)8);
        }
        return retValue;
    }

    static class SiteFilterChildren
    extends FilterNode.Children {
        private final NbMavenProjectImpl project;

        SiteFilterChildren(NbMavenProjectImpl proj, Node original) {
            super(original);
            this.project = proj;
        }

        protected Node[] createNodes(Node obj) {
            DataObject dobj = (DataObject)obj.getLookup().lookup(DataObject.class);
            if (dobj != null) {
                if (!VisibilityQuery.getDefault().isVisible(dobj.getPrimaryFile())) {
                    return new Node[0];
                }
                SiteDocsNode n = new SiteDocsNode(this.project, obj, false);
                return new Node[]{n};
            }
            Node origos = obj;
            return new Node[]{origos.cloneNode()};
        }
    }
}

