/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.editor.document.AtomicLockDocument;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.templates.FileBuilder;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.Bundle;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.options.NetworkProxySettings;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.NotificationDisplayer;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.SaveAsCapable;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.MapFormat;

public class MavenProxySupport {
    private static final Logger LOG = Logger.getLogger(MavenProxySupport.class.getName());
    private static final String PROBE_URI_STRING = "http://search.maven.org";
    private static final String FILENAME_SUFFIX_OLD = ".old";
    private static final String ICON_MAVEN_PROJECT = "org/netbeans/modules/maven/resources/Maven2Icon.gif";
    private static final String TAG_SETTINGS = "settings";
    private static final String TAG_PROXIES = "proxies";
    private static final String TAG_NAME_ACTIVE = "active";
    private static final String TAG_ACTIVE_START = "<active>";
    private static final String TAG_ACTIVE_END = "</active>\n";
    private static final String TAG_PROXY = "proxy";
    private static final String SUFFIX_NONE_PROXY = "-none";
    private static final String SUFFIX_NEW_PROXY = "-new";
    private static final String FILENAME_SETTINGS_EXT = ".xml";
    private static final String FILENAME_BASE_SETTINGS = "settings";
    private static final String FILENAME_SETTINGS = "settings.xml";
    private static final int PORT_DEFAULT_HTTPS = 1080;
    private static final int PORT_DEFAULT_HTTP = 80;
    private static Map<String, ProxyResult> acknowledgedResults = new HashMap<String, ProxyResult>();

    public MavenProxySupport(Project project) {
    }

    public CompletableFuture<ProxyResult> checkProxySettings() {
        return new Processor().checkProxy();
    }

    static class XppDelegate
    extends MXParser {
        private static final int UNKNOWN = 0;
        private static final int PROXIES = 1;
        private static final int PROXY = 2;
        private static final int INSIDE_PROXY = 3;
        private TextInfo textInfo = new TextInfo();
        private LinkedList<TagInfo> tagStack = new LinkedList();
        private ProxyInfo current;
        private int state = 0;
        private final Field posStartField;
        private final Field posEndField;
        private StringBuilder tagText = new StringBuilder();

        public XppDelegate(EntityReplacementMap entityReplacementMap) {
            super(entityReplacementMap);
            try {
                this.posEndField = MXParser.class.getDeclaredField("posEnd");
                this.posEndField.setAccessible(true);
                this.posStartField = MXParser.class.getDeclaredField("posStart");
                this.posStartField.setAccessible(true);
            }
            catch (ReflectiveOperationException ex) {
                throw new RuntimeException("code changed", ex);
            }
        }

        TextInfo getTextInfo() {
            return this.textInfo;
        }

        public int nextTag() throws XmlPullParserException, IOException {
            int t = super.nextTag();
            return this.processToken(t);
        }

        public int next() throws XmlPullParserException, IOException {
            int t = super.next();
            return this.processToken(t);
        }

        private LineAndColumn startPos() {
            int ln = this.getLineNumber();
            int col = this.getColumnNumber();
            try {
                col -= this.posEndField.getInt((Object)this) - this.posStartField.getInt((Object)this);
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return new LineAndColumn(ln, col);
        }

        private LineAndColumn pos() {
            return new LineAndColumn(this.getLineNumber(), this.getColumnNumber());
        }

        private int processToken(int token) {
            switch (token) {
                case 4: {
                    this.tagText.append(this.getText());
                    break;
                }
                case 3: {
                    String en = this.getName();
                    if (this.state >= 2) {
                        if (MavenProxySupport.TAG_PROXY.equals(en)) {
                            this.state = 1;
                            this.current = null;
                            this.tagStack.clear();
                            break;
                        }
                        if (this.tagStack.isEmpty()) break;
                        TagInfo ti = this.tagStack.removeLast();
                        ti.content = this.tagText.toString().trim();
                        ti.endTag = this.startPos();
                        break;
                    }
                    if (this.state != 1 || !MavenProxySupport.TAG_PROXIES.equals(en)) break;
                    this.state = 0;
                    this.textInfo.proxiesEndTag = this.startPos();
                    break;
                }
                case 2: {
                    String n = this.getName();
                    this.tagText = new StringBuilder();
                    if (this.state == 0) {
                        if (MavenProxySupport.TAG_PROXIES.equals(n)) {
                            this.state = 1;
                            break;
                        }
                        if ("settings".equals(n) || this.textInfo.firstTag != null) break;
                        this.textInfo.firstTag = this.startPos();
                        break;
                    }
                    if (this.state == 1 && MavenProxySupport.TAG_PROXY.equals(n)) {
                        this.textInfo.firstProxyTag = this.pos();
                        this.state = 3;
                        this.current = new ProxyInfo();
                        this.textInfo.proxyTags.add(this.current);
                    }
                    if (this.state < 2) break;
                    TagInfo ti = new TagInfo(n, this.startPos());
                    if (this.current != null) {
                        if (this.current.firstTag == null) {
                            this.current.firstTag = ti.startTag;
                        }
                        this.current.tags.putIfAbsent(ti.tagName, ti);
                    }
                    this.tagStack.add(ti);
                    break;
                }
            }
            return token;
        }
    }

    static class TextInfo {
        LineAndColumn firstTag;
        LineAndColumn firstProxyTag;
        LineAndColumn proxiesEndTag;
        List<ProxyInfo> proxyTags = new ArrayList<ProxyInfo>();

        TextInfo() {
        }
    }

    static class ProxyInfo {
        LineAndColumn firstTag;
        Map<String, TagInfo> tags = new HashMap<String, TagInfo>();

        ProxyInfo() {
        }
    }

    static class TagInfo {
        String tagName;
        LineAndColumn startTag;
        String content;
        LineAndColumn endTag;

        public TagInfo(String tagName, LineAndColumn start) {
            this.tagName = tagName;
            this.startTag = start;
        }
    }

    static class LineAndColumn {
        int line;
        int column;

        public LineAndColumn(int line, int column) {
            this.line = line;
            this.column = column;
        }
    }

    private class Processor {
        java.net.Proxy publicProxy;
        String publicProxyHost;
        int publicProxyPort;
        int publicProxyNonDefaultPort;
        String proxyAuthority;
        String proxyHost;
        String publicProxySpec;
        int proxyPort;
        Settings mavenSettings;

        private Processor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompletableFuture<ProxyResult> checkProxy() {
            ProxyResult result;
            boolean direct;
            boolean supportOverride = NetworkProxySettings.allowProxyOverride();
            NetworkProxySettings action = MavenSettings.getDefault().getNetworkProxy();
            if (action == NetworkProxySettings.IGNORE) {
                return CompletableFuture.completedFuture(this.createResult(Status.CONTINUE));
            }
            this.obtainPublicProxy();
            this.loadProjectProxy();
            boolean bl = direct = this.publicProxy == null || this.publicProxy.type() == Proxy.Type.DIRECT;
            if (direct && this.proxyAuthority == null) {
                LOG.log(Level.FINE, "Project does not specify a proxy and none is needed");
                return CompletableFuture.completedFuture(this.createResult(Status.CONTINUE));
            }
            if (this.publicProxy != null) {
                if (this.publicProxyHost == null) {
                    LOG.log(Level.WARNING, "Unable to decipher proxy: {0}", this.publicProxy);
                    return CompletableFuture.completedFuture(new ProxyResult(Status.UNKNOWN, null));
                }
                if (this.publicProxyHost.equals(this.proxyHost) && this.proxyPort == this.publicProxyPort) {
                    LOG.log(Level.FINE, "Project specifies detected proxy: {0}", this.publicProxySpec);
                    return CompletableFuture.completedFuture(new ProxyResult(Status.CONTINUE, this.publicProxy));
                }
            }
            String userMessage = direct ? Bundle.MSG_ProxyMisconfiguredDirect(this.proxyAuthority) : (this.proxyAuthority == null ? Bundle.MSG_ProxyMisconfiguredMissing(this.publicProxySpec) : Bundle.MSG_ProxyMisconfiguredOther(this.publicProxySpec, this.proxyAuthority));
            Processor processor = this;
            synchronized (processor) {
                result = (ProxyResult)acknowledgedResults.get(this.publicProxySpec);
            }
            if (result != null) {
                LOG.log(Level.FINE, "Reusing previous decision: {0} with proxy {1}", new Object[]{result.getStatus(), result.proxySpec});
                switch (result.getStatus()) {
                    case CONTINUE: {
                        action = NetworkProxySettings.IGNORE;
                        break;
                    }
                    case OVERRIDE: {
                        action = NetworkProxySettings.OVERRIDE;
                        break;
                    }
                    case RECONFIGURED: {
                        action = NetworkProxySettings.UPDATE;
                    }
                }
            }
            switch (action) {
                case IGNORE: {
                    return CompletableFuture.completedFuture(this.createResult(Status.CONTINUE));
                }
                case NOTICE: {
                    NotificationDisplayer.getDefault().notify(Bundle.TITLE_MavenProxyMismatch(), (Icon)ImageUtilities.loadImageIcon((String)MavenProxySupport.ICON_MAVEN_PROJECT, (boolean)false), userMessage, null, NotificationDisplayer.Priority.NORMAL, NotificationDisplayer.Category.WARNING);
                    return CompletableFuture.completedFuture(this.createResult(Status.CONTINUE));
                }
                case OVERRIDE: {
                    return CompletableFuture.completedFuture(this.createResult(Status.OVERRIDE));
                }
                case UPDATE: {
                    try {
                        result = this.createResult(Status.RECONFIGURED);
                        result.updateMavenProxy();
                    }
                    catch (IOException ex) {
                        result = this.createResult(ex);
                    }
                    return CompletableFuture.completedFuture(result);
                }
                case ASK: {
                    if (result != null) {
                        return CompletableFuture.completedFuture(result);
                    }
                    String promptMsg = supportOverride ? userMessage + Bundle.MSG_AppendAskUpdate() : userMessage + Bundle.MSG_AppendAskUpdate2();
                    NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)promptMsg, Bundle.TITLE_MavenProxyMismatch(), 2, 2);
                    if (supportOverride) {
                        desc.setAdditionalOptions(new Object[]{Bundle.ACTION_Continue(), Bundle.ACTION_Override()});
                    } else {
                        desc.setAdditionalOptions(new Object[]{Bundle.ACTION_Continue()});
                    }
                    desc.setValue(NotifyDescriptor.OK_OPTION);
                    return ((CompletableFuture)DialogDisplayer.getDefault().notifyFuture((NotifyDescriptor)desc).thenApply(this::processUserConfirmation)).exceptionally(t -> {
                        if (t instanceof CompletionException && t.getCause() instanceof CancellationException) {
                            return this.createResult(Status.ABORT);
                        }
                        return this.createResult(Status.UNKNOWN);
                    });
                }
            }
            return null;
        }

        ProxyResult createResult(IOException ex) {
            ProxyResult r = this.createResult(Status.ABORT);
            r.exception = ex;
            LOG.log(Level.WARNING, "Failed to configure proxy", ex);
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ProxyResult createResult(Status s) {
            boolean keep = false;
            switch (s) {
                case OVERRIDE: {
                    keep = true;
                    LOG.log(Level.FINE, "Will override proxy to {0}", this.publicProxy);
                    break;
                }
                case ABORT: {
                    LOG.log(Level.FINE, "Will abort operation");
                    break;
                }
                case CONTINUE: {
                    keep = true;
                    LOG.log(Level.FINE, "No action will be taken");
                    break;
                }
                case RECONFIGURED: {
                    LOG.log(Level.FINE, "User properties were reconfigured to {0}", this.publicProxy);
                }
            }
            ProxyResult r = new ProxyResult(s, this.publicProxy, this.proxyAuthority, this.publicProxySpec, this.publicProxyHost, this.publicProxyPort, this.publicProxyNonDefaultPort > 0, this.mavenSettings);
            if (keep) {
                Processor processor = this;
                synchronized (processor) {
                    acknowledgedResults.put(this.publicProxySpec, r);
                }
            }
            return r;
        }

        ProxyResult processUserConfirmation(NotifyDescriptor desc) {
            Object val = desc.getValue();
            if (val == NotifyDescriptor.CANCEL_OPTION) {
                return this.createResult(Status.ABORT);
            }
            if (val == Bundle.ACTION_Continue()) {
                return this.createResult(Status.CONTINUE);
            }
            if (val == Bundle.ACTION_Override()) {
                return this.createResult(Status.OVERRIDE);
            }
            if (val == NotifyDescriptor.OK_OPTION) {
                try {
                    ProxyResult result = this.createResult(Status.RECONFIGURED);
                    result.updateMavenProxy();
                }
                catch (IOException ex) {
                    return this.createResult(ex);
                }
            }
            return this.createResult(Status.UNKNOWN);
        }

        private void obtainPublicProxy() {
            SocketAddress proxyAddress;
            URI probeUri;
            try {
                probeUri = new URI(MavenProxySupport.PROBE_URI_STRING);
            }
            catch (URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return;
            }
            List<java.net.Proxy> proxies = ProxySelector.getDefault().select(probeUri);
            LOG.log(Level.FINER, "Detected proxies for URI {0}: {1}", new Object[]{probeUri, proxies});
            for (java.net.Proxy p : proxies) {
                if (p.type() == Proxy.Type.HTTP) {
                    this.publicProxy = p;
                    LOG.log(Level.FINE, "Selected HTTP proxy: {0}", p);
                    break;
                }
                if (p.type() != Proxy.Type.SOCKS || this.publicProxy != null) continue;
                LOG.log(Level.FINE, "Found SOCKS proxy: {0}", p);
                this.publicProxy = p;
            }
            if (this.publicProxy != null && (proxyAddress = this.publicProxy.address()) instanceof InetSocketAddress) {
                InetSocketAddress iaddr = (InetSocketAddress)proxyAddress;
                int port = iaddr.getPort();
                int defPort = -1;
                switch (this.publicProxy.type()) {
                    case HTTP: {
                        defPort = 80;
                        break;
                    }
                    case SOCKS: {
                        defPort = 1080;
                    }
                }
                if (port > 1) {
                    this.publicProxyPort = port;
                    if (this.publicProxyPort != defPort) {
                        this.publicProxyNonDefaultPort = port;
                    }
                }
                this.publicProxyHost = ((InetSocketAddress)proxyAddress).getHostString();
                this.publicProxySpec = this.publicProxyHost + (this.publicProxyNonDefaultPort == 0 ? "" : ":" + this.publicProxyNonDefaultPort);
                LOG.log(Level.FINE, "Detected proxy: {0}", this.publicProxySpec);
            }
        }

        private void loadProjectProxy() {
            this.mavenSettings = EmbedderFactory.getProjectEmbedder().getSettings();
            Proxy activeProxy = this.mavenSettings.getActiveProxy();
            if (activeProxy != null) {
                this.proxyHost = activeProxy.getHost();
                this.proxyPort = activeProxy.getPort();
                if (this.proxyPort > 0) {
                    this.proxyAuthority = this.proxyHost + ":" + this.proxyPort;
                }
            } else {
                this.proxyAuthority = null;
                this.proxyHost = null;
                this.proxyPort = -1;
            }
        }
    }

    public static final class ProxyResult {
        private final java.net.Proxy proxy;
        private final String toolProxy;
        private final String proxyHost;
        private final String proxySpec;
        private final int proxyPort;
        private final Settings mavenSettings;
        private final boolean nonDefaultPort;
        private volatile Status status;
        TextInfo textInfo;
        FileObject settingsDir;
        String settingsFileName = "settings.xml";
        IOException exception;
        private AtomicLockDocument adoc;
        private LineDocument settingsLineDoc;
        private EditorCookie settingsEditor;
        private Lookup fileLookup;
        private static final String FMT_PROXY_PORT = "proxyPort";
        private static final String FMT_PROXY_HOST = "proxyHost";

        public ProxyResult(Status status, java.net.Proxy proxy) {
            this.status = status;
            this.proxy = proxy;
            this.toolProxy = null;
            this.proxySpec = null;
            this.proxyHost = null;
            this.proxyPort = -1;
            this.mavenSettings = null;
            this.nonDefaultPort = false;
        }

        public ProxyResult(Status status, java.net.Proxy proxy, String toolProxy, String proxySpec, String proxyHost, int proxyPort, boolean nonDefault, Settings mavenSettings) {
            this.status = status;
            this.proxy = proxy;
            this.toolProxy = toolProxy;
            this.proxySpec = proxySpec;
            this.proxyHost = proxyHost;
            this.proxyPort = proxyPort;
            this.mavenSettings = mavenSettings;
            this.nonDefaultPort = nonDefault;
        }

        public Status getStatus() {
            return this.status;
        }

        public java.net.Proxy getProxy() {
            return this.proxy;
        }

        public String getToolProxy() {
            return this.toolProxy;
        }

        public String getProxySpec() {
            return this.proxySpec;
        }

        public IOException getException() {
            return this.exception;
        }

        private FileObject generateNewSettingsFile(Path settingsPath) throws IOException {
            Path dir;
            FileObject settingsDir;
            FileObject fileObject = settingsDir = this.settingsDir != null ? this.settingsDir : FileUtil.toFileObject((File)settingsPath.getParent().toFile());
            if (settingsDir == null && (settingsDir = FileUtil.toFileObject((File)(dir = Files.createDirectory(settingsPath.getParent(), new FileAttribute[0])).toFile())) == null) {
                throw new IOException(Bundle.ERROR_ConfigUpdateFailed(settingsPath.getParent()));
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(FMT_PROXY_HOST, this.proxyHost);
            params.put(FMT_PROXY_PORT, this.proxyPort);
            return FileBuilder.createFromTemplate((FileObject)FileUtil.getConfigFile((String)"Templates/Project/Maven2/settings.xml"), (FileObject)settingsDir, (String)this.settingsFileName, params, (FileBuilder.Mode)FileBuilder.Mode.FAIL);
        }

        private File getMavenSettings() {
            return new File(new File(System.getProperty("user.home"), ".m2"), MavenProxySupport.FILENAME_SETTINGS);
        }

        public BeanRunConfig configure(BeanRunConfig config) throws IOException {
            if (this.status != Status.OVERRIDE) {
                return config;
            }
            String uniqueString = "";
            try {
                Path p = this.getMavenSettings().toPath();
                if (!Files.exists(p, new LinkOption[0])) {
                    uniqueString = MavenProxySupport.SUFFIX_NEW_PROXY;
                } else {
                    MessageDigest dg = MessageDigest.getInstance("SHA1");
                    byte[] bytes = dg.digest(Files.readAllBytes(p));
                    StringBuilder sb = new StringBuilder("-");
                    for (int i = 0; i < bytes.length; ++i) {
                        sb.append(Integer.toHexString(bytes[i] & 0xFF));
                    }
                    uniqueString = sb.toString();
                }
            }
            catch (IOException | NoSuchAlgorithmException ex) {
                return config;
            }
            this.settingsDir = FileUtil.toFileObject((File)Places.getCacheSubdirectory((String)"maven"));
            if (this.settingsDir == null) {
                return config;
            }
            uniqueString = this.proxyHost == null ? uniqueString + MavenProxySupport.SUFFIX_NONE_PROXY : uniqueString + "-" + this.proxySpec.replace(":", "_");
            this.settingsFileName = "settings" + uniqueString + MavenProxySupport.FILENAME_SETTINGS_EXT;
            FileObject alreadyDone = this.settingsDir.getFileObject(this.settingsFileName);
            if (alreadyDone != null) {
                config.setInternalProperty("NbIde.configOverride", alreadyDone.getPath());
                return config;
            }
            this.updateMavenProxy();
            alreadyDone = this.settingsDir.getFileObject(this.settingsFileName);
            config.setInternalProperty("NbIde.configOverride", alreadyDone.getPath());
            return config;
        }

        private void loadMavenTextInfo() throws IOException, IllegalArgumentException {
            Path settingsPath = this.getMavenSettings().toPath();
            if (!Files.isReadable(settingsPath) && Files.isRegularFile(settingsPath, new LinkOption[0])) {
                this.generateNewSettingsFile(settingsPath);
                return;
            }
            XppDelegate del = new XppDelegate(EntityReplacementMap.defaultEntityReplacementMap);
            try (FileInputStream in = new FileInputStream(settingsPath.toFile());){
                del.setInput((Reader)ReaderFactory.newXmlReader((InputStream)in));
                while (del.next() != 1) {
                }
                this.textInfo = del.textInfo;
            }
            catch (XmlPullParserException ex) {
                throw new IOException(ex);
            }
        }

        private void loadSettingsContents() throws IOException {
            if (this.settingsEditor != null) {
                return;
            }
            Path settingsPath = this.getMavenSettings().toPath();
            FileObject fo = FileUtil.toFileObject((File)settingsPath.toFile());
            if (fo == null) {
                return;
            }
            this.fileLookup = fo.getLookup();
            EditorCookie cake = (EditorCookie)this.fileLookup.lookup(EditorCookie.class);
            if (cake == null) {
                throw new IOException(Bundle.ERR_CannoLocateSettings(settingsPath));
            }
            StyledDocument doc = cake.openDocument();
            this.settingsLineDoc = (LineDocument)LineDocumentUtils.as((Document)doc, LineDocument.class);
            this.adoc = (AtomicLockDocument)LineDocumentUtils.asRequired((Document)doc, AtomicLockDocument.class);
            if (this.settingsLineDoc == null) {
                throw new IOException(Bundle.ERR_CannoLocateSettings(settingsPath));
            }
            this.settingsEditor = cake;
            this.loadMavenTextInfo();
        }

        private String padding(int num) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < num; ++i) {
                sb.append(' ');
            }
            return sb.toString();
        }

        private void insertNewProxy() throws IOException {
            LineAndColumn insertAt;
            int startColumn = 0;
            StringBuilder textBuilder = new StringBuilder();
            if (this.textInfo.proxyTags.isEmpty()) {
                if (this.textInfo.proxiesEndTag != null) {
                    insertAt = this.textInfo.proxiesEndTag;
                    startColumn = insertAt.column - 1 + 4;
                    textBuilder.append("    ");
                } else {
                    insertAt = this.textInfo.firstTag;
                    startColumn = insertAt.column - 1;
                }
            } else {
                insertAt = this.textInfo.proxyTags.get((int)0).tags.get((Object)MavenProxySupport.TAG_PROXY).startTag;
                startColumn = insertAt.column - 1;
            }
            try (InputStream inputStream = this.getClass().getResourceAsStream(this.textInfo.proxiesEndTag != null ? "proxy.template.xml" : "proxies.template.xml");
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charset.forName(StandardCharsets.UTF_8.name())));){
                String s;
                boolean first = true;
                while ((s = reader.readLine()) != null) {
                    if (!first) {
                        textBuilder.append(this.padding(startColumn));
                    }
                    first = false;
                    textBuilder.append(s).append("\n");
                }
            }
            if (!this.textInfo.proxyTags.isEmpty()) {
                textBuilder.append(this.padding(startColumn));
            } else if (this.textInfo.proxiesEndTag != null) {
                textBuilder.append(this.padding(this.textInfo.proxiesEndTag.column - 1));
            } else {
                textBuilder.append(this.padding(startColumn));
            }
            HashMap<String, String> args = new HashMap<String, String>();
            args.put(FMT_PROXY_HOST, this.proxyHost);
            args.put(FMT_PROXY_PORT, Integer.toString(this.proxyPort));
            MapFormat fmt = new MapFormat(args);
            fmt.setLeftBrace("${");
            String contents = fmt.format((Object)textBuilder.toString());
            IOException[] err = new IOException[1];
            this.adoc.runAtomic(() -> {
                try {
                    int lineOffset = LineDocumentUtils.getLineStartFromIndex((LineDocument)this.settingsLineDoc, (int)(insertAt.line - 1));
                    int startOffset = lineOffset + insertAt.column - 1;
                    this.settingsLineDoc.insertString(startOffset, contents, null);
                }
                catch (BadLocationException ex) {
                    err[0] = new IOException(Bundle.ERR_CannotInsertProxy(this.proxyHost));
                }
            });
            if (err[0] != null) {
                throw err[0];
            }
        }

        private void enableProxy(Proxy p, int proxyIndex, boolean enable) throws IOException {
            String failureMsg;
            String string = failureMsg = enable ? Bundle.ERR_CannotEnableProxy(p.getId(), p.getHost()) : Bundle.ERR_CannotDisableProxy(p.getId(), p.getHost());
            if (this.textInfo.proxyTags.size() < proxyIndex) {
                throw new IOException(failureMsg);
            }
            ProxyInfo pi = this.textInfo.proxyTags.get(proxyIndex);
            TagInfo activeTag = pi.tags.get(MavenProxySupport.TAG_NAME_ACTIVE);
            IOException[] err = new IOException[1];
            if (activeTag != null) {
                this.adoc.runAtomic(() -> {
                    try {
                        int lineOffset = LineDocumentUtils.getLineStartFromIndex((LineDocument)this.settingsLineDoc, (int)(activeTag.startTag.line - 1));
                        int startOffset = lineOffset + activeTag.startTag.column - 1;
                        int endLineOffset = LineDocumentUtils.getLineStartFromIndex((LineDocument)this.settingsLineDoc, (int)(activeTag.endTag.line - 1));
                        int endOffset = endLineOffset + activeTag.endTag.column - 1;
                        String content = this.settingsLineDoc.getText(startOffset, endOffset - startOffset);
                        int endStartTagPos = content.indexOf(">");
                        if (endStartTagPos == -1 || endStartTagPos >= endOffset - startOffset) {
                            err[0] = new IOException(Bundle.ERR_CannotDisableProxy(p.getId(), p.getHost()));
                            return;
                        }
                        int from = startOffset + endStartTagPos + 1;
                        this.settingsLineDoc.remove(from, endOffset - from);
                        this.settingsLineDoc.insertString(from, enable ? "true" : "false", null);
                    }
                    catch (BadLocationException ex) {
                        err[0] = new IOException(failureMsg);
                    }
                });
            } else {
                if (pi.firstTag == null) {
                    throw new IOException(Bundle.ERR_CannotDisableProxy(p.getId(), p.getHost()));
                }
                String toInsert = this.padding(pi.firstTag.column) + MavenProxySupport.TAG_ACTIVE_START + enable + MavenProxySupport.TAG_ACTIVE_END;
                this.adoc.runAtomic(() -> {
                    try {
                        int lineOffset = LineDocumentUtils.getLineStartFromIndex((LineDocument)this.settingsLineDoc, (int)(pi.firstTag.line - 1));
                        this.settingsLineDoc.insertString(lineOffset, toInsert, null);
                    }
                    catch (BadLocationException ex) {
                        err[0] = new IOException(failureMsg);
                    }
                });
            }
            if (err[0] != null) {
                throw err[0];
            }
        }

        private void updateMavenProxy() throws IOException {
            this.loadSettingsContents();
            if (this.textInfo == null) {
                if (this.settingsDir != null) {
                    this.generateNewSettingsFile(FileUtil.toFile((FileObject)this.settingsDir).toPath().resolve(this.settingsFileName));
                } else {
                    this.generateNewSettingsFile(this.getMavenSettings().toPath());
                }
                return;
            }
            int pos = 0;
            if (this.proxyHost == null) {
                for (Proxy p : this.mavenSettings.getProxies()) {
                    if (p.isActive()) {
                        this.enableProxy(p, pos, false);
                    }
                    ++pos;
                }
            } else {
                Proxy existingProxy = null;
                for (Proxy p : this.mavenSettings.getProxies()) {
                    if (!this.proxyHost.equals(p.getHost()) || this.nonDefaultPort && this.proxyPort != p.getPort()) continue;
                    existingProxy = p;
                    break;
                }
                for (Proxy p : this.mavenSettings.getProxies()) {
                    if (p != existingProxy) {
                        this.enableProxy(p, pos, false);
                    }
                    ++pos;
                }
                if (existingProxy != null) {
                    if (!existingProxy.isActive()) {
                        int proxyIndex = this.mavenSettings.getProxies().indexOf(existingProxy);
                        if (proxyIndex == -1) {
                            throw new IOException(Bundle.ERR_CannotEnableProxy(existingProxy.getId(), existingProxy.getHost()));
                        }
                        this.enableProxy(existingProxy, proxyIndex, true);
                    }
                } else {
                    this.insertNewProxy();
                }
            }
            if (this.settingsEditor.isModified()) {
                if (this.settingsDir != null) {
                    SaveAsCapable saa = (SaveAsCapable)this.fileLookup.lookup(SaveAsCapable.class);
                    if (saa != null) {
                        saa.saveAs(this.settingsDir, this.settingsFileName);
                    }
                } else {
                    File settings = this.getMavenSettings();
                    String base = settings + MavenProxySupport.FILENAME_SUFFIX_OLD;
                    File f = new File(settings.getParentFile(), base);
                    int n = 1;
                    while (f.exists()) {
                        f = new File(settings.getParentFile(), base + "." + n);
                        ++n;
                    }
                    settings.renameTo(f);
                    this.settingsEditor.saveDocument();
                }
            }
        }
    }

    public static enum Status {
        UNKNOWN,
        CONTINUE,
        RECONFIGURED,
        OVERRIDE,
        ABORT;

    }
}

