/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.execute;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.function.Function;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionProfile;
import org.netbeans.modules.maven.execute.model.io.xpp3.NetbeansBuildActionXpp3Reader;
import org.netbeans.modules.maven.spi.actions.AbstractMavenActionsProvider;
import org.openide.util.NbBundle;

public class DefaultActionGoalProvider
extends AbstractMavenActionsProvider {
    private static final String MAPPINGS = "org/netbeans/modules/maven/execute/defaultActionMappings.xml";

    public DefaultActionGoalProvider() {
        this.reader = DefaultActionGoalProvider.createI18nReader(NbBundle.getBundle(DefaultActionGoalProvider.class));
    }

    public static NetbeansBuildActionXpp3Reader createI18nReader(final ResourceBundle bundle) {
        return new NetbeansBuildActionXpp3Reader(){

            @Override
            public ActionToGoalMapping read(Reader reader, boolean strict) throws IOException, XmlPullParserException {
                ActionToGoalMapping agm = super.read(reader, strict);
                return DefaultActionGoalProvider.supplyDisplayNames(bundle, agm);
            }
        };
    }

    private static String supplyDisplayName(String prefix, String id, String d, Function<String, String> defaultTranslator) {
        if (d == null) {
            try {
                d = defaultTranslator.apply(prefix + id);
            }
            catch (MissingResourceException missingResourceException) {}
        } else if (d.startsWith("#")) {
            String key = d.substring(1);
            int sep = key.indexOf(35);
            if (sep == -1) {
                d = defaultTranslator.apply(key);
            } else {
                String bname = key.substring(sep);
                key = key.substring(sep + 1);
                try {
                    d = NbBundle.getBundle((String)bname).getString(key);
                }
                catch (MissingResourceException missingResourceException) {}
            }
        } else {
            return null;
        }
        return d;
    }

    private static ActionToGoalMapping supplyDisplayNames(ResourceBundle bundle, ActionToGoalMapping agm) {
        if (agm.getActions() != null) {
            DefaultActionGoalProvider.supplyDisplayNames(bundle, agm.getActions());
        }
        if (agm.getProfiles() != null) {
            for (NetbeansActionProfile nap : agm.getProfiles()) {
                String d = DefaultActionGoalProvider.supplyDisplayName("profile.", nap.getId(), nap.getDisplayName(), bundle::getString);
                if (d != null) {
                    nap.setDisplayName(d);
                }
                DefaultActionGoalProvider.supplyDisplayNames(bundle, nap.getActions());
            }
        }
        return agm;
    }

    private static void supplyDisplayNames(ResourceBundle bundle, List<NetbeansActionMapping> actions) {
        for (NetbeansActionMapping m : actions) {
            String d = DefaultActionGoalProvider.supplyDisplayName("action.", m.getActionName(), m.getDisplayName(), bundle::getString);
            if (d == null) continue;
            m.setDisplayName(d);
        }
    }

    @Override
    protected InputStream getActionDefinitionStream() {
        return DefaultActionGoalProvider.class.getClassLoader().getResourceAsStream(MAPPINGS);
    }
}

