/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.tool;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.internal.jshell.debug.InternalDebugControl;
import jdk.jshell.DeclarationSnippet;
import jdk.jshell.Diag;
import jdk.jshell.EvalException;
import jdk.jshell.ExpressionSnippet;
import jdk.jshell.ImportSnippet;
import jdk.jshell.JShell;
import jdk.jshell.MethodSnippet;
import jdk.jshell.Snippet;
import jdk.jshell.SnippetEvent;
import jdk.jshell.SourceCodeAnalysis;
import jdk.jshell.TypeDeclSnippet;
import jdk.jshell.UnresolvedReferenceException;
import jdk.jshell.VarSnippet;
import org.netbeans.modules.jshell.tool.ArgTokenizer;
import org.netbeans.modules.jshell.tool.ContinuousCompletionProvider;
import org.netbeans.modules.jshell.tool.Feedback;
import org.netbeans.modules.jshell.tool.FileScannerIOContext;
import org.netbeans.modules.jshell.tool.IOContext;
import org.netbeans.modules.jshell.tool.MessageHandler;
import org.netbeans.modules.jshell.tool.ReloadIOContext;

public class JShellTool
implements MessageHandler {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final Pattern LINEBREAK = Pattern.compile("\\R");
    private static final String RECORD_SEPARATOR = "\u241e";
    private static final String RB_NAME_PREFIX = "org.netbeans.modules.jshell.tool";
    private static final String VERSION_RB_NAME = "org.netbeans.modules.jshell.tool.version";
    private static final String L10N_RB_NAME = "org.netbeans.modules.jshell.tool.l10n";
    final InputStream cmdin;
    final PrintStream cmdout;
    final PrintStream cmderr;
    final PrintStream console;
    final InputStream userin;
    final PrintStream userout;
    final PrintStream usererr;
    final Preferences prefs;
    final Map<String, String> envvars;
    final Locale locale;
    final Feedback feedback = new Feedback();
    private ResourceBundle versionRB = null;
    private ResourceBundle outputRB = null;
    private IOContext input = null;
    private boolean regenerateOnDeath = true;
    private boolean live = false;
    private boolean feedbackInitialized = false;
    private String commandLineFeedbackMode = null;
    private List<String> remoteVMOptions = new ArrayList<String>();
    private List<String> compilerOptions = new ArrayList<String>();
    SourceCodeAnalysis analysis;
    JShell state = null;
    JShell.Subscription shutdownSubscription = null;
    static final EditorSetting BUILT_IN_EDITOR = new EditorSetting(null, false);
    private boolean debug = false;
    public boolean testPrompt = false;
    private String cmdlineClasspath = null;
    private String startup = null;
    private EditorSetting editor = BUILT_IN_EDITOR;
    private static final String[] EDITOR_ENV_VARS = new String[]{"JSHELLEDITOR", "VISUAL", "EDITOR"};
    private List<String> replayableHistory;
    private List<String> replayableHistoryPrevious;
    static final String STARTUP_KEY = "STARTUP";
    static final String EDITOR_KEY = "EDITOR";
    static final String FEEDBACK_KEY = "FEEDBACK";
    static final String MODE_KEY = "MODE";
    static final String REPLAY_RESTORE_KEY = "REPLAY_RESTORE";
    static final String DEFAULT_STARTUP = "\nimport java.io.*;\nimport java.math.*;\nimport java.net.*;\nimport java.nio.file.*;\nimport java.util.*;\nimport java.util.concurrent.*;\nimport java.util.function.*;\nimport java.util.prefs.*;\nimport java.util.regex.*;\nimport java.util.stream.*;\nvoid printf(String format, Object... args) { System.out.printf(format, args); }\n";
    NameSpace mainNamespace;
    NameSpace startNamespace;
    NameSpace errorNamespace;
    NameSpace currentNameSpace;
    Map<Snippet, SnippetInfo> mapSnippet;
    boolean permitSystemSettings = false;
    static final CompletionProvider EMPTY_COMPLETION_PROVIDER = new FixedCompletionProvider(new String[0]);
    private static final CompletionProvider KEYWORD_COMPLETION_PROVIDER = new FixedCompletionProvider("-all ", "-start ", "-history ");
    private static final CompletionProvider RELOAD_OPTIONS_COMPLETION_PROVIDER = new FixedCompletionProvider("-restore", "-quiet");
    private static final CompletionProvider SET_MODE_OPTIONS_COMPLETION_PROVIDER = new FixedCompletionProvider("-command", "-quiet", "-delete");
    private final CompletionProvider FILE_COMPLETION_PROVIDER = this.fileCompletions(p -> true);
    private final Map<String, Command> commands = new LinkedHashMap<String, Command>();
    private ContinuousCompletionProvider commandCompletions;
    private static final String[] SET_SUBCOMMANDS = new String[]{"format", "truncation", "feedback", "mode", "prompt", "editor", "start"};

    public JShellTool(InputStream in, PrintStream out, PrintStream err) {
        this(in, out, err, out, null, out, err, Preferences.userRoot().node("tool/JShell"), System.getenv(), Locale.getDefault());
    }

    public JShellTool(InputStream cmdin, PrintStream cmdout, PrintStream cmderr, PrintStream console, InputStream userin, PrintStream userout, PrintStream usererr, Preferences prefs, Map<String, String> envvars, Locale locale) {
        this.registerCommand(new Command("/list", arg -> this.cmdList((String)arg), this.snippetKeywordCompletion(this::allSnippets)));
        this.registerCommand(new Command("/drop", arg -> this.cmdDrop((String)arg), this.snippetCompletion(this::dropableSnippets), CommandKind.REPLAY));
        this.registerCommand(new Command("/save", arg -> this.cmdSave((String)arg), this.saveCompletion()));
        this.registerCommand(new Command("/open", arg -> this.cmdOpen((String)arg), this.FILE_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/vars", arg -> this.cmdVars((String)arg), this.snippetKeywordCompletion(this::allVarSnippets)));
        this.registerCommand(new Command("/methods", arg -> this.cmdMethods((String)arg), this.snippetKeywordCompletion(this::allMethodSnippets)));
        this.registerCommand(new Command("/types", arg -> this.cmdTypes((String)arg), this.snippetKeywordCompletion(this::allTypeSnippets)));
        this.registerCommand(new Command("/imports", arg -> this.cmdImports(), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/exit", arg -> this.cmdExit(), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/reset", arg -> this.cmdReset(), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/reload", arg -> this.cmdReload((String)arg), JShellTool.reloadCompletion()));
        this.registerCommand(new Command("/classpath", arg -> this.cmdClasspath((String)arg), this.classPathCompletion(), CommandKind.REPLAY));
        this.registerCommand(new Command("/history", arg -> this.cmdHistory(), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/debug", arg -> this.cmdDebug((String)arg), EMPTY_COMPLETION_PROVIDER, CommandKind.HIDDEN));
        this.registerCommand(new Command("/help", arg -> this.cmdHelp((String)arg), EMPTY_COMPLETION_PROVIDER));
        this.registerCommand(new Command("/set", arg -> this.cmdSet((String)arg), new ContinuousCompletionProvider(JShellTool.Mapof("format", this.feedback.modeCompletions(), "truncation", this.feedback.modeCompletions(), "feedback", this.feedback.modeCompletions(), "mode", JShellTool.skipWordThenCompletion(JShellTool.orMostSpecificCompletion(this.feedback.modeCompletions(SET_MODE_OPTIONS_COMPLETION_PROVIDER), SET_MODE_OPTIONS_COMPLETION_PROVIDER)), "start", this.FILE_COMPLETION_PROVIDER), ContinuousCompletionProvider.STARTSWITH_MATCHER), CommandKind.NORMAL));
        this.registerCommand(new Command("/?", "help.quest", arg -> this.cmdHelp((String)arg), EMPTY_COMPLETION_PROVIDER, CommandKind.NORMAL));
        this.registerCommand(new Command("/!", "help.bang", arg -> this.cmdUseHistoryEntry(-1), EMPTY_COMPLETION_PROVIDER, CommandKind.NORMAL));
        this.registerCommand(new Command("/<id>", "help.id", CommandKind.HELP_ONLY));
        this.registerCommand(new Command("/-<n>", "help.previous", CommandKind.HELP_ONLY));
        this.registerCommand(new Command("intro", "help.intro", CommandKind.HELP_SUBJECT));
        this.registerCommand(new Command("shortcuts", "help.shortcuts", CommandKind.HELP_SUBJECT));
        this.commandCompletions = new ContinuousCompletionProvider(this.commands.values().stream().filter(c -> c.kind.shouldSuggestCompletions).collect(Collectors.toMap(c -> c.command, c -> c.completions)), ContinuousCompletionProvider.STARTSWITH_MATCHER);
        this.cmdin = cmdin;
        this.cmdout = cmdout;
        this.cmderr = cmderr;
        this.console = console;
        this.userin = userin != null ? userin : new InputStream(){

            @Override
            public int read() throws IOException {
                return JShellTool.this.input.readUserInput();
            }
        };
        this.userout = userout;
        this.usererr = usererr;
        this.prefs = prefs;
        this.envvars = envvars;
        this.locale = locale;
    }

    boolean interactive() {
        return this.input != null && this.input.interactiveOutput();
    }

    void debug(String format, Object ... args) {
        if (this.debug) {
            this.cmderr.printf(format + "\n", args);
        }
    }

    void rawout(String format, Object ... args) {
        this.cmdout.printf(format, args);
    }

    @Override
    public void hard(String format, Object ... args) {
        this.rawout(this.feedback.getPre() + format + this.feedback.getPost(), args);
    }

    void error(String format, Object ... args) {
        this.rawout(this.feedback.getErrorPre() + format + this.feedback.getErrorPost(), args);
    }

    @Override
    public boolean showFluff() {
        return this.feedback.shouldDisplayCommandFluff() && this.interactive();
    }

    @Override
    public void fluff(String format, Object ... args) {
        if (this.showFluff()) {
            this.hard(format, args);
        }
    }

    void fluffRaw(String format, Object ... args) {
        if (this.showFluff()) {
            this.rawout(format, args);
        }
    }

    String getResourceString(String key) {
        String s;
        if (this.outputRB == null) {
            try {
                this.outputRB = ResourceBundle.getBundle(L10N_RB_NAME, this.locale);
            }
            catch (MissingResourceException mre) {
                this.error("Cannot find ResourceBundle: %s for locale: %s", L10N_RB_NAME, this.locale);
                return "";
            }
        }
        try {
            s = this.outputRB.getString(key);
        }
        catch (MissingResourceException mre) {
            this.error("Missing resource: %s in %s", key, L10N_RB_NAME);
            return "";
        }
        return s;
    }

    String prefix(String s) {
        return this.prefix(s, this.feedback.getPre());
    }

    String prefix(String s, String leading) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        return leading + s.substring(0, s.length() - 1).replaceAll("\\R", System.getProperty("line.separator") + this.feedback.getPre()) + s.substring(s.length() - 1);
    }

    void hardrb(String key) {
        String s = this.prefix(this.getResourceString(key));
        this.cmdout.println(s);
    }

    String messageFormat(String key, Object ... args) {
        String rs = this.getResourceString(key);
        return MessageFormat.format(rs, args);
    }

    @Override
    public void hardmsg(String key, Object ... args) {
        this.cmdout.println(this.prefix(this.messageFormat(key, args)));
    }

    @Override
    public void errormsg(String key, Object ... args) {
        if (this.isRunningInteractive()) {
            this.cmdout.println(this.prefix(this.messageFormat(key, args), this.feedback.getErrorPre()));
        } else {
            this.startmsg(key, args);
        }
    }

    void startmsg(String key, Object ... args) {
        this.cmderr.println(this.prefix(this.messageFormat(key, args), ""));
    }

    @Override
    public void fluffmsg(String key, Object ... args) {
        if (this.showFluff()) {
            this.hardmsg(key, args);
        }
    }

    <T> void hardPairs(Stream<T> stream, Function<T, String> a, Function<T, String> b) {
        Map a2b = stream.collect(Collectors.toMap(a, b, (m1, m2) -> m1, () -> new LinkedHashMap()));
        int aLen = 0;
        for (String av : a2b.keySet()) {
            aLen = Math.max(aLen, av.length());
        }
        String format = "   %-" + aLen + "s -- %s";
        String indentedNewLine = LINE_SEP + this.feedback.getPre() + String.format("   %-" + (aLen + 4) + "s", "");
        for (Map.Entry e : a2b.entrySet()) {
            this.hard(format, e.getKey(), ((String)e.getValue()).replace("\n", indentedNewLine));
        }
    }

    static String trimEnd(String s) {
        int last;
        int i;
        for (i = last = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        if (i != last) {
            return s.substring(0, i + 1);
        }
        return s;
    }

    public static void main(String[] args) throws Exception {
        new JShellTool(System.in, System.out, System.err).start(args);
    }

    public void start(String[] args) throws Exception {
        List<String> loadList = null;
        if (loadList == null) {
            return;
        }
        try (IOContext in = this.createIOContext(this, this.cmdin, this.console);){
            this.start(in, loadList);
        }
    }

    protected IOContext createIOContext(JShellTool tool, InputStream cmdIn, PrintStream console) {
        return null;
    }

    protected void initStartup() {
        if (this.startup == null) {
            this.startup = this.prefs.get(STARTUP_KEY, null);
            if (this.startup == null) {
                this.startup = DEFAULT_STARTUP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(IOContext in, List<String> loadList) {
        this.initStartup();
        this.configEditor();
        this.resetState();
        String prevReplay = this.prefs.get(REPLAY_RESTORE_KEY, null);
        if (prevReplay != null) {
            this.replayableHistoryPrevious = Arrays.asList(prevReplay.split(RECORD_SEPARATOR));
        }
        for (String loadFile : loadList) {
            this.runFile(loadFile, "jshell");
        }
        if (this.regenerateOnDeath) {
            this.hardmsg("jshell.msg.welcome", this.version());
        }
        try {
            while (this.regenerateOnDeath) {
                if (!this.live) {
                    this.resetState();
                }
                this.run(in);
            }
        }
        finally {
            this.closeState();
        }
    }

    private EditorSetting configEditor() {
        this.editor = EditorSetting.fromPrefs(this.prefs);
        if (this.editor != null) {
            return this.editor;
        }
        for (String envvar : EDITOR_ENV_VARS) {
            String v = this.envvars.get(envvar);
            if (v == null) continue;
            this.editor = new EditorSetting(v.split("\\s+"), false);
            return this.editor;
        }
        this.editor = BUILT_IN_EDITOR;
        return this.editor;
    }

    protected void resetState() {
        this.closeState();
        this.mainNamespace = new NameSpace("main", "");
        this.startNamespace = new NameSpace("start", "s");
        this.errorNamespace = new NameSpace("error", "e");
        this.mapSnippet = new LinkedHashMap<Snippet, SnippetInfo>();
        this.currentNameSpace = this.startNamespace;
        this.replayableHistoryPrevious = this.replayableHistory;
        this.replayableHistory = new ArrayList<String>();
        this.state = this.createJShellInstance();
        this.shutdownSubscription = this.state.onShutdown(deadState -> {
            if (deadState == this.state) {
                this.hardmsg("jshell.msg.terminated", new Object[0]);
                this.live = false;
            }
        });
        this.analysis = this.state.sourceCodeAnalysis();
        this.live = true;
        if (!this.feedbackInitialized) {
            this.feedbackInitialized = true;
            this.initFeedback();
        }
        if (this.cmdlineClasspath != null) {
            this.state.addToClasspath(this.cmdlineClasspath);
        }
        this.startUpRun(this.startup);
        this.currentNameSpace = this.mainNamespace;
    }

    protected JShell createJShellInstance() {
        return this.makeBuilder().build();
    }

    protected JShell.Builder makeBuilder() {
        return JShell.builder().in(this.userin).out(this.userout).err(this.usererr).tempVariableNameGenerator(() -> "$" + this.currentNameSpace.tidNext()).idGenerator((sn, i) -> this.currentNameSpace == this.startNamespace || this.state.status((Snippet)sn).isActive() ? this.currentNameSpace.tid((Snippet)sn) : this.errorNamespace.tid((Snippet)sn)).remoteVMOptions((String[])this.remoteVMOptions.stream().toArray(String[]::new)).compilerOptions((String[])this.compilerOptions.stream().toArray(String[]::new));
    }

    private boolean isRunningInteractive() {
        return this.currentNameSpace != null && this.currentNameSpace == this.mainNamespace;
    }

    private void initFeedback() {
        InitMessageHandler initmh = new InitMessageHandler();
        this.permitSystemSettings = true;
        this.startUpRun(this.getResourceString("startup.feedback"));
        this.permitSystemSettings = false;
        this.feedback.markModesReadOnly();
        String encoded = this.prefs.get(MODE_KEY, null);
        if (encoded != null && !encoded.isEmpty() && !this.feedback.restoreEncodedModes(initmh, encoded)) {
            this.prefs.remove(MODE_KEY);
        }
        if (this.commandLineFeedbackMode != null) {
            if (!this.setFeedback(initmh, new ArgTokenizer("--feedback", this.commandLineFeedbackMode))) {
                this.regenerateOnDeath = false;
            }
            this.commandLineFeedbackMode = null;
        } else {
            String fb = this.prefs.get(FEEDBACK_KEY, null);
            if (fb != null) {
                this.setFeedback(initmh, new ArgTokenizer("previous retain feedback", "-retain " + fb));
            }
        }
    }

    protected void startUpRun(String start) {
        try (FileScannerIOContext suin = new FileScannerIOContext(new StringReader(start));){
            this.run(suin);
        }
        catch (Exception ex) {
            this.hardmsg("jshell.err.startup.unexpected.exception", ex);
            ex.printStackTrace(this.cmdout);
        }
    }

    protected void closeState() {
        this.live = false;
        JShell oldState = this.state;
        if (oldState != null) {
            oldState.unsubscribe(this.shutdownSubscription);
            oldState.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void run(IOContext in) {
        IOContext oldInput = this.input;
        this.input = in;
        try {
            String incomplete = "";
            while (this.live) {
                String raw;
                String prompt = this.isRunningInteractive() ? (this.testPrompt ? (incomplete.isEmpty() ? "\u0005" : "\u0006") : (incomplete.isEmpty() ? this.feedback.getPrompt(this.currentNameSpace.tidNext()) : this.feedback.getContinuationPrompt(this.currentNameSpace.tidNext()))) : "";
                try {
                    raw = in.readLine(prompt, incomplete);
                }
                catch (IOContext.InputInterruptedException ex) {
                    incomplete = "";
                    continue;
                }
                if (raw == null) {
                    if (in.interactiveOutput()) {
                        this.regenerateOnDeath = false;
                    }
                    break;
                }
                incomplete = this.process(incomplete, raw);
            }
        }
        catch (IOException ex) {
            this.errormsg("jshell.err.unexpected.exception", ex);
        }
        finally {
            this.input = oldInput;
        }
    }

    protected String process(String incomplete, String raw) {
        String trimmed = JShellTool.trimEnd(raw);
        if (!trimmed.isEmpty()) {
            String line = incomplete + trimmed;
            if (incomplete.isEmpty() && line.startsWith("/") && !line.startsWith("//") && !line.startsWith("/*")) {
                this.processCommand(line.trim());
            } else {
                incomplete = this.processSourceCatchingReset(line);
            }
        }
        return incomplete;
    }

    protected void addToReplayHistory(String s) {
        if (this.isRunningInteractive()) {
            this.replayableHistory.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String processSourceCatchingReset(String src) {
        try {
            this.input.beforeUserCode();
            String string = this.processSource(src);
            return string;
        }
        catch (IllegalStateException ex) {
            this.hard("Resetting...", new Object[0]);
            this.live = false;
            String string = "";
            return string;
        }
        finally {
            this.input.afterUserCode();
        }
    }

    private void processCommand(String cmd) {
        if (cmd.startsWith("/-")) {
            try {
                this.cmdUseHistoryEntry(Integer.parseInt(cmd.substring(1)));
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String arg = "";
        int idx = cmd.indexOf(32);
        if (idx > 0) {
            arg = cmd.substring(idx + 1).trim();
            cmd = cmd.substring(0, idx);
        }
        Command[] candidates = this.findCommand(cmd, c -> c.kind.isRealCommand);
        switch (candidates.length) {
            case 0: {
                if (this.rerunHistoryEntryById(cmd.substring(1))) break;
                this.errormsg("jshell.err.no.such.command.or.snippet.id", cmd);
                this.fluffmsg("jshell.msg.help.for.help", new Object[0]);
                break;
            }
            case 1: {
                Command command = candidates[0];
                if (!command.run.apply(arg).booleanValue() || command.kind != CommandKind.REPLAY) break;
                this.addToReplayHistory((command.command + " " + arg).trim());
                break;
            }
            default: {
                this.errormsg("jshell.err.command.ambiguous", cmd, Arrays.stream(candidates).map(c -> c.command).collect(Collectors.joining(", ")));
                this.fluffmsg("jshell.msg.help.for.help", new Object[0]);
            }
        }
    }

    private Command[] findCommand(String cmd, Predicate<Command> filter) {
        Command exact = this.commands.get(cmd);
        if (exact != null) {
            return new Command[]{exact};
        }
        return (Command[])this.commands.values().stream().filter(filter).filter(command -> command.command.startsWith(cmd)).toArray(Command[]::new);
    }

    protected Path toPathResolvingUserHome(String pathString) {
        if (pathString.replace(File.separatorChar, '/').startsWith("~/")) {
            return Paths.get(System.getProperty("user.home"), pathString.substring(2));
        }
        return Paths.get(pathString, new String[0]);
    }

    private void registerCommand(Command cmd) {
        this.commands.put(cmd.command, cmd);
    }

    private static CompletionProvider skipWordThenCompletion(CompletionProvider completionProvider) {
        return (input, cursor, anchor) -> {
            List<Object> result = Collections.emptyList();
            int space = input.indexOf(32);
            if (space != -1) {
                String rest = input.substring(space + 1);
                result = completionProvider.completionSuggestions(rest, cursor - space - 1, anchor);
                anchor[0] = anchor[0] + (space + 1);
            }
            return result;
        };
    }

    private CompletionProvider fileCompletions(Predicate<Path> accept) {
        return (code, cursor, anchor) -> {
            int lastSlash = code.lastIndexOf(47);
            String path = code.substring(0, lastSlash + 1);
            String prefix = lastSlash != -1 ? code.substring(lastSlash + 1) : code;
            Path current = this.toPathResolvingUserHome(path);
            ArrayList result = new ArrayList();
            try (Stream<Path> dir = Files.list(current);){
                dir.filter(f -> accept.test((Path)f) && f.getFileName().toString().startsWith(prefix)).map(f -> new ArgSuggestion(f.getFileName() + (Files.isDirectory(f, new LinkOption[0]) ? "/" : ""))).forEach(result::add);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (path.isEmpty()) {
                StreamSupport.stream(FileSystems.getDefault().getRootDirectories().spliterator(), false).filter(root -> accept.test((Path)root) && root.toString().startsWith(prefix)).map(root -> new ArgSuggestion(root.toString())).forEach(result::add);
            }
            anchor[0] = path.length();
            return result;
        };
    }

    private CompletionProvider classPathCompletion() {
        return this.fileCompletions(p -> Files.isDirectory(p, new LinkOption[0]) || p.getFileName().toString().endsWith(".zip") || p.getFileName().toString().endsWith(".jar"));
    }

    private CompletionProvider snippetCompletion(Supplier<Stream<? extends Snippet>> snippetsSupplier) {
        return (prefix, cursor, anchor) -> {
            anchor[0] = 0;
            return ((Stream)snippetsSupplier.get()).flatMap(k -> k instanceof DeclarationSnippet ? Stream.of(String.valueOf(k.id()), ((DeclarationSnippet)k).name()) : Stream.of(String.valueOf(k.id()))).filter(k -> k.startsWith(prefix)).map(k -> new ArgSuggestion((String)k)).collect(Collectors.toList());
        };
    }

    private CompletionProvider snippetKeywordCompletion(Supplier<Stream<? extends Snippet>> snippetsSupplier) {
        return (code, cursor, anchor) -> {
            ArrayList<SourceCodeAnalysis.Suggestion> result = new ArrayList<SourceCodeAnalysis.Suggestion>();
            result.addAll(KEYWORD_COMPLETION_PROVIDER.completionSuggestions(code, cursor, anchor));
            result.addAll(this.snippetCompletion(snippetsSupplier).completionSuggestions(code, cursor, anchor));
            return result;
        };
    }

    private CompletionProvider saveCompletion() {
        return (code, cursor, anchor) -> {
            ArrayList<SourceCodeAnalysis.Suggestion> result = new ArrayList<SourceCodeAnalysis.Suggestion>();
            int space = code.indexOf(32);
            if (space == -1) {
                result.addAll(KEYWORD_COMPLETION_PROVIDER.completionSuggestions(code, cursor, anchor));
            }
            result.addAll(this.FILE_COMPLETION_PROVIDER.completionSuggestions(code.substring(space + 1), cursor - space - 1, anchor));
            anchor[0] = anchor[0] + (space + 1);
            return result;
        };
    }

    private static CompletionProvider reloadCompletion() {
        return (code, cursor, anchor) -> {
            ArrayList<SourceCodeAnalysis.Suggestion> result = new ArrayList<SourceCodeAnalysis.Suggestion>();
            int pastSpace = code.indexOf(32) + 1;
            result.addAll(RELOAD_OPTIONS_COMPLETION_PROVIDER.completionSuggestions(code.substring(pastSpace), cursor - pastSpace, anchor));
            anchor[0] = anchor[0] + pastSpace;
            return result;
        };
    }

    private static CompletionProvider orMostSpecificCompletion(CompletionProvider left, CompletionProvider right) {
        return (code, cursor, anchor) -> {
            int[] leftAnchor = new int[]{-1};
            int[] rightAnchor = new int[]{-1};
            List<SourceCodeAnalysis.Suggestion> leftSuggestions = left.completionSuggestions(code, cursor, leftAnchor);
            List<SourceCodeAnalysis.Suggestion> rightSuggestions = right.completionSuggestions(code, cursor, rightAnchor);
            ArrayList<SourceCodeAnalysis.Suggestion> suggestions = new ArrayList<SourceCodeAnalysis.Suggestion>();
            if (leftAnchor[0] >= rightAnchor[0]) {
                anchor[0] = leftAnchor[0];
                suggestions.addAll(leftSuggestions);
            }
            if (leftAnchor[0] <= rightAnchor[0]) {
                anchor[0] = rightAnchor[0];
                suggestions.addAll(rightSuggestions);
            }
            return suggestions;
        };
    }

    Stream<Snippet> allSnippets() {
        return this.state.snippets();
    }

    Stream<Snippet> dropableSnippets() {
        return this.state.snippets().filter(sn -> this.state.status((Snippet)sn).isActive());
    }

    Stream<VarSnippet> allVarSnippets() {
        return this.state.snippets().filter(sn -> sn.kind() == Snippet.Kind.VAR).map(sn -> (VarSnippet)sn);
    }

    Stream<MethodSnippet> allMethodSnippets() {
        return this.state.snippets().filter(sn -> sn.kind() == Snippet.Kind.METHOD).map(sn -> (MethodSnippet)sn);
    }

    Stream<TypeDeclSnippet> allTypeSnippets() {
        return this.state.snippets().filter(sn -> sn.kind() == Snippet.Kind.TYPE_DECL).map(sn -> (TypeDeclSnippet)sn);
    }

    private static <K, V> Map<K, V> Mapof(Object ... arr) {
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        for (int i = 0; i < arr.length; ++i) {
            Object k = arr[i];
            if (++i >= arr.length) break;
            Object v = arr[i];
            m.put(k, v);
        }
        return m;
    }

    public List<SourceCodeAnalysis.Suggestion> commandCompletionSuggestions(String code, int cursor, int[] anchor) {
        return this.commandCompletions.completionSuggestions(code, cursor, anchor);
    }

    public String commandDocumentation(String code, int cursor, boolean shortDescription) {
        int space = (code = code.substring(0, cursor)).indexOf(32);
        if (space != -1) {
            String cmd = code.substring(0, space);
            Command command = this.commands.get(cmd);
            if (command == null) {
                return null;
            }
            if (command != null) {
                return this.getResourceString(command.helpKey + (shortDescription ? ".summary" : ""));
            }
        }
        return null;
    }

    final boolean cmdSet(String arg) {
        String cmd = "/set";
        ArgTokenizer at = new ArgTokenizer(cmd, arg.trim());
        String which = this.subCommand(cmd, at, SET_SUBCOMMANDS);
        if (which == null) {
            return false;
        }
        switch (which) {
            case "_retain": {
                this.errormsg("jshell.err.setting.to.retain.must.be.specified", at.whole());
                return false;
            }
            case "_blank": {
                new SetEditor().set();
                this.showSetStart();
                this.setFeedback(this, at);
                this.hardmsg("jshell.msg.set.show.mode.settings", new Object[0]);
                return true;
            }
            case "format": {
                return this.feedback.setFormat(this, at);
            }
            case "truncation": {
                return this.feedback.setTruncation(this, at);
            }
            case "feedback": {
                return this.setFeedback(this, at);
            }
            case "mode": {
                return this.feedback.setMode(this, at, retained -> this.prefs.put(MODE_KEY, (String)retained));
            }
            case "prompt": {
                if (!this.permitSystemSettings) break;
                return this.feedback.setPrompt(this, at);
            }
            case "start": {
                return this.setStart(at);
            }
        }
        this.errormsg("jshell.err.arg", cmd, at.val());
        return false;
    }

    boolean setFeedback(MessageHandler messageHandler, ArgTokenizer at) {
        return this.feedback.setFeedback(messageHandler, at, fb -> this.prefs.put(FEEDBACK_KEY, (String)fb));
    }

    String subCommand(String cmd, ArgTokenizer at, String[] subs) {
        at.allowedOptions("-retain");
        String sub = at.next();
        if (sub == null) {
            return at.hasOption("-retain") ? "_retain" : "_blank";
        }
        String[] matches = (String[])Arrays.stream(subs).filter(s -> s.startsWith(sub)).toArray(String[]::new);
        if (matches.length == 0) {
            this.errormsg("jshell.err.arg", cmd, sub);
            this.fluffmsg("jshell.msg.use.one.of", Arrays.stream(subs).collect(Collectors.joining(", ")));
            return null;
        }
        if (matches.length > 1) {
            this.errormsg("jshell.err.sub.ambiguous", cmd, sub);
            this.fluffmsg("jshell.msg.use.one.of", Arrays.stream(matches).collect(Collectors.joining(", ")));
            return null;
        }
        return matches[0];
    }

    boolean setStart(ArgTokenizer at) {
        boolean hasFile;
        at.allowedOptions("-default", "-none", "-retain");
        String fn = at.next();
        if (!this.checkOptionsAndRemainingInput(at)) {
            return false;
        }
        boolean defaultOption = at.hasOption("-default");
        boolean noneOption = at.hasOption("-none");
        boolean retainOption = at.hasOption("-retain");
        int argCount = (defaultOption ? 1 : 0) + (noneOption ? 1 : 0) + ((hasFile = fn != null) ? 1 : 0);
        if (argCount > 1) {
            this.errormsg("jshell.err.option.or.filename", at.whole());
            return false;
        }
        if (argCount == 0 && !retainOption) {
            this.showSetStart();
            return true;
        }
        if (hasFile) {
            String init = this.readFile(fn, "/set start");
            if (init == null) {
                return false;
            }
            this.startup = init;
        } else if (defaultOption) {
            this.startup = DEFAULT_STARTUP;
        } else if (noneOption) {
            this.startup = "";
        }
        if (retainOption) {
            this.prefs.put(STARTUP_KEY, this.startup);
        }
        return true;
    }

    void showSetStart() {
        String retained = this.prefs.get(STARTUP_KEY, null);
        if (retained != null) {
            this.showSetStart(true, retained);
        }
        if (retained == null || !this.startup.equals(retained)) {
            this.showSetStart(false, this.startup);
        }
    }

    void showSetStart(boolean isRetained, String start) {
        String cmd = "/set start" + (isRetained ? " -retain " : " ");
        String stset = start.equals(DEFAULT_STARTUP) ? cmd + "-default" : (start.isEmpty() ? cmd + "-none" : this.prefix("startup.jsh:\n" + start + "\n" + cmd + "startup.jsh", ""));
        this.hard(stset, new Object[0]);
    }

    boolean cmdClasspath(String arg) {
        if (arg.isEmpty()) {
            this.errormsg("jshell.err.classpath.arg", new Object[0]);
            return false;
        }
        String s = this.toPathResolvingUserHome(arg).toString();
        this.state.addToClasspath(s);
        this.classpathAdded(s);
        this.fluffmsg("jshell.msg.classpath", arg);
        return true;
    }

    protected void classpathAdded(String s) {
    }

    boolean cmdDebug(String arg) {
        if (arg.isEmpty()) {
            this.debug = !this.debug;
            InternalDebugControl.setDebugFlags(this.state, this.debug ? 1 : 0);
            this.fluff("Debugging %s", this.debug ? "on" : "off");
        } else {
            int flags = 0;
            block9: for (char ch : arg.toCharArray()) {
                switch (ch) {
                    case '0': {
                        flags = 0;
                        this.debug = false;
                        this.fluff("Debugging off", new Object[0]);
                        continue block9;
                    }
                    case 'r': {
                        this.debug = true;
                        this.fluff("REPL tool debugging on", new Object[0]);
                        continue block9;
                    }
                    case 'g': {
                        flags |= 1;
                        this.fluff("General debugging on", new Object[0]);
                        continue block9;
                    }
                    case 'f': {
                        flags |= 2;
                        this.fluff("File manager debugging on", new Object[0]);
                        continue block9;
                    }
                    case 'c': {
                        flags |= 4;
                        this.fluff("Completion analysis debugging on", new Object[0]);
                        continue block9;
                    }
                    case 'd': {
                        flags |= 8;
                        this.fluff("Dependency debugging on", new Object[0]);
                        continue block9;
                    }
                    case 'e': {
                        flags |= 0x10;
                        this.fluff("Event debugging on", new Object[0]);
                        continue block9;
                    }
                    default: {
                        this.hard("Unknown debugging option: %c", Character.valueOf(ch));
                        this.fluff("Use: 0 r g f c d", new Object[0]);
                        return false;
                    }
                }
            }
            InternalDebugControl.setDebugFlags(this.state, flags);
        }
        return true;
    }

    private boolean cmdExit() {
        this.regenerateOnDeath = false;
        this.live = false;
        if (!this.replayableHistory.isEmpty()) {
            int sepLen = RECORD_SEPARATOR.length();
            int first = this.replayableHistory.size();
            for (int length = 0; length < 8192 && --first >= 0; length += this.replayableHistory.get(first).length() + sepLen) {
            }
            String hist = String.join((CharSequence)RECORD_SEPARATOR, this.replayableHistory.subList(first + 1, this.replayableHistory.size()));
            this.prefs.put(REPLAY_RESTORE_KEY, hist);
        }
        this.fluffmsg("jshell.msg.goodbye", new Object[0]);
        return true;
    }

    boolean cmdHelp(String arg) {
        ArgTokenizer at = new ArgTokenizer("/help", arg);
        String subject = at.next();
        if (subject != null) {
            String cmd2;
            Command[] matches = (Command[])this.commands.values().stream().filter(c -> c.command.startsWith(subject)).toArray(Command[]::new);
            if (matches.length == 1 && (cmd2 = matches[0].command).equals("/set")) {
                String which = this.subCommand(cmd2, at, SET_SUBCOMMANDS);
                if (which == null) {
                    return false;
                }
                if (!which.equals("_blank")) {
                    this.hardrb("help.set." + which);
                    return true;
                }
            }
            if (matches.length > 0) {
                for (Command c2 : matches) {
                    this.hard("", new Object[0]);
                    this.hard("%s", c2.command);
                    this.hard("", new Object[0]);
                    this.hardrb(c2.helpKey);
                }
                return true;
            }
            this.errormsg("jshell.err.help.arg", arg);
        }
        this.hardmsg("jshell.msg.help.begin", new Object[0]);
        this.hardPairs(this.commands.values().stream().filter(cmd -> cmd.kind.showInHelp), cmd -> cmd.command + " " + this.getResourceString(cmd.helpKey + ".args"), cmd -> this.getResourceString(cmd.helpKey + ".summary"));
        this.hardmsg("jshell.msg.help.subject", new Object[0]);
        this.hardPairs(this.commands.values().stream().filter(cmd -> cmd.kind == CommandKind.HELP_SUBJECT), cmd -> cmd.command, cmd -> this.getResourceString(cmd.helpKey + ".summary"));
        return true;
    }

    private boolean cmdHistory() {
        this.cmdout.println();
        for (String s : this.input.currentSessionHistory()) {
            this.cmdout.printf("%s\n", s);
        }
        return true;
    }

    @SafeVarargs
    private static <T extends Snippet> Stream<T> nonEmptyStream(Supplier<Stream<T>> supplier, SnippetPredicate<T> ... filters) {
        for (SnippetPredicate<T> filt : filters) {
            Iterator iterator = supplier.get().filter(filt).iterator();
            if (!iterator.hasNext()) continue;
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
        }
        return null;
    }

    private boolean inStartUp(Snippet sn) {
        return this.mapSnippet.get((Object)sn).space == this.startNamespace;
    }

    private boolean isActive(Snippet sn) {
        return this.state.status(sn).isActive();
    }

    private boolean mainActive(Snippet sn) {
        return !this.inStartUp(sn) && this.isActive(sn);
    }

    private boolean matchingDeclaration(Snippet sn, String name) {
        return sn instanceof DeclarationSnippet && ((DeclarationSnippet)sn).name().equals(name);
    }

    private <T extends Snippet> Stream<T> argsOptionsToSnippets(Supplier<Stream<T>> snippetSupplier, Predicate<Snippet> defFilter, String rawargs, String cmd) {
        String s;
        ArgTokenizer at = new ArgTokenizer(cmd, rawargs.trim());
        at.allowedOptions("-all", "-start");
        ArrayList<String> args = new ArrayList<String>();
        while ((s = at.next()) != null) {
            args.add(s);
        }
        if (!this.checkOptionsAndRemainingInput(at)) {
            return null;
        }
        if (at.optionCount() > 0 && args.size() > 0) {
            this.errormsg("jshell.err.may.not.specify.options.and.snippets", at.whole());
            return null;
        }
        if (at.optionCount() > 1) {
            this.errormsg("jshell.err.conflicting.options", at.whole());
            return null;
        }
        if (at.hasOption("-all")) {
            return snippetSupplier.get();
        }
        if (at.hasOption("-start")) {
            return snippetSupplier.get().filter(this::inStartUp);
        }
        if (args.isEmpty()) {
            return snippetSupplier.get().filter(defFilter);
        }
        return this.argsToSnippets(snippetSupplier, args);
    }

    private <T extends Snippet> Stream<T> argsToSnippets(Supplier<Stream<T>> snippetSupplier, List<String> args) {
        Stream<T> result = null;
        for (String arg : args) {
            Stream<T> st = this.layeredSnippetSearch(snippetSupplier, arg);
            if (st == null) {
                Stream<T> est = this.layeredSnippetSearch(this.state::snippets, arg);
                if (est == null) {
                    this.errormsg("jshell.err.no.such.snippets", arg);
                } else {
                    this.errormsg("jshell.err.the.snippet.cannot.be.used.with.this.command", arg, ((Snippet)est.findFirst().get()).source());
                }
                return null;
            }
            if (result == null) {
                result = st;
                continue;
            }
            result = Stream.concat(result, st);
        }
        return result;
    }

    private <T extends Snippet> Stream<T> layeredSnippetSearch(Supplier<Stream<T>> snippetSupplier, String arg) {
        return JShellTool.nonEmptyStream(snippetSupplier, sn -> this.isActive((Snippet)sn) && this.matchingDeclaration((Snippet)sn, arg), sn -> this.matchingDeclaration((Snippet)sn, arg), sn -> sn.id().equals(arg));
    }

    private boolean cmdDrop(String rawargs) {
        String s;
        ArgTokenizer at = new ArgTokenizer("/drop", rawargs.trim());
        at.allowedOptions(new String[0]);
        ArrayList<String> args = new ArrayList<String>();
        while ((s = at.next()) != null) {
            args.add(s);
        }
        if (!this.checkOptionsAndRemainingInput(at)) {
            return false;
        }
        if (args.isEmpty()) {
            this.errormsg("jshell.err.drop.arg", new Object[0]);
            return false;
        }
        Stream stream = this.argsToSnippets(this::dropableSnippets, args);
        if (stream == null) {
            this.fluffmsg("jshell.msg.see.classes.etc", new Object[0]);
            return false;
        }
        List snippets = stream.collect(Collectors.toList());
        if (snippets.size() > args.size()) {
            this.errormsg("jshell.err.drop.ambiguous", new Object[0]);
            this.fluffmsg("jshell.msg.use.one.of", snippets.stream().map(sn -> String.format("\n/drop %-5s :   %s", sn.id(), sn.source().replace("\n", "\n       "))).collect(Collectors.joining(", ")));
            return false;
        }
        snippets.stream().forEach(sn -> this.state.drop((Snippet)sn).forEach(this::handleEvent));
        return true;
    }

    private boolean cmdEdit(String arg) {
        Stream<Snippet> stream = this.argsOptionsToSnippets(this.state::snippets, this::mainActive, arg, "/edit");
        if (stream == null) {
            return false;
        }
        LinkedHashSet<String> srcSet = new LinkedHashSet<String>();
        stream.forEachOrdered(sn -> {
            String src = sn.source();
            switch (sn.subKind()) {
                case VAR_VALUE_SUBKIND: {
                    break;
                }
                case TEMP_VAR_EXPRESSION_SUBKIND: 
                case OTHER_EXPRESSION_SUBKIND: 
                case ASSIGNMENT_SUBKIND: {
                    if (!src.endsWith(";")) {
                        src = src + ";";
                    }
                    srcSet.add(src);
                    break;
                }
                default: {
                    srcSet.add(src);
                }
            }
        });
        StringBuilder sb = new StringBuilder();
        for (String s2 : srcSet) {
            sb.append(s2);
            sb.append('\n');
        }
        String src = sb.toString();
        SaveHandler saveHandler = new SaveHandler(src, srcSet);
        Consumer<String> errorHandler = s -> this.hard("Edit Error: %s", s);
        if (this.editor == BUILT_IN_EDITOR) {
            // empty if block
        }
        return true;
    }

    private boolean cmdList(String arg) {
        if (arg.length() >= 2 && "-history".startsWith(arg)) {
            return this.cmdHistory();
        }
        Stream<Snippet> stream = this.argsOptionsToSnippets(this.state::snippets, this::mainActive, arg, "/list");
        if (stream == null) {
            return false;
        }
        boolean[] hasOutput = new boolean[1];
        stream.forEachOrdered(sn -> {
            if (!hasOutput[0]) {
                this.cmdout.println();
                hasOutput[0] = true;
            }
            this.cmdout.printf("%4s : %s\n", sn.id(), sn.source().replace("\n", "\n       "));
        });
        return true;
    }

    private boolean cmdOpen(String filename) {
        return this.runFile(filename, "/open");
    }

    private boolean runFile(String filename, String context) {
        if (!filename.isEmpty()) {
            try {
                this.run(new FileScannerIOContext(this.toPathResolvingUserHome(filename).toString()));
                return true;
            }
            catch (FileNotFoundException e) {
                this.errormsg("jshell.err.file.not.found", context, filename, e.getMessage());
            }
            catch (Exception e) {
                this.errormsg("jshell.err.file.exception", context, filename, e);
            }
        } else {
            this.errormsg("jshell.err.file.filename", context);
        }
        return false;
    }

    String readFile(String filename, String context) {
        if (filename != null) {
            try {
                byte[] encoded = Files.readAllBytes(Paths.get(filename, new String[0]));
                return new String(encoded);
            }
            catch (AccessDeniedException e) {
                this.errormsg("jshell.err.file.not.accessible", context, filename, e.getMessage());
            }
            catch (NoSuchFileException e) {
                this.errormsg("jshell.err.file.not.found", context, filename);
            }
            catch (Exception e) {
                this.errormsg("jshell.err.file.exception", context, filename, e);
            }
        } else {
            this.errormsg("jshell.err.file.filename", context);
        }
        return null;
    }

    private boolean cmdReset() {
        this.live = false;
        this.closeState();
        this.fluffmsg("jshell.msg.resetting.state", new Object[0]);
        return true;
    }

    private boolean cmdReload(String rawargs) {
        List<String> history;
        ArgTokenizer at = new ArgTokenizer("/reload", rawargs.trim());
        at.allowedOptions("-restore", "-quiet");
        if (!this.checkOptionsAndRemainingInput(at)) {
            return false;
        }
        if (at.hasOption("-restore")) {
            if (this.replayableHistoryPrevious == null) {
                this.errormsg("jshell.err.reload.no.previous", new Object[0]);
                return false;
            }
            history = this.replayableHistoryPrevious;
            this.fluffmsg("jshell.err.reload.restarting.previous.state", new Object[0]);
        } else {
            history = this.replayableHistory;
            this.fluffmsg("jshell.err.reload.restarting.state", new Object[0]);
        }
        boolean echo = !at.hasOption("-quiet");
        this.resetState();
        this.run(new ReloadIOContext(history, echo ? this.cmdout : null));
        return true;
    }

    private boolean cmdSave(String rawargs) {
        ArgTokenizer at = new ArgTokenizer("/save", rawargs.trim());
        at.allowedOptions("-all", "-start", "-history");
        String filename = at.next();
        if (filename == null) {
            this.errormsg("jshell.err.file.filename", "/save");
            return false;
        }
        if (!this.checkOptionsAndRemainingInput(at)) {
            return false;
        }
        if (at.optionCount() > 1) {
            this.errormsg("jshell.err.conflicting.options", at.whole());
            return false;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.toPathResolvingUserHome(filename), Charset.defaultCharset(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
            if (at.hasOption("-history")) {
                for (String s : this.input.currentSessionHistory()) {
                    writer.write(s);
                    writer.write("\n");
                }
            } else if (at.hasOption("-start")) {
                writer.append(this.startup);
            } else {
                String sources = (at.hasOption("-all") ? this.state.snippets() : this.state.snippets().filter(this::mainActive)).map(Snippet::source).collect(Collectors.joining("\n"));
                writer.write(sources);
            }
        }
        catch (FileNotFoundException e) {
            this.errormsg("jshell.err.file.not.found", "/save", filename, e.getMessage());
            return false;
        }
        catch (Exception e) {
            this.errormsg("jshell.err.file.exception", "/save", filename, e);
            return false;
        }
        return true;
    }

    private boolean cmdVars(String arg) {
        Stream<VarSnippet> stream = this.argsOptionsToSnippets(this::allVarSnippets, this::isActive, arg, "/vars");
        if (stream == null) {
            return false;
        }
        stream.forEachOrdered(vk -> {
            String val = this.state.status((Snippet)vk) == Snippet.Status.VALID ? this.state.varValue((VarSnippet)vk) : this.getResourceString("jshell.msg.vars.not.active");
            this.hard("  %s %s = %s", vk.typeName(), vk.name(), val);
        });
        return true;
    }

    private boolean cmdMethods(String arg) {
        Stream<MethodSnippet> stream = this.argsOptionsToSnippets(this::allMethodSnippets, this::isActive, arg, "/methods");
        if (stream == null) {
            return false;
        }
        stream.forEachOrdered(mk -> this.hard("  %s %s", mk.name(), mk.signature()));
        return true;
    }

    private boolean cmdTypes(String arg) {
        Stream<TypeDeclSnippet> stream = this.argsOptionsToSnippets(this::allTypeSnippets, this::isActive, arg, "/types");
        if (stream == null) {
            return false;
        }
        stream.forEachOrdered(ck -> {
            String kind;
            switch (ck.subKind()) {
                case INTERFACE_SUBKIND: {
                    kind = "interface";
                    break;
                }
                case CLASS_SUBKIND: {
                    kind = "class";
                    break;
                }
                case ENUM_SUBKIND: {
                    kind = "enum";
                    break;
                }
                case ANNOTATION_TYPE_SUBKIND: {
                    kind = "@interface";
                    break;
                }
                default: {
                    assert (false) : "Wrong kind" + (Object)((Object)ck.subKind());
                    kind = "class";
                }
            }
            this.hard("  %s %s", kind, ck.name());
        });
        return true;
    }

    private boolean cmdImports() {
        this.state.imports().forEach(ik -> this.hard("  import %s%s", ik.isStatic() ? "static " : "", ik.fullname()));
        return true;
    }

    private boolean cmdUseHistoryEntry(int index) {
        List keys = this.state.snippets().collect(Collectors.toList());
        index = index < 0 ? (index += keys.size()) : --index;
        if (index < 0 || index >= keys.size()) {
            this.errormsg("jshell.err.out.of.range", new Object[0]);
            return false;
        }
        this.rerunSnippet((Snippet)keys.get(index));
        return true;
    }

    boolean checkOptionsAndRemainingInput(ArgTokenizer at) {
        String junk = at.remainder();
        if (!junk.isEmpty()) {
            this.errormsg("jshell.err.unexpected.at.end", junk, at.whole());
            return false;
        }
        String bad = at.badOptions();
        if (!bad.isEmpty()) {
            this.errormsg("jshell.err.unknown.option", bad, at.whole());
            return false;
        }
        return true;
    }

    private boolean rerunHistoryEntryById(String id) {
        Optional<Snippet> snippet = this.state.snippets().filter(s -> s.id().equals(id)).findFirst();
        return snippet.map(s -> {
            this.rerunSnippet((Snippet)s);
            return true;
        }).orElse(false);
    }

    private void rerunSnippet(Snippet snippet) {
        String source = snippet.source();
        this.cmdout.printf("%s\n", source);
        this.input.replaceLastHistoryEntry(source);
        this.processSourceCatchingReset(source);
    }

    List<Diag> errorsOnly(List<Diag> diagnostics) {
        return diagnostics.stream().filter(d -> d.isError()).collect(Collectors.toList());
    }

    void displayDiagnostics(String source, Diag diag, List<String> toDisplay) {
        for (String line : diag.getMessage(null).split("\\r?\\n")) {
            if (line.trim().startsWith("location:")) continue;
            toDisplay.add(line);
        }
        int pstart = (int)diag.getStartPosition();
        int pend = (int)diag.getEndPosition();
        Matcher m = LINEBREAK.matcher(source);
        int pstartl = 0;
        int pendl = -2;
        while (m.find(pstartl) && (pendl = m.start()) < pstart) {
            pstartl = m.end();
        }
        if (pendl < pstart) {
            pendl = source.length();
        }
        toDisplay.add(source.substring(pstartl, pendl));
        StringBuilder sb = new StringBuilder();
        int start = pstart - pstartl;
        for (int i = 0; i < start; ++i) {
            sb.append(' ');
        }
        sb.append('^');
        boolean multiline = pend > pendl;
        int end = (multiline ? pendl : pend) - pstartl - 1;
        if (end > start) {
            for (int i = start + 1; i < end; ++i) {
                sb.append('-');
            }
            if (multiline) {
                sb.append("-...");
            } else {
                sb.append('^');
            }
        }
        toDisplay.add(sb.toString());
        this.debug("printDiagnostics start-pos = %d ==> %d -- wrap = %s", diag.getStartPosition(), start, this);
        this.debug("Code: %s", diag.getCode());
        this.debug("Pos: %d (%d - %d)", diag.getPosition(), diag.getStartPosition(), diag.getEndPosition());
    }

    private String processSource(String srcInput) throws IllegalStateException {
        SourceCodeAnalysis.CompletionInfo an;
        while ((an = this.analysis.analyzeCompletion(srcInput)).completeness().isComplete()) {
            boolean failed = this.processCompleteSource(an.source());
            if (failed || an.remaining().isEmpty()) {
                return "";
            }
            srcInput = an.remaining();
        }
        return an.remaining();
    }

    private boolean processCompleteSource(String source) throws IllegalStateException {
        this.debug("Compiling: %s", source);
        boolean failed = false;
        boolean isActive = false;
        List<SnippetEvent> events = this.state.eval(source);
        for (SnippetEvent e : events) {
            failed |= this.handleEvent(e);
            isActive |= e.causeSnippet() == null && e.status().isActive() && e.snippet().subKind() != Snippet.SubKind.VAR_VALUE_SUBKIND;
        }
        if (isActive && this.live) {
            this.addToReplayHistory(source);
        }
        return failed;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean handleEvent(SnippetEvent ste) {
        Snippet sn = ste.snippet();
        if (sn == null) {
            this.debug("Event with null key: %s", ste);
            return false;
        }
        List<Diag> diagnostics = this.state.diagnostics(sn).collect(Collectors.toList());
        String source = sn.source();
        if (ste.causeSnippet() != null) {
            if (!(sn instanceof DeclarationSnippet)) return false;
            List<Diag> other = this.errorsOnly(diagnostics);
            new DisplayEvent(ste, true, ste.value(), other).displayDeclarationAndValue();
            return false;
        }
        for (Diag d : diagnostics) {
            this.hardmsg(d.isError() ? "jshell.msg.error" : "jshell.msg.warning", new Object[0]);
            ArrayList<String> disp = new ArrayList<String>();
            this.displayDiagnostics(source, d, disp);
            disp.stream().forEach(l -> this.hard("%s", l));
        }
        if (ste.status() == Snippet.Status.REJECTED) {
            if (!diagnostics.isEmpty()) return true;
            this.errormsg("jshell.err.failed", new Object[0]);
            return true;
        }
        if (ste.exception() == null) {
            new DisplayEvent(ste, false, ste.value(), diagnostics).displayDeclarationAndValue();
            return false;
        }
        if (ste.exception() instanceof EvalException) {
            this.printEvalException((EvalException)ste.exception());
            return true;
        }
        if (ste.exception() instanceof UnresolvedReferenceException) {
            this.printUnresolvedException((UnresolvedReferenceException)ste.exception());
            return false;
        }
        this.hard("Unexpected execution exception: %s", ste.exception());
        return true;
    }

    void printStackTrace(StackTraceElement[] stes) {
        for (StackTraceElement ste : stes) {
            StringBuilder sb = new StringBuilder();
            String cn = ste.getClassName();
            if (!cn.isEmpty()) {
                int dot = cn.lastIndexOf(46);
                if (dot > 0) {
                    sb.append(cn.substring(dot + 1));
                } else {
                    sb.append(cn);
                }
                sb.append(".");
            }
            if (!ste.getMethodName().isEmpty()) {
                sb.append(ste.getMethodName());
                sb.append(" ");
            }
            String fileName = ste.getFileName();
            int lineNumber = ste.getLineNumber();
            String loc = ste.isNativeMethod() ? this.getResourceString("jshell.msg.native.method") : (fileName == null ? this.getResourceString("jshell.msg.unknown.source") : (lineNumber >= 0 ? fileName + ":" + lineNumber : fileName));
            this.hard("      at %s(%s)", sb, loc);
        }
    }

    void printUnresolvedException(UnresolvedReferenceException ex) {
        DeclarationSnippet corralled = ex.getSnippet();
        List<Diag> otherErrors = this.errorsOnly(this.state.diagnostics(corralled).collect(Collectors.toList()));
        new DisplayEvent(corralled, this.state.status(corralled), Feedback.FormatAction.USED, true, null, otherErrors).displayDeclarationAndValue();
    }

    void printEvalException(EvalException ex) {
        if (ex.getMessage() == null) {
            this.hard("%s thrown", ex.getExceptionClassName());
        } else {
            this.hard("%s thrown: %s", ex.getExceptionClassName(), ex.getMessage());
        }
        this.printStackTrace(ex.getStackTrace());
    }

    private Feedback.FormatAction toAction(Snippet.Status status, Snippet.Status previousStatus, boolean isSignatureChange) {
        Feedback.FormatAction act;
        switch (status) {
            case VALID: 
            case RECOVERABLE_DEFINED: 
            case RECOVERABLE_NOT_DEFINED: {
                if (previousStatus.isActive()) {
                    act = isSignatureChange ? Feedback.FormatAction.REPLACED : Feedback.FormatAction.MODIFIED;
                    break;
                }
                act = Feedback.FormatAction.ADDED;
                break;
            }
            case OVERWRITTEN: {
                act = Feedback.FormatAction.OVERWROTE;
                break;
            }
            case DROPPED: {
                act = Feedback.FormatAction.DROPPED;
                break;
            }
            default: {
                this.error("Unexpected status: " + previousStatus.toString() + "=>" + status.toString(), new Object[0]);
                act = Feedback.FormatAction.DROPPED;
            }
        }
        return act;
    }

    String version() {
        return this.version("release");
    }

    private String version(String key) {
        if (this.versionRB == null) {
            try {
                this.versionRB = ResourceBundle.getBundle(VERSION_RB_NAME, this.locale);
            }
            catch (MissingResourceException e) {
                return "(version info not available)";
            }
        }
        try {
            return this.versionRB.getString(key);
        }
        catch (MissingResourceException e) {
            return "(version info not available)";
        }
    }

    protected boolean isLive() {
        return this.live;
    }

    protected final Feedback feedback() {
        return this.feedback;
    }

    static class ArgSuggestion
    implements SourceCodeAnalysis.Suggestion {
        private final String continuation;

        public ArgSuggestion(String continuation) {
            this.continuation = continuation;
        }

        @Override
        public String continuation() {
            return this.continuation;
        }

        @Override
        public boolean matchesType() {
            return false;
        }
    }

    static class SnippetInfo {
        final Snippet snippet;
        final NameSpace space;
        final String tid;

        SnippetInfo(Snippet snippet, NameSpace space, String tid) {
            this.snippet = snippet;
            this.space = space;
            this.tid = tid;
        }
    }

    class NameSpace {
        final String spaceName;
        final String prefix;
        private int nextNum;

        NameSpace(String spaceName, String prefix) {
            this.spaceName = spaceName;
            this.prefix = prefix;
            this.nextNum = 1;
        }

        String tid(Snippet sn) {
            String tid = this.prefix + this.nextNum++;
            JShellTool.this.mapSnippet.put(sn, new SnippetInfo(sn, this, tid));
            return tid;
        }

        String tidNext() {
            return this.prefix + this.nextNum;
        }
    }

    class DisplayEvent {
        private final Snippet sn;
        private final Feedback.FormatAction action;
        private final boolean update;
        private final String value;
        private final List<String> errorLines;
        private final Feedback.FormatResolve resolution;
        private final String unresolved;
        private final Feedback.FormatUnresolved unrcnt;
        private final Feedback.FormatErrors errcnt;

        DisplayEvent(SnippetEvent ste, boolean update, String value, List<Diag> errors) {
            this(ste.snippet(), ste.status(), this$0.toAction(ste.status(), ste.previousStatus(), ste.isSignatureChange()), update, value, errors);
        }

        DisplayEvent(Snippet sn, Snippet.Status status, Feedback.FormatAction action, boolean update, String value, List<Diag> errors) {
            long unresolvedCount;
            this.sn = sn;
            this.action = action;
            this.update = update;
            this.value = value;
            this.errorLines = new ArrayList<String>();
            for (Diag d : errors) {
                JShellTool.this.displayDiagnostics(sn.source(), d, this.errorLines);
            }
            if (sn instanceof DeclarationSnippet && (status == Snippet.Status.RECOVERABLE_DEFINED || status == Snippet.Status.RECOVERABLE_NOT_DEFINED)) {
                this.resolution = status == Snippet.Status.RECOVERABLE_NOT_DEFINED ? Feedback.FormatResolve.NOTDEFINED : Feedback.FormatResolve.DEFINED;
                this.unresolved = this.unresolved((DeclarationSnippet)sn);
                unresolvedCount = JShellTool.this.state.unresolvedDependencies((DeclarationSnippet)sn).count();
            } else {
                this.resolution = Feedback.FormatResolve.OK;
                this.unresolved = "";
                unresolvedCount = 0L;
            }
            Feedback.FormatUnresolved formatUnresolved = unresolvedCount == 0L ? Feedback.FormatUnresolved.UNRESOLVED0 : (this.unrcnt = unresolvedCount == 1L ? Feedback.FormatUnresolved.UNRESOLVED1 : Feedback.FormatUnresolved.UNRESOLVED2);
            this.errcnt = errors.isEmpty() ? Feedback.FormatErrors.ERROR0 : (errors.size() == 1 ? Feedback.FormatErrors.ERROR1 : Feedback.FormatErrors.ERROR2);
        }

        private String unresolved(DeclarationSnippet key) {
            List unr = JShellTool.this.state.unresolvedDependencies(key).collect(Collectors.toList());
            StringBuilder sb = new StringBuilder();
            int fromLast = unr.size();
            if (fromLast > 0) {
                sb.append(" ");
            }
            block4: for (String u : unr) {
                sb.append(u);
                switch (--fromLast) {
                    case 0: {
                        continue block4;
                    }
                    case 1: {
                        sb.append(", and ");
                        continue block4;
                    }
                }
                sb.append(", ");
            }
            return sb.toString();
        }

        private void custom(Feedback.FormatCase fcase, String name) {
            this.custom(fcase, name, null);
        }

        private void custom(Feedback.FormatCase fcase, String name, String type) {
            String display = JShellTool.this.feedback.format(fcase, this.action, this.update ? Feedback.FormatWhen.UPDATE : Feedback.FormatWhen.PRIMARY, this.resolution, this.unrcnt, this.errcnt, name, type, this.value, this.unresolved, this.errorLines);
            if (JShellTool.this.interactive()) {
                JShellTool.this.cmdout.print(display);
            }
        }

        private void displayDeclarationAndValue() {
            switch (this.sn.subKind()) {
                case CLASS_SUBKIND: {
                    this.custom(Feedback.FormatCase.CLASS, ((TypeDeclSnippet)this.sn).name());
                    break;
                }
                case INTERFACE_SUBKIND: {
                    this.custom(Feedback.FormatCase.INTERFACE, ((TypeDeclSnippet)this.sn).name());
                    break;
                }
                case ENUM_SUBKIND: {
                    this.custom(Feedback.FormatCase.ENUM, ((TypeDeclSnippet)this.sn).name());
                    break;
                }
                case ANNOTATION_TYPE_SUBKIND: {
                    this.custom(Feedback.FormatCase.ANNOTATION, ((TypeDeclSnippet)this.sn).name());
                    break;
                }
                case METHOD_SUBKIND: {
                    this.custom(Feedback.FormatCase.METHOD, ((MethodSnippet)this.sn).name(), ((MethodSnippet)this.sn).parameterTypes());
                    break;
                }
                case VAR_DECLARATION_SUBKIND: {
                    VarSnippet vk = (VarSnippet)this.sn;
                    this.custom(Feedback.FormatCase.VARDECL, vk.name(), vk.typeName());
                    break;
                }
                case VAR_DECLARATION_WITH_INITIALIZER_SUBKIND: {
                    VarSnippet vk = (VarSnippet)this.sn;
                    this.custom(Feedback.FormatCase.VARINIT, vk.name(), vk.typeName());
                    break;
                }
                case TEMP_VAR_EXPRESSION_SUBKIND: {
                    VarSnippet vk = (VarSnippet)this.sn;
                    this.custom(Feedback.FormatCase.EXPRESSION, vk.name(), vk.typeName());
                    break;
                }
                case OTHER_EXPRESSION_SUBKIND: {
                    JShellTool.this.error("Unexpected expression form -- value is: %s", this.value);
                    break;
                }
                case VAR_VALUE_SUBKIND: {
                    ExpressionSnippet ek = (ExpressionSnippet)this.sn;
                    this.custom(Feedback.FormatCase.VARVALUE, ek.name(), ek.typeName());
                    break;
                }
                case ASSIGNMENT_SUBKIND: {
                    ExpressionSnippet ek = (ExpressionSnippet)this.sn;
                    this.custom(Feedback.FormatCase.ASSIGNMENT, ek.name(), ek.typeName());
                    break;
                }
                case SINGLE_TYPE_IMPORT_SUBKIND: 
                case TYPE_IMPORT_ON_DEMAND_SUBKIND: 
                case SINGLE_STATIC_IMPORT_SUBKIND: 
                case STATIC_IMPORT_ON_DEMAND_SUBKIND: {
                    this.custom(Feedback.FormatCase.IMPORT, ((ImportSnippet)this.sn).name());
                    break;
                }
                case STATEMENT_SUBKIND: {
                    this.custom(Feedback.FormatCase.STATEMENT, null);
                }
            }
        }
    }

    private class SaveHandler
    implements Consumer<String> {
        String src;
        Set<String> currSrcs;

        SaveHandler(String src, Set<String> ss) {
            this.src = src;
            this.currSrcs = ss;
        }

        @Override
        public void accept(String s) {
            if (!s.equals(this.src)) {
                this.src = s;
                try {
                    SourceCodeAnalysis.CompletionInfo an;
                    LinkedHashSet<String> nextSrcs = new LinkedHashSet<String>();
                    boolean failed = false;
                    while ((an = JShellTool.this.analysis.analyzeCompletion(s)).completeness().isComplete()) {
                        String tsrc = this.trimNewlines(an.source());
                        if (!failed && !this.currSrcs.contains(tsrc)) {
                            failed = JShellTool.this.processCompleteSource(tsrc);
                        }
                        nextSrcs.add(tsrc);
                        if (an.remaining().isEmpty()) break;
                        s = an.remaining();
                    }
                    this.currSrcs = nextSrcs;
                }
                catch (IllegalStateException ex) {
                    JShellTool.this.hardmsg("jshell.msg.resetting", new Object[0]);
                    JShellTool.this.resetState();
                    this.currSrcs = new LinkedHashSet<String>();
                }
            }
        }

        private String trimNewlines(String s) {
            int e;
            int b;
            for (b = 0; b < s.length() && s.charAt(b) == '\n'; ++b) {
            }
            for (e = s.length() - 1; e >= 0 && s.charAt(e) == '\n'; --e) {
            }
            return s.substring(b, e + 1);
        }
    }

    private static interface SnippetPredicate<T extends Snippet>
    extends Predicate<T> {
    }

    class SetEditor {
        private final ArgTokenizer at;
        private final String[] command;
        private final boolean hasCommand;
        private final boolean defaultOption;
        private final boolean deleteOption;
        private final boolean waitOption;
        private final boolean retainOption;
        private final int primaryOptionCount;

        SetEditor(ArgTokenizer at) {
            at.allowedOptions("-default", "-wait", "-retain", "-delete");
            String prog = at.next();
            ArrayList<String> ed = new ArrayList<String>();
            while (at.val() != null) {
                ed.add(at.val());
                at.nextToken();
            }
            this.at = at;
            this.command = ed.toArray(new String[ed.size()]);
            this.hasCommand = this.command.length > 0;
            this.defaultOption = at.hasOption("-default");
            this.deleteOption = at.hasOption("-delete");
            this.waitOption = at.hasOption("-wait");
            this.retainOption = at.hasOption("-retain");
            this.primaryOptionCount = (this.hasCommand ? 1 : 0) + (this.defaultOption ? 1 : 0) + (this.deleteOption ? 1 : 0);
        }

        SetEditor() {
            this(new ArgTokenizer("", ""));
        }

        boolean set() {
            if (!this.check()) {
                return false;
            }
            if (this.primaryOptionCount == 0 && !this.retainOption) {
                EditorSetting retained = EditorSetting.fromPrefs(JShellTool.this.prefs);
                if (retained != null) {
                    JShellTool.this.hard("/set editor -retain %s", this.format(retained));
                }
                if (retained == null || !retained.equals(JShellTool.this.editor)) {
                    JShellTool.this.hard("/set editor %s", this.format(JShellTool.this.editor));
                }
                return true;
            }
            if (this.retainOption && this.deleteOption) {
                EditorSetting.removePrefs(JShellTool.this.prefs);
            }
            this.install();
            if (this.retainOption && !this.deleteOption) {
                JShellTool.this.editor.toPrefs(JShellTool.this.prefs);
                JShellTool.this.fluffmsg("jshell.msg.set.editor.retain", this.format(JShellTool.this.editor));
            }
            return true;
        }

        private boolean check() {
            if (!JShellTool.this.checkOptionsAndRemainingInput(this.at)) {
                return false;
            }
            if (this.primaryOptionCount > 1) {
                JShellTool.this.errormsg("jshell.err.default.option.or.program", this.at.whole());
                return false;
            }
            if (this.waitOption && !this.hasCommand) {
                JShellTool.this.errormsg("jshell.err.wait.applies.to.external.editor", this.at.whole());
                return false;
            }
            return true;
        }

        private void install() {
            if (this.hasCommand) {
                JShellTool.this.editor = new EditorSetting(this.command, this.waitOption);
            } else if (this.defaultOption) {
                JShellTool.this.editor = BUILT_IN_EDITOR;
            } else if (this.deleteOption) {
                JShellTool.this.configEditor();
            } else {
                return;
            }
            JShellTool.this.fluffmsg("jshell.msg.set.editor.set", this.format(JShellTool.this.editor));
        }

        private String format(EditorSetting ed) {
            if (ed == BUILT_IN_EDITOR) {
                return "-default";
            }
            Stream<String> elems = Arrays.stream(ed.cmd);
            if (ed.wait) {
                elems = Stream.concat(Stream.of("-wait"), elems);
            }
            return elems.collect(Collectors.joining(" "));
        }
    }

    static class EditorSetting {
        static String BUILT_IN_REP = "-default";
        static char WAIT_PREFIX = (char)45;
        static char NORMAL_PREFIX = (char)42;
        final String[] cmd;
        final boolean wait;

        EditorSetting(String[] cmd, boolean wait) {
            this.wait = wait;
            this.cmd = cmd;
        }

        static EditorSetting fromPrefs(Preferences prefs) {
            String editorString = prefs.get(JShellTool.EDITOR_KEY, "");
            if (editorString == null || editorString.isEmpty()) {
                return null;
            }
            if (editorString.equals(BUILT_IN_REP)) {
                return BUILT_IN_EDITOR;
            }
            boolean wait = false;
            char waitMarker = editorString.charAt(0);
            if (waitMarker == WAIT_PREFIX || waitMarker == NORMAL_PREFIX) {
                wait = waitMarker == WAIT_PREFIX;
                editorString = editorString.substring(1);
            }
            String[] cmd = editorString.split(JShellTool.RECORD_SEPARATOR);
            return new EditorSetting(cmd, wait);
        }

        static void removePrefs(Preferences prefs) {
            prefs.remove(JShellTool.EDITOR_KEY);
        }

        void toPrefs(Preferences prefs) {
            prefs.put(JShellTool.EDITOR_KEY, this == BUILT_IN_EDITOR ? BUILT_IN_REP : (this.wait ? WAIT_PREFIX : NORMAL_PREFIX) + String.join((CharSequence)JShellTool.RECORD_SEPARATOR, this.cmd));
        }

        public boolean equals(Object o) {
            if (o instanceof EditorSetting) {
                EditorSetting ed = (EditorSetting)o;
                return Arrays.equals(this.cmd, ed.cmd) && this.wait == ed.wait;
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + Arrays.deepHashCode(this.cmd);
            hash = 71 * hash + (this.wait ? 1 : 0);
            return hash;
        }
    }

    static final class FixedCompletionProvider
    implements CompletionProvider {
        private final String[] alternatives;

        public FixedCompletionProvider(String ... alternatives) {
            this.alternatives = alternatives;
        }

        @Override
        public List<SourceCodeAnalysis.Suggestion> completionSuggestions(String input, int cursor, int[] anchor) {
            ArrayList<SourceCodeAnalysis.Suggestion> result = new ArrayList<SourceCodeAnalysis.Suggestion>();
            for (String alternative : this.alternatives) {
                if (!alternative.startsWith(input)) continue;
                result.add(new ArgSuggestion(alternative));
            }
            anchor[0] = 0;
            return result;
        }
    }

    static enum CommandKind {
        NORMAL(true, true, true),
        REPLAY(true, true, true),
        HIDDEN(true, false, false),
        HELP_ONLY(false, true, false),
        HELP_SUBJECT(false, false, false);

        final boolean isRealCommand;
        final boolean showInHelp;
        final boolean shouldSuggestCompletions;

        private CommandKind(boolean isRealCommand, boolean showInHelp, boolean shouldSuggestCompletions) {
            this.isRealCommand = isRealCommand;
            this.showInHelp = showInHelp;
            this.shouldSuggestCompletions = shouldSuggestCompletions;
        }
    }

    static interface CompletionProvider {
        public List<SourceCodeAnalysis.Suggestion> completionSuggestions(String var1, int var2, int[] var3);
    }

    static final class Command {
        public final String command;
        public final String helpKey;
        public final Function<String, Boolean> run;
        public final CompletionProvider completions;
        public final CommandKind kind;

        public Command(String command, Function<String, Boolean> run, CompletionProvider completions) {
            this(command, run, completions, CommandKind.NORMAL);
        }

        public Command(String command, Function<String, Boolean> run, CompletionProvider completions, CommandKind kind) {
            this(command, "help." + command.substring(1), run, completions, kind);
        }

        public Command(String command, String helpKey, CommandKind kind) {
            this(command, helpKey, arg -> {
                throw new IllegalStateException();
            }, EMPTY_COMPLETION_PROVIDER, kind);
        }

        public Command(String command, String helpKey, Function<String, Boolean> run, CompletionProvider completions, CommandKind kind) {
            this.command = command;
            this.helpKey = helpKey;
            this.run = run;
            this.completions = completions;
            this.kind = kind;
        }
    }

    private class InitMessageHandler
    implements MessageHandler {
        private InitMessageHandler() {
        }

        @Override
        public void fluff(String format, Object ... args) {
        }

        @Override
        public void fluffmsg(String messageKey, Object ... args) {
        }

        @Override
        public void hard(String format, Object ... args) {
        }

        @Override
        public void hardmsg(String messageKey, Object ... args) {
        }

        @Override
        public void errormsg(String messageKey, Object ... args) {
            JShellTool.this.startmsg(messageKey, args);
        }

        @Override
        public boolean showFluff() {
            return false;
        }
    }
}

