/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.support;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;

class SnippetFileSystem
extends MultiFileSystem
implements Callable<FileObject> {
    private final FileObject projectRoot;
    private final FileObject configRoot;
    private final FileSystem projectFileSystem;
    private final FileSystem configFileSystem;
    private final String projectRootPath;
    private final String projectFSPrefix;
    private final String configFSPathPrefix;

    protected FileSystem createWritableOn(String name) throws IOException {
        return super.createWritableOn(name);
    }

    public SnippetFileSystem(FileObject projectRoot, FileObject configRoot, String projectFSPathPrefix, String configFSPathPrefix) throws IOException {
        super(new FileSystem[]{projectRoot.getFileSystem(), configRoot.getFileSystem()});
        this.projectRoot = projectRoot;
        this.projectFileSystem = projectRoot.getFileSystem();
        this.configFileSystem = configRoot.getFileSystem();
        this.configRoot = configRoot;
        this.projectRootPath = projectRoot.getPath();
        this.projectFSPrefix = projectFSPathPrefix;
        this.configFSPathPrefix = configFSPathPrefix;
    }

    protected FileObject findResourceOn(FileSystem fs, String res) {
        if (fs == this.projectFileSystem) {
            String append = this.projectRootPath + "/";
            if (!this.projectFSPrefix.isEmpty()) {
                append = append + this.projectFSPrefix + "/";
            }
            return this.projectFileSystem.findResource(append + res);
        }
        return this.configFileSystem.findResource(this.configFSPathPrefix + "/" + res);
    }

    @Override
    public FileObject call() throws IOException {
        return FileUtil.createFolder((FileObject)this.projectRoot, (String)this.projectFSPrefix);
    }

    boolean isObsolete() {
        return !this.projectRoot.isValid();
    }
}

