/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.wizard;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.javascript.nodejs.ui.wizard.Bundle;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.modules.web.clientproject.api.util.StringUtilities;
import org.netbeans.modules.web.clientproject.api.util.ValidationUtilities;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class ExistingProjectVisual
extends JPanel {
    private static final String TEST_DIR_NAME = "test";
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    boolean fireChanges = true;
    String lastSources = "";
    String lastProjectName = "";
    private JButton projectDirectoryBrowseButton;
    private JLabel projectDirectoryLabel;
    private JTextField projectDirectoryTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JButton siteRootBrowseButton;
    private JLabel siteRootLabel;
    private JTextField siteRootTextField;
    private JButton sourcesBrowseButton;
    private JLabel sourcesLabel;
    private JTextField sourcesTextField;

    public ExistingProjectVisual() {
        this.initComponents();
        this.init();
    }

    private void init() {
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.sourcesTextField.getDocument().addDocumentListener(new DefaultDocumentListener(new Runnable(){

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                ExistingProjectVisual.this.fireChanges = false;
                ExistingProjectVisual.this.updateProjectName();
                ExistingProjectVisual.this.updateProjectDirectory();
                ExistingProjectVisual.this.lastSources = ExistingProjectVisual.this.getSources();
                ExistingProjectVisual.this.fireChanges = true;
            }
        }));
        this.siteRootTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.projectNameTextField.getDocument().addDocumentListener(new DefaultDocumentListener(new Runnable(){

            @Override
            public void run() {
                assert (EventQueue.isDispatchThread());
                ExistingProjectVisual.this.fireChanges = false;
                ExistingProjectVisual.this.updateProjectDirectoryName();
                ExistingProjectVisual.this.lastProjectName = ExistingProjectVisual.this.getProjectName();
                ExistingProjectVisual.this.fireChanges = true;
            }
        }));
        this.projectDirectoryTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    public String getSiteRoot() {
        return this.siteRootTextField.getText().trim();
    }

    public String getSources() {
        return this.sourcesTextField.getText().trim();
    }

    public String getProjectName() {
        return this.projectNameTextField.getText().trim();
    }

    public String getProjectDirectory() {
        return this.projectDirectoryTextField.getText().trim();
    }

    @CheckForNull
    public String getTestDir() {
        String projectDirectory = this.getProjectDirectory();
        if (!StringUtilities.hasText((String)projectDirectory)) {
            return null;
        }
        if (new File(projectDirectory, TEST_DIR_NAME).isDirectory()) {
            return TEST_DIR_NAME;
        }
        return null;
    }

    public final void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public final void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public String getErrorMessage() {
        String sources = this.getSources();
        if (!StringUtilities.hasText((String)sources)) {
            return Bundle.ExistingProjectVisual_error_noSources();
        }
        String siteRoot = this.getSiteRoot();
        String error = this.validateFolder(siteRoot, Bundle.ExistingProjectVisual_siteRoot_label());
        if (error != null) {
            return error;
        }
        error = this.validateFolder(sources, Bundle.ExistingProjectVisual_sources_label());
        if (error != null) {
            return error;
        }
        error = this.validateProjectName();
        if (error != null) {
            return error;
        }
        error = this.validateProjectDirectory();
        if (error != null) {
            return error;
        }
        return null;
    }

    private String validateFolder(String folder, String folderName) {
        if (!StringUtilities.hasText((String)folder)) {
            return null;
        }
        File folderDir = FileUtil.normalizeFile((File)new File(folder).getAbsoluteFile());
        if (!folderDir.isDirectory()) {
            return Bundle.ExistingProjectVisual_error_folder_invalid(folderName);
        }
        if (NodeJsUtils.isProject(folderDir)) {
            return Bundle.ExistingProjectVisual_error_folder_nbproject(folderName);
        }
        return null;
    }

    private String validateProjectName() {
        String projectName = this.getProjectName();
        if (projectName.isEmpty()) {
            return Bundle.ExistingProjectVisual_error_name_empty();
        }
        return null;
    }

    private String validateProjectDirectory() {
        String projectDirectory = this.getProjectDirectory();
        if (projectDirectory.isEmpty()) {
            return Bundle.ExistingProjectVisual_error_projectDirectory_empty();
        }
        File projDir = FileUtil.normalizeFile((File)new File(projectDirectory).getAbsoluteFile());
        if (NodeJsUtils.isProject(projDir)) {
            return Bundle.ExistingProjectVisual_error_projectDirectory_alreadyProject();
        }
        if (!projDir.isDirectory()) {
            File existingParent;
            if (!ValidationUtilities.isValidFilename((File)projDir)) {
                return Bundle.ExistingProjectVisual_error_projectDirectory_invalid();
            }
            for (existingParent = projDir; existingParent != null && !existingParent.exists(); existingParent = existingParent.getParentFile()) {
            }
            if (existingParent == null || !existingParent.canWrite()) {
                return Bundle.ExistingProjectVisual_error_projectDirectory_notWritable();
            }
        }
        return null;
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    void updateProjectName() {
        this.projectNameTextField.setText(new File(this.getSources()).getName());
    }

    void updateProjectDirectory() {
        assert (EventQueue.isDispatchThread());
        String projectDirectory = this.getProjectDirectory();
        if (!this.lastSources.isEmpty() && projectDirectory.equals(this.lastSources)) {
            return;
        }
        this.projectDirectoryTextField.setText(this.getSources());
    }

    void updateProjectDirectoryName() {
        String projectDirectory = this.getProjectDirectory();
        if (projectDirectory.equals(this.getSources())) {
            return;
        }
        if (!this.lastProjectName.isEmpty() && !projectDirectory.equals(this.lastProjectName) && projectDirectory.endsWith(this.lastProjectName)) {
            String newProjDir = projectDirectory.substring(0, projectDirectory.length() - this.lastProjectName.length()) + this.getProjectName();
            this.projectDirectoryTextField.setText(newProjDir);
        }
    }

    private void initComponents() {
        this.sourcesLabel = new JLabel();
        this.sourcesTextField = new JTextField();
        this.sourcesBrowseButton = new JButton();
        this.siteRootLabel = new JLabel();
        this.siteRootTextField = new JTextField();
        this.siteRootBrowseButton = new JButton();
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectDirectoryLabel = new JLabel();
        this.projectDirectoryTextField = new JTextField();
        this.projectDirectoryBrowseButton = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.sourcesLabel, (String)NbBundle.getMessage(ExistingProjectVisual.class, (String)"ExistingProjectVisual.sourcesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.sourcesBrowseButton, (String)NbBundle.getMessage(ExistingProjectVisual.class, (String)"ExistingProjectVisual.sourcesBrowseButton.text"));
        this.sourcesBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExistingProjectVisual.this.sourcesBrowseButtonActionPerformed(evt);
            }
        });
        this.siteRootLabel.setLabelFor(this.siteRootTextField);
        Mnemonics.setLocalizedText((JLabel)this.siteRootLabel, (String)NbBundle.getMessage(ExistingProjectVisual.class, (String)"ExistingProjectVisual.siteRootLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.siteRootBrowseButton, (String)NbBundle.getMessage(ExistingProjectVisual.class, (String)"ExistingProjectVisual.siteRootBrowseButton.text"));
        this.siteRootBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExistingProjectVisual.this.siteRootBrowseButtonActionPerformed(evt);
            }
        });
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(ExistingProjectVisual.class, (String)"ExistingProjectVisual.projectNameLabel.text"));
        this.projectDirectoryLabel.setLabelFor(this.projectDirectoryTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectDirectoryLabel, (String)NbBundle.getMessage(ExistingProjectVisual.class, (String)"ExistingProjectVisual.projectDirectoryLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.projectDirectoryBrowseButton, (String)NbBundle.getMessage(ExistingProjectVisual.class, (String)"ExistingProjectVisual.projectDirectoryBrowseButton.text"));
        this.projectDirectoryBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExistingProjectVisual.this.projectDirectoryBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectDirectoryLabel).addComponent(this.projectNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectNameTextField).addGroup(layout.createSequentialGroup().addComponent(this.projectDirectoryTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectDirectoryBrowseButton)))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.siteRootLabel).addComponent(this.sourcesLabel)).addGap(27, 27, 27).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.sourcesTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourcesBrowseButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.siteRootTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.siteRootBrowseButton)))));
        layout.linkSize(0, this.projectDirectoryBrowseButton, this.siteRootBrowseButton, this.sourcesBrowseButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sourcesBrowseButton).addComponent(this.sourcesTextField, -2, -1, -2).addComponent(this.sourcesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.siteRootBrowseButton).addComponent(this.siteRootTextField, -2, -1, -2).addComponent(this.siteRootLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameTextField, -2, -1, -2).addComponent(this.projectNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectDirectoryLabel).addComponent(this.projectDirectoryTextField, -2, -1, -2).addComponent(this.projectDirectoryBrowseButton))));
    }

    private void siteRootBrowseButtonActionPerformed(ActionEvent evt) {
        File folder = this.browseFile(".siteRoot", Bundle.ExistingProjectVisual_siteRoot_dialog_title(), this.getSiteRoot());
        if (folder != null) {
            this.siteRootTextField.setText(FileUtil.normalizeFile((File)folder).getAbsolutePath());
        }
    }

    private void projectDirectoryBrowseButtonActionPerformed(ActionEvent evt) {
        File projectDirectory = this.browseFile(".projectDirectory", Bundle.ExistingProjectVisual_projectDirectory_dialog_title(), this.getProjectDirectory());
        if (projectDirectory != null) {
            this.projectDirectoryTextField.setText(FileUtil.normalizeFile((File)projectDirectory).getAbsolutePath());
        }
    }

    private void sourcesBrowseButtonActionPerformed(ActionEvent evt) {
        File folder = this.browseFile(".sources", Bundle.ExistingProjectVisual_sources_dialog_title(), this.getSources());
        if (folder != null) {
            this.sourcesTextField.setText(FileUtil.normalizeFile((File)folder).getAbsolutePath());
        }
    }

    private File browseFile(String dirKey, String title, String currentDirectory) {
        File currDir;
        File workDir = null;
        if (currentDirectory != null && !currentDirectory.isEmpty() && (currDir = new File(currentDirectory)).isDirectory()) {
            workDir = currDir;
        }
        FileChooserBuilder builder = new FileChooserBuilder(ExistingProjectVisual.class.getName() + dirKey).setTitle(title).setDirectoriesOnly(true);
        if (workDir != null) {
            builder.setDefaultWorkingDirectory(workDir).forceUseOfDefaultWorkingDirectory(true);
        }
        return builder.showOpenDialog();
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private final Runnable task;

        public DefaultDocumentListener() {
            this(null);
        }

        public DefaultDocumentListener(Runnable task) {
            this.task = task;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            assert (EventQueue.isDispatchThread());
            if (this.task != null) {
                this.task.run();
            }
            if (ExistingProjectVisual.this.fireChanges) {
                ExistingProjectVisual.this.fireChange();
            }
        }
    }
}

