/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.terminalemulator;

import org.netbeans.lib.terminalemulator.AbstractInterp;
import org.netbeans.lib.terminalemulator.InterpProtoANSIX;
import org.netbeans.lib.terminalemulator.Ops;

class InterpXTerm
extends InterpProtoANSIX {
    private final InterpTypeXTerm type;
    private static final InterpTypeXTerm type_singleton = new InterpTypeXTerm();

    public InterpXTerm(Ops ops) {
        super(ops, type_singleton);
        this.type = type_singleton;
        this.setup();
    }

    protected InterpXTerm(Ops ops, InterpTypeXTerm type) {
        super(ops, type);
        this.type = type;
        this.setup();
    }

    @Override
    public String name() {
        return "xterm-16color";
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    protected boolean dispatchAttr(AbstractInterp ai, int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 22: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                ai.ops.op_attr(n);
                return true;
            }
        }
        return false;
    }

    private void setup() {
    }

    protected static class InterpTypeXTerm
    extends InterpProtoANSIX.InterpTypeProtoANSIX {
        protected final AbstractInterp.State st_esc_lb_gt = new AbstractInterp.State("esc_lb_gt");
        protected final AbstractInterp.Actor act_done_collect_escbs = new ACT_DONE_COLLECT_ESCBS();

        protected InterpTypeXTerm() {
            this.st_esc_lb.setAction('>', this.st_esc_lb_gt, this.act_reset_number);
            for (char c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                this.st_esc_lb_gt.setAction(c, this.st_esc_lb_gt, this.act_remember_digit);
            }
            this.st_esc_lb_gt.setAction(';', this.st_esc_lb_gt, this.act_push_number);
            this.st_esc_lb_gt.setAction('T', this.st_base, new ACT_XTERM_CAPITAL_T());
            this.st_esc_lb_gt.setAction('c', this.st_base, new ACT_XTERM_c());
            this.st_esc_lb_gt.setAction('m', this.st_base, new ACT_XTERM_m());
            this.st_esc_lb_gt.setAction('n', this.st_base, new ACT_XTERM_n());
            this.st_esc_lb_gt.setAction('p', this.st_base, new ACT_XTERM_p());
            this.st_esc_lb_gt.setAction('t', this.st_base, new ACT_XTERM_t());
            this.st_esc_rb_N.setAction('\u001b', this.st_wait, this.act_nop);
            this.st_wait.setAction('\\', this.st_base, this.act_done_collect_escbs);
        }

        private static final class ACT_DONE_COLLECT_ESCBS
        implements AbstractInterp.Actor {
            private ACT_DONE_COLLECT_ESCBS() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                InterpProtoANSIX i = (InterpProtoANSIX)ai;
                int semix = i.text.indexOf(59);
                if (semix == -1) {
                    return null;
                }
                String p1 = i.text.substring(0, semix);
                String p2 = i.text.substring(semix + 1);
                int code = Integer.parseInt(p1);
                switch (code) {
                    case 0: {
                        ai.ops.op_icon_name(p2);
                        ai.ops.op_win_title(p2);
                        break;
                    }
                    case 1: {
                        ai.ops.op_icon_name(p2);
                        break;
                    }
                    case 2: {
                        ai.ops.op_win_title(p2);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 10: {
                        int semix2 = p2.indexOf(59);
                        if (semix2 == -1) {
                            return null;
                        }
                        String p3 = p2.substring(semix2 + 1);
                        p2 = p2.substring(0, semix2);
                        ai.ops.op_hyperlink(p2, p3);
                    }
                }
                return null;
            }
        }

        private static final class ACT_XTERM_t
        implements AbstractInterp.Actor {
            private ACT_XTERM_t() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                return "ACT_XTERM_t: UNIMPLEMENTED";
            }
        }

        private static final class ACT_XTERM_p
        implements AbstractInterp.Actor {
            private ACT_XTERM_p() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                return "ACT_XTERM_p: UNIMPLEMENTED";
            }
        }

        private static final class ACT_XTERM_n
        implements AbstractInterp.Actor {
            private ACT_XTERM_n() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                return "ACT_XTERM_n: UNIMPLEMENTED";
            }
        }

        private static final class ACT_XTERM_m
        implements AbstractInterp.Actor {
            private ACT_XTERM_m() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                return "ACT_XTERM_m: UNIMPLEMENTED";
            }
        }

        private static final class ACT_XTERM_c
        implements AbstractInterp.Actor {
            private ACT_XTERM_c() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                ai.ops.op_send_chars("\u001b[>0;0;0c");
                return null;
            }
        }

        private static final class ACT_XTERM_CAPITAL_T
        implements AbstractInterp.Actor {
            private ACT_XTERM_CAPITAL_T() {
            }

            @Override
            public String action(AbstractInterp ai, char c) {
                return "ACT_XTERM_T: UNIMPLEMENTED";
            }
        }
    }
}

