/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.TypeElement;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class MainClassChooser
extends JPanel {
    private ChangeListener changeListener;
    private String dialogSubtitle = null;
    private Collection<ElementHandle<TypeElement>> possibleMainClasses;
    public static Boolean unitTestingSupport_hasMainMethodResult = null;
    private JLabel jLabel1;
    private JList jMainClassList;
    private JScrollPane jScrollPane1;
    private JLabel scanningLabel;

    public MainClassChooser(FileObject[] sourcesRoots) {
        this(sourcesRoots, null, null);
    }

    public MainClassChooser(@NonNull FileObject[] sourcesRoots, @NullAllowed String subtitle) {
        this(sourcesRoots, subtitle, null);
    }

    public MainClassChooser(@NonNull FileObject[] sourcesRoots, @NullAllowed String subtitle, @NullAllowed String mainClass) {
        Parameters.notNull((CharSequence)"sourceRoots", (Object)sourcesRoots);
        this.dialogSubtitle = subtitle;
        this.initComponents();
        this.jMainClassList.setCellRenderer(new MainClassRenderer());
        this.initClassesView();
        this.initClassesModel(sourcesRoots, mainClass);
        this.scanningLabel.setVisible(false);
    }

    public MainClassChooser(Collection<ElementHandle<TypeElement>> mainClassesInFile) {
        this(mainClassesInFile, null);
    }

    public MainClassChooser(Collection<ElementHandle<TypeElement>> mainClassesInFile, String subtitle) {
        assert (mainClassesInFile != null);
        this.dialogSubtitle = subtitle;
        this.initComponents();
        this.jMainClassList.setCellRenderer(new MainClassRenderer());
        this.initClassesView();
        this.initClassesModel(mainClassesInFile);
    }

    private void initClassesView() {
        this.possibleMainClasses = null;
        this.jMainClassList.setSelectionMode(0);
        this.jMainClassList.setListData(this.getWarmupList());
        this.jMainClassList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(evt));
                }
            }
        });
        this.jMainClassList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseUtils.isDoubleClick((MouseEvent)e) && MainClassChooser.this.getSelectedMainClass() != null && MainClassChooser.this.changeListener != null) {
                    MainClassChooser.this.changeListener.stateChanged(new ChangeEvent(e));
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        if (this.dialogSubtitle != null) {
            Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)this.dialogSubtitle);
        }
    }

    private void initClassesModel(FileObject[] sourcesRoots, String mainClass) {
        ClasspathInfo cpInfo = ClasspathInfo.create((ClassPath)ClassPathSupport.createClassPath((URL[])new URL[0]), (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[0]), (ClassPath)ClassPathSupport.createClassPath((URL[])new URL[0]));
        JavaSource dummyJs = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[0]);
        AtomicBoolean flag = new AtomicBoolean(true);
        SearchTask afterScan = new SearchTask(sourcesRoots, mainClass, flag, false){

            @Override
            public void run(CompilationController parameter) throws Exception {
                this.stillEnabled.set(false);
                super.run(parameter);
            }
        };
        try {
            Future task = dummyJs.runWhenScanFinished((Task)afterScan, true);
            if (task.isDone()) {
                return;
            }
            task.cancel(true);
            dummyJs.runUserActionTask((Task)new SearchTask(sourcesRoots, mainClass, flag, true){

                @Override
                public void run(CompilationController parameter) throws Exception {
                    if (!this.stillEnabled.getAndSet(false)) {
                        return;
                    }
                    super.run(parameter);
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initClassesModel(Collection<ElementHandle<TypeElement>> mainClasses) {
        ArrayList<ElementHandle<TypeElement>> sortedMainClasses = new ArrayList<ElementHandle<TypeElement>>(mainClasses);
        Collections.sort(sortedMainClasses, new MainClassComparator());
        this.possibleMainClasses = mainClasses;
        this.jMainClassList.setListData(sortedMainClasses.toArray());
        this.jMainClassList.setSelectedIndex(0);
        this.scanningLabel.setVisible(false);
    }

    private Object[] getWarmupList() {
        return new Object[]{NbBundle.getMessage(MainClassChooser.class, (String)"LBL_ChooseMainClass_WARMUP_MESSAGE")};
    }

    private boolean isValidMainClassName(Object value) {
        return this.possibleMainClasses != null && this.possibleMainClasses.contains(value);
    }

    public String getSelectedMainClass() {
        ElementHandle te = null;
        if (this.isValidMainClassName(this.jMainClassList.getSelectedValue())) {
            te = (ElementHandle)this.jMainClassList.getSelectedValue();
        }
        return te == null ? null : te.getBinaryName();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeListener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListener = null;
    }

    public static boolean hasMainMethod(FileObject classFO) {
        return CommonProjectUtils.hasMainMethod(classFO);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jMainClassList = new JList();
        this.scanningLabel = new JLabel();
        this.setPreferredSize(new Dimension(380, 300));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.jMainClassList);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getBundle(MainClassChooser.class).getString("CTL_AvaialableMainClasses"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 2, 12);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setMinimumSize(new Dimension(100, 200));
        this.jScrollPane1.setViewportView(this.jMainClassList);
        this.jMainClassList.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainClassChooser.class).getString("AD_jMainClassList"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.scanningLabel.setFont(new Font("Dialog", 2, 12));
        this.scanningLabel.setText(NbBundle.getBundle(MainClassChooser.class).getString("LBL_ChooseMainClass_SCANNING_MESSAGE"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.scanningLabel, gridBagConstraints);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(MainClassChooser.class).getString("AD_MainClassChooser"));
    }

    private static int getMainClassIndex(List<? extends ElementHandle<TypeElement>> handles, String mainClass) {
        if (mainClass != null) {
            Iterator<? extends ElementHandle<TypeElement>> it = handles.iterator();
            int index = 0;
            while (it.hasNext()) {
                if (mainClass.equals(it.next().getQualifiedName())) {
                    return index;
                }
                ++index;
            }
        }
        return 0;
    }

    private static class MainClassComparator
    implements Comparator<ElementHandle> {
        private MainClassComparator() {
        }

        @Override
        public int compare(ElementHandle arg0, ElementHandle arg1) {
            return arg0.getQualifiedName().compareTo(arg1.getQualifiedName());
        }
    }

    private static final class MainClassRenderer
    extends DefaultListCellRenderer {
        private MainClassRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof String) {
                String string = (String)value;
            }
            String displayName = value instanceof ElementHandle ? ((ElementHandle)value).getQualifiedName() : value.toString();
            return super.getListCellRendererComponent((JList<?>)list, displayName, index, isSelected, cellHasFocus);
        }
    }

    private class SearchTask
    implements Task<CompilationController> {
        final FileObject[] sourcesRoots;
        final String mainClass;
        final AtomicBoolean stillEnabled;
        boolean incomplete;

        public SearchTask(FileObject[] sourcesRoots, String mainClass, AtomicBoolean flag, boolean incomplete) {
            this.sourcesRoots = sourcesRoots;
            this.mainClass = mainClass;
            this.stillEnabled = flag;
            this.incomplete = incomplete;
        }

        public void run(CompilationController parameter) throws Exception {
            parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            MainClassChooser.this.possibleMainClasses = SourceUtils.getMainClasses((FileObject[])this.sourcesRoots);
            if (MainClassChooser.this.possibleMainClasses.isEmpty()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainClassChooser.this.jMainClassList.setListData(new String[]{NbBundle.getMessage(MainClassChooser.class, (String)"LBL_ChooseMainClass_NO_CLASSES_NODE")});
                        MainClassChooser.this.scanningLabel.setVisible(SearchTask.this.incomplete);
                    }
                });
            } else {
                final ArrayList sortedMainClasses = new ArrayList(MainClassChooser.this.possibleMainClasses);
                Collections.sort(sortedMainClasses, new MainClassComparator());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainClassChooser.this.jMainClassList.setListData(sortedMainClasses.toArray());
                        int index = MainClassChooser.getMainClassIndex(sortedMainClasses, SearchTask.this.mainClass);
                        MainClassChooser.this.jMainClassList.setSelectedIndex(index);
                        MainClassChooser.this.scanningLabel.setVisible(SearchTask.this.incomplete);
                    }
                });
            }
        }
    }
}

