/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.WeakHashMap;
import javax.swing.Timer;
import org.openide.explorer.ExplorerActions;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.WeakListeners;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.SafeException;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

@Deprecated
public class ExplorerPanel
extends TopComponent
implements ExplorerManager.Provider {
    static final long serialVersionUID = 5522528786650751459L;
    private static MessageFormat formatExplorerTitle;
    private static final int INIT_DELAY = 70;
    private static final int MAX_DELAY = 350;
    private static Boolean scheduleAcivatedNodes;
    private static WeakHashMap<ExplorerManager, Reference<ExplorerPanel>> panels;
    private ExplorerManager manager;
    private final transient PropertyChangeListener managerListener = new PropL();
    private ExplorerActions actions;
    private transient DelayedSetter delayedSetter;

    public ExplorerPanel(ExplorerManager manager) {
        this(manager, null);
    }

    public ExplorerPanel() {
        this(null, null);
    }

    ExplorerPanel(ExplorerManager manager, boolean confirm) {
        this(manager, (Boolean)confirm);
    }

    private ExplorerPanel(ExplorerManager manager, Boolean confirm) {
        if (manager == null) {
            manager = new ExplorerManager();
        }
        this.manager = manager;
        panels.put(manager, new WeakReference<ExplorerPanel>(this));
        this.setLayout(new BorderLayout());
        this.initActionMap(confirm);
        this.initListening();
    }

    private void initActionMap(Boolean confirm) {
        ExplorerActions a = new ExplorerActions(false);
        if (confirm != null) {
            a.setConfirmDelete(confirm);
        }
        a.attach(this.getExplorerManager());
    }

    static void associateActions(ExplorerActions actions, ExplorerManager em) {
        ExplorerPanel p;
        Reference<ExplorerPanel> ref = panels.get(em);
        ExplorerPanel explorerPanel = p = ref == null ? null : ref.get();
        if (p != null) {
            p.getActionMap().put("copy-to-clipboard", actions.copyAction());
            p.getActionMap().put("cut-to-clipboard", actions.cutAction());
            p.getActionMap().put("paste-from-clipboard", actions.pasteAction());
            p.getActionMap().put("delete", actions.deleteAction());
            p.actions = actions;
        }
    }

    private void initListening() {
        ExplorerManager man = this.getExplorerManager();
        man.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.managerListener, (Object)man));
        this.setActivatedNodes(this.manager.getSelectedNodes());
    }

    public void open() {
        this.open(WindowManager.getDefault().getCurrentWorkspace());
    }

    public void open(Workspace workspace) {
        super.open(workspace);
        this.setActivatedNodes(this.getExplorerManager().getSelectedNodes());
        this.updateTitle();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    protected void componentActivated() {
        if (this.actions != null) {
            this.actions.attach(this.getExplorerManager());
        }
    }

    protected void componentDeactivated() {
        if (this.actions != null) {
            this.actions.detach();
        }
    }

    protected void updateTitle() {
        String nm;
        Node n;
        String name = "";
        ExplorerManager em = this.getExplorerManager();
        if (em != null && (n = em.getExploredContext()) != null && (nm = n.getDisplayName()) != null) {
            name = nm;
        }
        if (formatExplorerTitle == null) {
            formatExplorerTitle = new MessageFormat(NbBundle.getMessage(ExplorerPanel.class, (String)"explorerTitle"));
        }
        this.setName(formatExplorerTitle.format(new Object[]{name}));
    }

    public HelpCtx getHelpCtx() {
        return ExplorerPanel.getHelpCtx(this.getExplorerManager().getSelectedNodes(), new HelpCtx(ExplorerPanel.class));
    }

    public static HelpCtx getHelpCtx(Node[] sel, HelpCtx def) {
        return ExplorerUtils.getHelpCtx((Node[])sel, (HelpCtx)def);
    }

    public static void setConfirmDelete(boolean confirmDelete) {
        NbPreferences.root().node("/org/netbeans/core").putBoolean("confirmDelete", confirmDelete);
    }

    public static boolean isConfirmDelete() {
        return NbPreferences.root().node("/org/netbeans/core").getBoolean("confirmDelete", true);
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        super.writeExternal(oo);
        oo.writeObject(new NbMarshalledObject((Object)this.manager));
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        super.readExternal(oi);
        Object anObj = oi.readObject();
        if (anObj instanceof ExplorerManager) {
            this.manager = (ExplorerManager)anObj;
            panels.put(this.manager, new WeakReference<ExplorerPanel>(this));
            this.initActionMap(null);
            this.initListening();
            return;
        }
        NbMarshalledObject obj = (NbMarshalledObject)anObj;
        try {
            this.manager = (ExplorerManager)obj.get();
            panels.put(this.manager, new WeakReference<ExplorerPanel>(this));
            this.initActionMap(null);
            this.initListening();
        }
        catch (SafeException se) {
            throw se;
        }
        catch (IOException ioe) {
            throw new SafeException((Exception)ioe);
        }
    }

    private boolean delayActivatedNodes() {
        if (scheduleAcivatedNodes == null) {
            scheduleAcivatedNodes = System.getProperty("netbeans.delay.tc") != null ? (Boolean.getBoolean("netbeans.delay.tc") ? Boolean.TRUE : Boolean.FALSE) : Boolean.FALSE;
        }
        return scheduleAcivatedNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void scheduleActivatedNodes(Node[] nodes) {
        ExplorerPanel explorerPanel = this;
        synchronized (explorerPanel) {
            if (this.delayedSetter == null) {
                this.delayedSetter = new DelayedSetter();
            }
        }
        this.delayedSetter.scheduleActivatedNodes(nodes);
    }

    static {
        panels = new WeakHashMap();
    }

    private class DelayedSetter
    implements ActionListener {
        private Node[] nodes;
        private Timer timer;
        private boolean firstChange = true;

        DelayedSetter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleActivatedNodes(Node[] nodes) {
            DelayedSetter delayedSetter = this;
            synchronized (delayedSetter) {
                this.nodes = nodes;
                if (this.timer == null) {
                    this.timer = new Timer(70, this);
                    this.timer.setCoalesce(true);
                    this.timer.setRepeats(false);
                }
                if (this.timer.isRunning()) {
                    if (this.timer.getInitialDelay() < 350) {
                        this.timer.setInitialDelay(this.timer.getInitialDelay() * 2);
                    }
                    this.firstChange = false;
                } else {
                    ExplorerPanel.this.setActivatedNodes(nodes);
                    this.firstChange = true;
                }
                this.timer.restart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt) {
            DelayedSetter delayedSetter = this;
            synchronized (delayedSetter) {
                DelayedSetter delayedSetter2 = this;
                synchronized (delayedSetter2) {
                    this.timer.stop();
                }
            }
            if (!this.firstChange) {
                ExplorerPanel.this.setActivatedNodes(this.nodes);
            }
        }
    }

    private final class PropL
    implements PropertyChangeListener {
        PropL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() != ExplorerPanel.this.manager) {
                return;
            }
            if ("selectedNodes".equals(evt.getPropertyName())) {
                if (ExplorerPanel.this.delayActivatedNodes()) {
                    ExplorerPanel.this.scheduleActivatedNodes(ExplorerPanel.this.manager.getSelectedNodes());
                } else {
                    ExplorerPanel.this.setActivatedNodes(ExplorerPanel.this.manager.getSelectedNodes());
                }
                return;
            }
            if ("exploredContext".equals(evt.getPropertyName())) {
                ExplorerPanel.this.updateTitle();
                return;
            }
        }
    }
}

