/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.AddQueryParameterDlg;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilderInputTableModel;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryModel;
import org.netbeans.modules.db.sql.visualeditor.querymodel.And;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Column;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Expression;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ExpressionList;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Literal;
import org.netbeans.modules.db.sql.visualeditor.querymodel.OrderBy;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Predicate;
import org.netbeans.modules.db.sql.visualeditor.querymodel.SQLQueryFactory;
import org.netbeans.modules.db.sql.visualeditor.querymodel.SortSpecification;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Value;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Where;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class QueryBuilderInputTable
extends JTable
implements ActionListener,
ItemListener,
KeyListener {
    public static final int Column_COLUMN = 0;
    public static final int Alias_COLUMN = 1;
    public static final int Table_COLUMN = 2;
    public static final int Output_COLUMN = 3;
    public static final int SortType_COLUMN = 4;
    public static final int SortOrder_COLUMN = 5;
    public static final int Criteria_COLUMN = 6;
    public static final int CriteriaOrder_COLUMN = 7;
    public static final int Column_COLUMN_WIDTH = 140;
    public static final int Alias_COLUMN_WIDTH = 70;
    public static final int Table_COLUMN_WIDTH = 180;
    public static final int SortType_COLUMN_WIDTH = 80;
    public static final int SortOrder_COLUMN_WIDTH = 80;
    public static final int Criteria_COLUMN_WIDTH = 100;
    public static final int CriteriaOrder_COLUMN_WIDTH = 40;
    public static final String Criteria_Uneditable_String = "*****";
    public static final String CriteriaOrder_Uneditable_String = "*";
    private static final boolean DEBUG = false;
    private QueryBuilder _queryBuilder;
    private JPopupMenu _inputTablePopup;
    private int _inputTablePopupRow;
    private int _inputTablePopupColumn;
    private JComboBox _sortOrderComboBox;
    private JComboBox _criteriaOrderComboBox;
    AddQueryParameterDlg _addQueryParameterDlg = null;

    public QueryBuilderInputTable(QueryBuilder queryBuilder) {
        Log.getLogger().entering("QueryBuilderInputTable", "constructor");
        this._queryBuilder = queryBuilder;
        QueryBuilderInputTableModel queryBuilderInputTableModel = new QueryBuilderInputTableModel();
        super.setModel(queryBuilderInputTableModel);
        TableColumn column = this.getColumnModel().getColumn(0);
        column.setPreferredWidth(140);
        column = this.getColumnModel().getColumn(1);
        column.setPreferredWidth(70);
        column.setCellEditor(new FocusCellEditor(new JTextField()));
        column = this.getColumnModel().getColumn(2);
        column.setPreferredWidth(180);
        column = this.getColumnModel().getColumn(4);
        column.setPreferredWidth(80);
        column = this.getColumnModel().getColumn(5);
        column.setPreferredWidth(80);
        column = this.getColumnModel().getColumn(6);
        column.setPreferredWidth(100);
        column.setCellEditor(new FocusCellEditor(new JTextField()));
        column = this.getColumnModel().getColumn(7);
        column.setPreferredWidth(40);
        this.getColumnModel().getColumn(0).setCellEditor(new FocusCellEditor(new JTextField()));
        Object[] sortTypeItems = new Object[]{"", NbBundle.getMessage(QueryBuilderInputTable.class, (String)"ASCENDING"), NbBundle.getMessage(QueryBuilderInputTable.class, (String)"DESCENDING")};
        TableColumn sortTypeColumn = this.getColumnModel().getColumn(4);
        JComboBox<Object> sortTypeComboBox = new JComboBox<Object>(sortTypeItems);
        sortTypeColumn.setCellEditor(new DefaultCellEditor(sortTypeComboBox));
        sortTypeComboBox.addItemListener(this);
        Object[] sortOrderItems = new Object[]{""};
        TableColumn sortOrderColumn = this.getColumnModel().getColumn(5);
        this._sortOrderComboBox = new JComboBox<Object>(sortOrderItems);
        sortOrderColumn.setCellEditor(new DefaultCellEditor(this._sortOrderComboBox));
        this._sortOrderComboBox.addItemListener(this);
        Object[] criteriaOrderItems = new Object[]{""};
        TableColumn criteriaOrderColumn = this.getColumnModel().getColumn(7);
        this._criteriaOrderComboBox = new JComboBox<Object>(criteriaOrderItems);
        criteriaOrderColumn.setCellEditor(new DefaultCellEditor(this._criteriaOrderComboBox));
        this.setAutoResizeMode(0);
        this._inputTablePopup = this.createInputTablePopup();
        InputTablePopupListener inputTablePopupListener = new InputTablePopupListener();
        super.addMouseListener(inputTablePopupListener);
        this.setMinimumSize(new Dimension(200, 200));
        this.setBackground(Color.white);
        this.getTableHeader().setReorderingAllowed(false);
        this.addKeyListener(this);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.isShiftDown()) {
            int code = e.getKeyCode();
            switch (code) {
                case 121: {
                    JTable source = (JTable)e.getSource();
                    if (!source.isEnabled()) {
                        return;
                    }
                    this._inputTablePopupRow = source.getSelectedRow();
                    this._inputTablePopupColumn = source.getEditingColumn();
                    if (this._inputTablePopupColumn == 5) {
                        source.setEditingColumn(0);
                    }
                    if (this._inputTablePopupRow != -1) {
                        source.setRowSelectionInterval(this._inputTablePopupRow, this._inputTablePopupRow);
                    }
                    this._inputTablePopup.show(source, source.getWidth() / 2, source.getHeight() / 2);
                }
            }
        }
        this._queryBuilder.handleKeyPress(e);
    }

    JComboBox getSortOrderComboBox() {
        return this._sortOrderComboBox;
    }

    JComboBox getCriteriaOrderComboBox() {
        return this._criteriaOrderComboBox;
    }

    JPopupMenu createInputTablePopup() {
        JPopupMenu inputTablePopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"ADD_QUERY_CRITERIA"));
        menuItem.addActionListener(this);
        inputTablePopup.add(menuItem);
        return inputTablePopup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        if (source.getText().equals(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"ADD_QUERY_CRITERIA"))) {
            this._addQueryParameterDlg = new AddQueryParameterDlg(true, (String)this.getValueAt(this.getSelectedRow(), 0));
            if (this._addQueryParameterDlg.getReturnStatus() == 1) {
                this._queryBuilder._updateText = false;
                try {
                    String result = this._addQueryParameterDlg.getCriteria();
                    if (result.trim().length() == 0) {
                        return;
                    }
                    this.getCellEditor(this._inputTablePopupRow, 6).stopCellEditing();
                    this.setValueAt(result, this._inputTablePopupRow, 6);
                }
                finally {
                    this._queryBuilder._updateText = true;
                }
                this._queryBuilder.generateText();
            }
        } else if (source.getText().equals(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"ADD_AND_QUERY_CRITERIA"))) {
            int row = this.getSelectedRow();
            String tableSpec = (String)this.getValueAt(row, 2);
            String columnName = (String)this.getValueAt(row, 0);
            String result0 = (String)this.getValueAt(this._inputTablePopupRow, this._inputTablePopupColumn);
            if (this._queryBuilder._queryModel.getWhere() == null) {
                String msg = NbBundle.getMessage(QueryBuilderInputTable.class, (String)"EMPTY_QUERY_CRITERIA");
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)(msg + "\n\n"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                return;
            }
            Column col = this._queryBuilder._queryModel.findSelectColumn(tableSpec, columnName);
            String derColName = col.getDerivedColName();
            Object[] rowData = new Object[]{columnName.equals("* { All Columns }") ? CriteriaOrder_Uneditable_String : columnName, derColName == null ? "" : derColName, tableSpec, Boolean.TRUE, "", "", "", ""};
            this._addQueryParameterDlg = new AddQueryParameterDlg(true, (String)this.getValueAt(this.getSelectedRow(), 0));
            if (this._addQueryParameterDlg.getReturnStatus() == 1) {
                ((DefaultTableModel)this.getModel()).insertRow(row + 1, rowData);
                this.setRowSelectionInterval(row + 1, row + 1);
                String result = this._addQueryParameterDlg.getCriteria();
                if (result.trim().length() == 0) {
                    return;
                }
                this.setValueAt(result, this.getSelectedRow(), 6);
                int i = result.indexOf(" ");
                String op = result.substring(0, i);
                String val = result.substring(i + 1);
                Column col1 = SQLQueryFactory.createColumn(tableSpec, columnName);
                Literal lit2 = new Literal(val);
                Predicate pred = SQLQueryFactory.createPredicate((Value)col1, lit2, op);
                this._queryBuilder._queryModel.addOrCreateAndExpression(pred);
                this._queryBuilder.generateText();
            }
        } else if (source.getText().equals(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"ADD_OR_QUERY_CRITERIA"))) {
            int row = this.getSelectedRow();
            String tableSpec = (String)this.getValueAt(row, 2);
            String columnName = (String)this.getValueAt(row, 0);
            String result0 = (String)this.getValueAt(this._inputTablePopupRow, this._inputTablePopupColumn);
            if (this._queryBuilder._queryModel.getWhere() == null) {
                String msg = NbBundle.getMessage(QueryBuilderInputTable.class, (String)"EMPTY_QUERY_CRITERIA");
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)(msg + "\n\n"), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                return;
            }
            Column col = this._queryBuilder._queryModel.findSelectColumn(tableSpec, columnName);
            String derColName = col.getDerivedColName();
            Object[] rowData = new Object[]{columnName.equals("* { All Columns }") ? CriteriaOrder_Uneditable_String : columnName, derColName == null ? "" : derColName, tableSpec, Boolean.TRUE, "", "", "", ""};
            this._addQueryParameterDlg = new AddQueryParameterDlg(true, (String)this.getValueAt(this.getSelectedRow(), 0));
            if (this._addQueryParameterDlg.getReturnStatus() == 1) {
                ((DefaultTableModel)this.getModel()).addColumn("Or...");
                int orColumn = ((DefaultTableModel)this.getModel()).getColumnCount();
                ((DefaultTableModel)this.getModel()).addColumn("Order");
                String result = this._addQueryParameterDlg.getCriteria();
                if (result.trim().length() == 0) {
                    return;
                }
                ((DefaultTableModel)this.getModel()).setValueAt(result, row, orColumn - 1);
                int i = result.indexOf(" ");
                String op = result.substring(0, i);
                String val = result.substring(i + 1);
                Column col1 = SQLQueryFactory.createColumn(tableSpec, columnName);
                Literal lit2 = new Literal(val);
                Predicate pred = SQLQueryFactory.createPredicate((Value)col1, lit2, op);
                this._queryBuilder._queryModel.addOrCreateOrExpression(pred);
                this._queryBuilder.generateText();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void itemStateChanged(ItemEvent e) {
        int row = this.getSelectedRow();
        if (this._queryBuilder._updateModel && row != -1 && e.getStateChange() == 1) {
            boolean updateText = this._queryBuilder._updateText;
            this._queryBuilder._updateText = false;
            try {
                String item = (String)e.getItem();
                String tableSpec = (String)this.getValueAt(row, 2);
                String columnName = (String)this.getValueAt(row, 0);
                int sortCount = this._queryBuilder._queryModel.getSortCount();
                if (item.equals("")) {
                    this.setValueAt("", row, 4);
                    this.setValueAt("", row, 5);
                    this._queryBuilder._queryModel.removeSortSpecification(tableSpec, columnName);
                } else if (item.equals("ASC") || item.equals(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"ASCENDING"))) {
                    String order = (String)this.getValueAt(row, 5);
                    int orderNum = order.equals("") ? sortCount + 1 : Integer.parseInt(order);
                    this._queryBuilder._queryModel.addSortSpecification(tableSpec, columnName, "ASC", orderNum);
                } else if (item.equals("DESC") || item.equals(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"DESCENDING"))) {
                    String order = (String)this.getValueAt(row, 5);
                    int orderNum = order.equals("") ? sortCount + 1 : Integer.parseInt(order);
                    this._queryBuilder._queryModel.addSortSpecification(tableSpec, columnName, "DESC", orderNum);
                } else {
                    String type = (String)this.getValueAt(row, 4);
                    int orderNum = Integer.parseInt(item);
                    if (!type.equals("")) {
                        String sortType = new String("ASC");
                        if (type.equals(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"DESCENDING"))) {
                            sortType = new String("DESC");
                        }
                        if (orderNum <= sortCount) {
                            this._queryBuilder._queryModel.addSortSpecification(tableSpec, columnName, sortType, orderNum);
                        }
                    } else {
                        this._queryBuilder._queryModel.addSortSpecification(tableSpec, columnName, "ASC", orderNum);
                    }
                }
                this.clearSelection();
                this.generateTableOrderBy(this._queryBuilder._queryModel);
            }
            finally {
                this._queryBuilder._updateText = updateText;
            }
            if (this._queryBuilder._updateText) {
                this._queryBuilder.generateText();
            }
        }
    }

    void selectColumn(String tableSpec, String columnName, Boolean select) {
        int row = this.findRow(tableSpec, columnName);
        if (row == -1) {
            return;
        }
        if (select == Boolean.TRUE && this.getValueAt(row, 3) != Boolean.TRUE) {
            this.setValueAt(Boolean.TRUE, row, 3);
        } else if (select == Boolean.FALSE && this.getValueAt(row, 3) != Boolean.FALSE) {
            this.setValueAt(Boolean.FALSE, row, 3);
        }
    }

    void addRow(String tableSpec, String columnName) {
        int i = this.findRow(tableSpec, columnName);
        if (i != -1) {
            if (this.getValueAt(i, 3) != Boolean.TRUE) {
                this.setValueAt(Boolean.TRUE, i, 3);
            }
        } else {
            Column col = this._queryBuilder._queryModel.findSelectColumn(tableSpec, columnName);
            String derColName = null;
            if (col != null) {
                derColName = col.getDerivedColName();
            }
            Object[] rowData = new Object[]{columnName.equals("* { All Columns }") ? CriteriaOrder_Uneditable_String : columnName, derColName == null ? "" : derColName, tableSpec, Boolean.TRUE, "", "", "", ""};
            ((DefaultTableModel)this.dataModel).addRow(rowData);
        }
    }

    void removeRow(String tableSpec, String columnName) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            boolean sortOrderRow;
            if (!this.getValueAt(i, 2).equals(tableSpec) || !this.getValueAt(i, 0).equals(columnName)) continue;
            boolean bl = sortOrderRow = !((String)this.getValueAt(i, 4)).trim().equals("") || !((String)this.getValueAt(i, 5)).trim().equals("");
            if (sortOrderRow) {
                this.setValueAt("", i, 4);
                this.setValueAt("", i, 5);
            }
            if (((String)this.getValueAt(i, 7)).trim().equals("") && ((String)this.getValueAt(i, 6)).trim().equals("")) {
                ((DefaultTableModel)this.getModel()).removeRow(i);
            } else if (this.getValueAt(i, 3) != Boolean.FALSE) {
                this.setValueAt(Boolean.FALSE, i, 3);
            }
            if (!sortOrderRow) continue;
            this.generateTableOrderBy(this._queryBuilder._queryModel);
        }
    }

    void removeRows(String tableSpec) {
        Log.getLogger().entering("QueryBuilderInputTable", "removeRows", tableSpec);
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            if (!this.getValueAt(i, 2).equals(tableSpec)) continue;
            ((DefaultTableModel)this.getModel()).removeRow(i);
        }
    }

    void addCriterion(String tableSpec, String columnName, String val, String order) {
        Log.getLogger().entering("QueryBuilderInputTable", "addCriterion", new Object[]{tableSpec, columnName, val});
        boolean foundIt = false;
        int row = 0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!((String)this.getValueAt(i, 2)).equals(tableSpec) || !((String)this.getValueAt(i, 0)).equals(columnName)) continue;
            foundIt = true;
            row = i;
            if (this.getValueAt(i, 6).equals(Criteria_Uneditable_String)) continue;
            this.setValueAt(val, i, 6);
            this.setValueAt(order, i, 7);
            break;
        }
        Object[] rowData = new Object[]{columnName, "", tableSpec, Boolean.FALSE, "", "", val, order};
        if (!foundIt) {
            ((DefaultTableModel)this.getModel()).addRow(rowData);
        }
    }

    void generateTableWhere(QueryModel query) {
        Expression expr;
        boolean needsCriteriaOrder = false;
        int criteriaCount = 0;
        String[] criteriaOrderItems = null;
        Where where = query.getWhere();
        if (where != null && (expr = where.getExpression()) != null) {
            criteriaCount = 1;
            if (expr instanceof Predicate) {
                needsCriteriaOrder = true;
                this.generatePredicateInTableWhere((Predicate)expr, 0, needsCriteriaOrder);
            } else if (expr instanceof And) {
                needsCriteriaOrder = true;
                ExpressionList andExpr = (ExpressionList)expr;
                criteriaCount = andExpr.size();
                for (int i = 0; i < criteriaCount; ++i) {
                    expr = andExpr.getExpression(i);
                    if (!(expr instanceof Predicate)) continue;
                    Predicate pred = (Predicate)expr;
                    this.generatePredicateInTableWhere(pred, i, needsCriteriaOrder);
                }
            }
        }
        criteriaOrderItems = new String[criteriaCount + 1];
        criteriaOrderItems[0] = "";
        TableColumn criteriaOrderColumn = this.getColumnModel().getColumn(7);
        if (needsCriteriaOrder) {
            for (int i = 0; i < criteriaCount; ++i) {
                criteriaOrderItems[i + 1] = String.valueOf(i + 1);
            }
        }
        this._criteriaOrderComboBox = new JComboBox<String>(criteriaOrderItems);
        criteriaOrderColumn.setCellEditor(new DefaultCellEditor(this._criteriaOrderComboBox));
    }

    private void generatePredicateInTableWhere(Predicate pred, int order, boolean needsCriteriaOrder) {
        Value val1 = pred.getVal1();
        Value val2 = pred.getVal2();
        String marker = pred.getVal2().toString();
        if (val1 instanceof Column && !(val2 instanceof Column)) {
            Column col = (Column)val1;
            String tableSpec = col.getTableSpec();
            String columnName = col.getColumnName();
            String val = pred.getOp() + " " + marker;
            int row = this.findRow(tableSpec, columnName);
            if (row != -1) {
                this.setValueAt(val, row, 6);
                if (needsCriteriaOrder) {
                    this.setValueAt(String.valueOf(order + 1), row, 7);
                }
            }
        }
    }

    void generateTableOrderBy(QueryModel query) {
        int sortCount;
        OrderBy orderBy = query.getOrderBy();
        if (orderBy != null) {
            int size = orderBy.getSortSpecificationCount();
            for (int i = 0; i < size; ++i) {
                SortSpecification sortSpec = orderBy.getSortSpecification(i);
                int row = this.findRow(sortSpec.getColumn().getTableSpec(), sortSpec.getColumn().getColumnName());
                if (row == -1) continue;
                if (sortSpec.getDirection().equals("ASC")) {
                    this.setValueAt(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"ASCENDING"), row, 4);
                } else if (sortSpec.getDirection().equals("DESC")) {
                    this.setValueAt(NbBundle.getMessage(QueryBuilderInputTable.class, (String)"DESCENDING"), row, 4);
                }
                this.setValueAt(String.valueOf(i + 1), row, 5);
            }
        }
        if ((sortCount = this._queryBuilder._queryModel.getSortCount()) < this.getRowCount()) {
            ++sortCount;
        }
        if (this._sortOrderComboBox.getItemCount() != sortCount + 1) {
            String[] sortOrderItems = new String[sortCount + 1];
            sortOrderItems[0] = "";
            for (int i = 1; i < sortCount + 1; ++i) {
                sortOrderItems[i] = String.valueOf(i);
            }
            TableColumn sortOrderColumn = this.getColumnModel().getColumn(5);
            this._sortOrderComboBox = new JComboBox<String>(sortOrderItems);
            sortOrderColumn.setCellEditor(new DefaultCellEditor(this._sortOrderComboBox));
            this._sortOrderComboBox.addItemListener(this);
        }
    }

    private int findRow(String tableSpec, String columnName) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getValueAt(i, 2).equals(tableSpec) || !this.getValueAt(i, 0).equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    protected String getClassName(Object o) {
        String classString = o.getClass().getName();
        int dotIndex = classString.lastIndexOf(".");
        return classString.substring(dotIndex + 1);
    }

    void clearModel() {
        ((DefaultTableModel)this.getModel()).setRowCount(0);
    }

    class InputTablePopupListener
    extends MouseAdapter {
        InputTablePopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JTable source = (JTable)e.getSource();
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mousePressed(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                JTable source = (JTable)e.getSource();
                if (!source.isEnabled()) {
                    return;
                }
                QueryBuilderInputTable.this._inputTablePopupRow = source.rowAtPoint(new Point(e.getX(), e.getY()));
                QueryBuilderInputTable.this._inputTablePopupColumn = source.columnAtPoint(new Point(e.getX(), e.getY()));
                if (QueryBuilderInputTable.this._inputTablePopupRow != -1) {
                    source.setRowSelectionInterval(QueryBuilderInputTable.this._inputTablePopupRow, QueryBuilderInputTable.this._inputTablePopupRow);
                }
                QueryBuilderInputTable.this._inputTablePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class FocusCellEditor
    extends DefaultCellEditor {
        Component c;

        public FocusCellEditor(JTextField jtf) {
            super(jtf);
            this.addFocusListener(jtf);
        }

        private void addFocusListener(Component C) {
            super.getComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent fe) {
                    FocusCellEditor.this.lostFocus();
                }
            });
        }

        public void lostFocus() {
            this.stopCellEditing();
        }
    }
}

