/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.requirejs.editor;

import java.util.Set;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.javascript2.requirejs.editor.Bundle;
import org.netbeans.modules.javascript2.requirejs.editor.FSCompletionUtils;
import org.netbeans.modules.javascript2.requirejs.editor.SimpleHandle;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;

public class MappingCompletionItem
implements CompletionProposal {
    private static ImageIcon REQUIREJS_ICON = null;
    private final int anchor;
    private final MappingHandle element;
    private final FileObject mapToFile;

    public MappingCompletionItem(String mapping, FileObject toFile, int anchor) {
        this.element = new MappingHandle(mapping, toFile);
        this.anchor = anchor;
        this.mapToFile = toFile;
    }

    protected String getText() {
        return this.getName();
    }

    public int hashCode() {
        return this.getText().hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MappingCompletionItem)) {
            return false;
        }
        MappingCompletionItem remote = (MappingCompletionItem)o;
        return this.getText().equals(remote.getText());
    }

    public ImageIcon getIcon() {
        if (REQUIREJS_ICON == null) {
            REQUIREJS_ICON = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/javascript2/requirejs/resources/requirejs.png"));
        }
        return REQUIREJS_ICON;
    }

    public int getAnchorOffset() {
        return this.anchor;
    }

    public ElementHandle getElement() {
        return this.element;
    }

    public String getName() {
        return this.element.getName();
    }

    public String getInsertPrefix() {
        return this.getName() + (this.mapToFile != null && this.mapToFile.isFolder() ? "/" : "");
    }

    public String getSortText() {
        return this.getName();
    }

    public String getLhsHtml(HtmlFormatter formatter) {
        return this.getText();
    }

    public String getRhsHtml(HtmlFormatter formatter) {
        return "";
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public boolean isSmart() {
        return false;
    }

    public int getSortPrioOverride() {
        return -1000;
    }

    public String getCustomInsertTemplate() {
        return null;
    }

    private static class MappingHandle
    extends SimpleHandle.DocumentationHandle {
        private final FileObject toFile;

        public MappingHandle(String name, FileObject toFile) {
            super(name, ElementKind.FILE);
            this.toFile = toFile;
        }

        @Override
        public String getDocumentation() {
            StringBuilder sb = new StringBuilder();
            sb.append(Bundle.mappingTo()).append(" ");
            if (this.toFile != null) {
                if (this.toFile.isFolder()) {
                    sb.append(Bundle.mappedFolder());
                } else {
                    sb.append(Bundle.mappedFile());
                }
            } else {
                return Bundle.mappedToVirtual();
            }
            sb.append(FSCompletionUtils.writeFilePathForDocWindow(this.toFile));
            return sb.toString();
        }
    }
}

